package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for defining a `AWS::DynamoDB::Table`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:35.589Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getKeySchema();

    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getAttributeDefinitions();

    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getBillingMode();

    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getGlobalSecondaryIndexes();

    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getLocalSecondaryIndexes();

    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getPointInTimeRecoverySpecification();

    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getProvisionedThroughput();

    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSseSpecification();

    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getStreamSpecification();

    /**
     * `AWS::DynamoDB::Table.TableName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTableName();

    /**
     * `AWS::DynamoDB::Table.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTimeToLiveSpecification();

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.Object keySchema;
        private java.lang.Object attributeDefinitions;
        private java.lang.String billingMode;
        private java.lang.Object globalSecondaryIndexes;
        private java.lang.Object localSecondaryIndexes;
        private java.lang.Object pointInTimeRecoverySpecification;
        private java.lang.Object provisionedThroughput;
        private java.lang.Object sseSpecification;
        private java.lang.Object streamSpecification;
        private java.lang.String tableName;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Object timeToLiveSpecification;

        /**
         * Sets the value of KeySchema
         * @param keySchema `AWS::DynamoDB::Table.KeySchema`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keySchema(software.amazon.awscdk.core.IResolvable keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of KeySchema
         * @param keySchema `AWS::DynamoDB::Table.KeySchema`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keySchema(java.util.List<java.lang.Object> keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of AttributeDefinitions
         * @param attributeDefinitions `AWS::DynamoDB::Table.AttributeDefinitions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder attributeDefinitions(software.amazon.awscdk.core.IResolvable attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of AttributeDefinitions
         * @param attributeDefinitions `AWS::DynamoDB::Table.AttributeDefinitions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder attributeDefinitions(java.util.List<java.lang.Object> attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of BillingMode
         * @param billingMode `AWS::DynamoDB::Table.BillingMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder billingMode(java.lang.String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of GlobalSecondaryIndexes
         * @param globalSecondaryIndexes `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder globalSecondaryIndexes(software.amazon.awscdk.core.IResolvable globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of GlobalSecondaryIndexes
         * @param globalSecondaryIndexes `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder globalSecondaryIndexes(java.util.List<java.lang.Object> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of LocalSecondaryIndexes
         * @param localSecondaryIndexes `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localSecondaryIndexes(software.amazon.awscdk.core.IResolvable localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of LocalSecondaryIndexes
         * @param localSecondaryIndexes `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localSecondaryIndexes(java.util.List<java.lang.Object> localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of PointInTimeRecoverySpecification
         * @param pointInTimeRecoverySpecification `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.core.IResolvable pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of PointInTimeRecoverySpecification
         * @param pointInTimeRecoverySpecification `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of ProvisionedThroughput
         * @param provisionedThroughput `AWS::DynamoDB::Table.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder provisionedThroughput(software.amazon.awscdk.core.IResolvable provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of ProvisionedThroughput
         * @param provisionedThroughput `AWS::DynamoDB::Table.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder provisionedThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of SseSpecification
         * @param sseSpecification `AWS::DynamoDB::Table.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sseSpecification(software.amazon.awscdk.core.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of SseSpecification
         * @param sseSpecification `AWS::DynamoDB::Table.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sseSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of StreamSpecification
         * @param streamSpecification `AWS::DynamoDB::Table.StreamSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamSpecification(software.amazon.awscdk.core.IResolvable streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of StreamSpecification
         * @param streamSpecification `AWS::DynamoDB::Table.StreamSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of TableName
         * @param tableName `AWS::DynamoDB::Table.TableName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::DynamoDB::Table.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of TimeToLiveSpecification
         * @param timeToLiveSpecification `AWS::DynamoDB::Table.TimeToLiveSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeToLiveSpecification(software.amazon.awscdk.core.IResolvable timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Sets the value of TimeToLiveSpecification
         * @param timeToLiveSpecification `AWS::DynamoDB::Table.TimeToLiveSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeToLiveSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnTableProps build() {
            return new Jsii$Proxy(keySchema, attributeDefinitions, billingMode, globalSecondaryIndexes, localSecondaryIndexes, pointInTimeRecoverySpecification, provisionedThroughput, sseSpecification, streamSpecification, tableName, tags, timeToLiveSpecification);
        }

    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.Object keySchema;
        private final java.lang.Object attributeDefinitions;
        private final java.lang.String billingMode;
        private final java.lang.Object globalSecondaryIndexes;
        private final java.lang.Object localSecondaryIndexes;
        private final java.lang.Object pointInTimeRecoverySpecification;
        private final java.lang.Object provisionedThroughput;
        private final java.lang.Object sseSpecification;
        private final java.lang.Object streamSpecification;
        private final java.lang.String tableName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object timeToLiveSpecification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.keySchema = this.jsiiGet("keySchema", java.lang.Object.class);
            this.attributeDefinitions = this.jsiiGet("attributeDefinitions", java.lang.Object.class);
            this.billingMode = this.jsiiGet("billingMode", java.lang.String.class);
            this.globalSecondaryIndexes = this.jsiiGet("globalSecondaryIndexes", java.lang.Object.class);
            this.localSecondaryIndexes = this.jsiiGet("localSecondaryIndexes", java.lang.Object.class);
            this.pointInTimeRecoverySpecification = this.jsiiGet("pointInTimeRecoverySpecification", java.lang.Object.class);
            this.provisionedThroughput = this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            this.sseSpecification = this.jsiiGet("sseSpecification", java.lang.Object.class);
            this.streamSpecification = this.jsiiGet("streamSpecification", java.lang.Object.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.timeToLiveSpecification = this.jsiiGet("timeToLiveSpecification", java.lang.Object.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object keySchema, java.lang.Object attributeDefinitions, java.lang.String billingMode, java.lang.Object globalSecondaryIndexes, java.lang.Object localSecondaryIndexes, java.lang.Object pointInTimeRecoverySpecification, java.lang.Object provisionedThroughput, java.lang.Object sseSpecification, java.lang.Object streamSpecification, java.lang.String tableName, java.util.List<software.amazon.awscdk.core.CfnTag> tags, java.lang.Object timeToLiveSpecification) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keySchema = java.util.Objects.requireNonNull(keySchema, "keySchema is required");
            this.attributeDefinitions = attributeDefinitions;
            this.billingMode = billingMode;
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            this.localSecondaryIndexes = localSecondaryIndexes;
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            this.provisionedThroughput = provisionedThroughput;
            this.sseSpecification = sseSpecification;
            this.streamSpecification = streamSpecification;
            this.tableName = tableName;
            this.tags = tags;
            this.timeToLiveSpecification = timeToLiveSpecification;
        }

        @Override
        public java.lang.Object getKeySchema() {
            return this.keySchema;
        }

        @Override
        public java.lang.Object getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public java.lang.String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public java.lang.Object getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public java.lang.Object getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public java.lang.Object getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public java.lang.Object getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public java.lang.Object getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Object getTimeToLiveSpecification() {
            return this.timeToLiveSpecification;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("keySchema", om.valueToTree(this.getKeySchema()));
            if (this.getAttributeDefinitions() != null) {
                obj.set("attributeDefinitions", om.valueToTree(this.getAttributeDefinitions()));
            }
            if (this.getBillingMode() != null) {
                obj.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getGlobalSecondaryIndexes() != null) {
                obj.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
            }
            if (this.getLocalSecondaryIndexes() != null) {
                obj.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                obj.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getProvisionedThroughput() != null) {
                obj.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
            }
            if (this.getSseSpecification() != null) {
                obj.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getStreamSpecification() != null) {
                obj.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
            }
            if (this.getTableName() != null) {
                obj.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeToLiveSpecification() != null) {
                obj.set("timeToLiveSpecification", om.valueToTree(this.getTimeToLiveSpecification()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!keySchema.equals(that.keySchema)) return false;
            if (this.attributeDefinitions != null ? !this.attributeDefinitions.equals(that.attributeDefinitions) : that.attributeDefinitions != null) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
            if (this.localSecondaryIndexes != null ? !this.localSecondaryIndexes.equals(that.localSecondaryIndexes) : that.localSecondaryIndexes != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.streamSpecification != null ? !this.streamSpecification.equals(that.streamSpecification) : that.streamSpecification != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeToLiveSpecification != null ? this.timeToLiveSpecification.equals(that.timeToLiveSpecification) : that.timeToLiveSpecification == null;
        }

        @Override
        public int hashCode() {
            int result = this.keySchema.hashCode();
            result = 31 * result + (this.attributeDefinitions != null ? this.attributeDefinitions.hashCode() : 0);
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.localSecondaryIndexes != null ? this.localSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.streamSpecification != null ? this.streamSpecification.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeToLiveSpecification != null ? this.timeToLiveSpecification.hashCode() : 0);
            return result;
        }

    }
}
