package software.amazon.awscdk.services.dynamodb;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:35.591Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlobalSecondaryIndexProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SecondaryIndexProps {
    /**
     * The attribute of a partition key for the global secondary index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();

    /**
     * The read capacity for the global secondary index.
     * 
     * Can only be provided if table billingMode is Provisioned or undefined.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getReadCapacity();

    /**
     * The attribute of a sort key for the global secondary index.
     * 
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getSortKey();

    /**
     * The write capacity for the global secondary index.
     * 
     * Can only be provided if table billingMode is Provisioned or undefined.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getWriteCapacity();

    /**
     * @return a {@link Builder} of {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private java.lang.Number readCapacity;
        private software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private java.lang.Number writeCapacity;
        private java.lang.String indexName;
        private java.util.List<java.lang.String> nonKeyAttributes;
        private software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Sets the value of PartitionKey
         * @param partitionKey The attribute of a partition key for the global secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of ReadCapacity
         * @param readCapacity The read capacity for the global secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of SortKey
         * @param sortKey The attribute of a sort key for the global secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of WriteCapacity
         * @param writeCapacity The write capacity for the global secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Sets the value of IndexName
         * @param indexName The name of the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of NonKeyAttributes
         * @param nonKeyAttributes The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        /**
         * Sets the value of ProjectionType
         * @param projectionType The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectionType(software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlobalSecondaryIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public GlobalSecondaryIndexProps build() {
            return new Jsii$Proxy(partitionKey, readCapacity, sortKey, writeCapacity, indexName, nonKeyAttributes, projectionType);
        }

    }

    /**
     * An implementation for {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexProps {
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final java.lang.Number readCapacity;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final java.lang.Number writeCapacity;
        private final java.lang.String indexName;
        private final java.util.List<java.lang.String> nonKeyAttributes;
        private final software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.partitionKey = this.jsiiGet("partitionKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
            this.readCapacity = this.jsiiGet("readCapacity", java.lang.Number.class);
            this.sortKey = this.jsiiGet("sortKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
            this.writeCapacity = this.jsiiGet("writeCapacity", java.lang.Number.class);
            this.indexName = this.jsiiGet("indexName", java.lang.String.class);
            this.nonKeyAttributes = this.jsiiGet("nonKeyAttributes", java.util.List.class);
            this.projectionType = this.jsiiGet("projectionType", software.amazon.awscdk.services.dynamodb.ProjectionType.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.dynamodb.Attribute partitionKey, java.lang.Number readCapacity, software.amazon.awscdk.services.dynamodb.Attribute sortKey, java.lang.Number writeCapacity, java.lang.String indexName, java.util.List<java.lang.String> nonKeyAttributes, software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(partitionKey, "partitionKey is required");
            this.readCapacity = readCapacity;
            this.sortKey = sortKey;
            this.writeCapacity = writeCapacity;
            this.indexName = java.util.Objects.requireNonNull(indexName, "indexName is required");
            this.nonKeyAttributes = nonKeyAttributes;
            this.projectionType = projectionType;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.projectionType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getReadCapacity() != null) {
                obj.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getSortKey() != null) {
                obj.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getWriteCapacity() != null) {
                obj.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            obj.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getNonKeyAttributes() != null) {
                obj.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
            }
            if (this.getProjectionType() != null) {
                obj.set("projectionType", om.valueToTree(this.getProjectionType()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlobalSecondaryIndexProps.Jsii$Proxy that = (GlobalSecondaryIndexProps.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            if (this.writeCapacity != null ? !this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity != null) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
            return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
        }

        @Override
        public int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0);
            result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
            return result;
        }

    }
}
