package software.amazon.awscdk.services.dynamodb;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:04:35.595Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * Partition key attribute definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();

    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     * 
     * Default: Provisioned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode();

    /**
     * Whether point-in-time recovery is enabled.
     * 
     * Default: - point-in-time recovery is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPointInTimeRecovery();

    /**
     * The read capacity for the table.
     * 
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * 
     * Can only be provided if billingMode is Provisioned.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getReadCapacity();

    /**
     * The removal policy to apply to the DynamoDB Table.
     * 
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy();

    /**
     * Whether server-side encryption with an AWS managed customer master key is enabled.
     * 
     * Default: - server-side encryption is enabled with an AWS owned customer master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getServerSideEncryption();

    /**
     * Table sort key attribute definition.
     * 
     * Default: no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getSortKey();

    /**
     * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
     * 
     * Default: undefined, streams are disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.StreamViewType getStream();

    /**
     * The name of TTL attribute.
     * 
     * Default: - TTL is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTimeToLiveAttribute();

    /**
     * The write capacity for the table.
     * 
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * 
     * Can only be provided if billingMode is Provisioned.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getWriteCapacity();

    /**
     * @return a {@link Builder} of {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private java.lang.Boolean pointInTimeRecovery;
        private java.lang.Number readCapacity;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private java.lang.Boolean serverSideEncryption;
        private software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private java.lang.String timeToLiveAttribute;
        private java.lang.Number writeCapacity;

        /**
         * Sets the value of PartitionKey
         * @param partitionKey Partition key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of BillingMode
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of PointInTimeRecovery
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of ReadCapacity
         * @param readCapacity The read capacity for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of RemovalPolicy
         * @param removalPolicy The removal policy to apply to the DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of ServerSideEncryption
         * @param serverSideEncryption Whether server-side encryption with an AWS managed customer master key is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(java.lang.Boolean serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of SortKey
         * @param sortKey Table sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of Stream
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of TimeToLiveAttribute
         * @param timeToLiveAttribute The name of TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(java.lang.String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        /**
         * Sets the value of WriteCapacity
         * @param writeCapacity The write capacity for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TableOptions build() {
            return new Jsii$Proxy(partitionKey, billingMode, pointInTimeRecovery, readCapacity, removalPolicy, serverSideEncryption, sortKey, stream, timeToLiveAttribute, writeCapacity);
        }

    }

    /**
     * An implementation for {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableOptions {
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private final java.lang.Boolean pointInTimeRecovery;
        private final java.lang.Number readCapacity;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.Boolean serverSideEncryption;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private final java.lang.String timeToLiveAttribute;
        private final java.lang.Number writeCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.partitionKey = this.jsiiGet("partitionKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
            this.billingMode = this.jsiiGet("billingMode", software.amazon.awscdk.services.dynamodb.BillingMode.class);
            this.pointInTimeRecovery = this.jsiiGet("pointInTimeRecovery", java.lang.Boolean.class);
            this.readCapacity = this.jsiiGet("readCapacity", java.lang.Number.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.serverSideEncryption = this.jsiiGet("serverSideEncryption", java.lang.Boolean.class);
            this.sortKey = this.jsiiGet("sortKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
            this.stream = this.jsiiGet("stream", software.amazon.awscdk.services.dynamodb.StreamViewType.class);
            this.timeToLiveAttribute = this.jsiiGet("timeToLiveAttribute", java.lang.String.class);
            this.writeCapacity = this.jsiiGet("writeCapacity", java.lang.Number.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.dynamodb.Attribute partitionKey, software.amazon.awscdk.services.dynamodb.BillingMode billingMode, java.lang.Boolean pointInTimeRecovery, java.lang.Number readCapacity, software.amazon.awscdk.core.RemovalPolicy removalPolicy, java.lang.Boolean serverSideEncryption, software.amazon.awscdk.services.dynamodb.Attribute sortKey, software.amazon.awscdk.services.dynamodb.StreamViewType stream, java.lang.String timeToLiveAttribute, java.lang.Number writeCapacity) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(partitionKey, "partitionKey is required");
            this.billingMode = billingMode;
            this.pointInTimeRecovery = pointInTimeRecovery;
            this.readCapacity = readCapacity;
            this.removalPolicy = removalPolicy;
            this.serverSideEncryption = serverSideEncryption;
            this.sortKey = sortKey;
            this.stream = stream;
            this.timeToLiveAttribute = timeToLiveAttribute;
            this.writeCapacity = writeCapacity;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.billingMode;
        }

        @Override
        public java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public java.lang.Boolean getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
            return this.stream;
        }

        @Override
        public java.lang.String getTimeToLiveAttribute() {
            return this.timeToLiveAttribute;
        }

        @Override
        public java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getBillingMode() != null) {
                obj.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getPointInTimeRecovery() != null) {
                obj.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getReadCapacity() != null) {
                obj.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getRemovalPolicy() != null) {
                obj.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getServerSideEncryption() != null) {
                obj.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getSortKey() != null) {
                obj.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getStream() != null) {
                obj.set("stream", om.valueToTree(this.getStream()));
            }
            if (this.getTimeToLiveAttribute() != null) {
                obj.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
            }
            if (this.getWriteCapacity() != null) {
                obj.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableOptions.Jsii$Proxy that = (TableOptions.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) return false;
            if (this.timeToLiveAttribute != null ? !this.timeToLiveAttribute.equals(that.timeToLiveAttribute) : that.timeToLiveAttribute != null) return false;
            return this.writeCapacity != null ? this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity == null;
        }

        @Override
        public int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.stream != null ? this.stream.hashCode() : 0);
            result = 31 * result + (this.timeToLiveAttribute != null ? this.timeToLiveAttribute.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            return result;
        }

    }
}
