/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.dynamodb.;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.EnableScalingProps;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.IScalableTableAttribute;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.SystemErrorsForOperationsMetricOptions;
import software.amazon.awscdk.services.dynamodb.TableAttributes;
import software.amazon.awscdk.services.dynamodb.TableEncryption;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.Table")
public class Table
extends Resource
implements ITable {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(@NotNull Construct scope, @NotNull String id, @NotNull TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableArn", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableAttributes", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ITable fromTableName(@NotNull Construct scope, @NotNull String id, @NotNull String tableName) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableName", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableName, "tableName is required")});
    }

    @Deprecated
    @NotNull
    public static Grant grantListStreams(@NotNull IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Table.class, (String)"grantListStreams", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public void addGlobalSecondaryIndex(@NotNull GlobalSecondaryIndexProps props) {
        Kernel.call((Object)this, (String)"addGlobalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(@NotNull LocalSecondaryIndexProps props) {
        Kernel.call((Object)this, (String)"addLocalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleGlobalSecondaryIndexReadCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleGlobalSecondaryIndexWriteCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleReadCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleReadCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleWriteCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)Kernel.call((Object)this, (String)"autoScaleWriteCapacity", (NativeType)NativeType.forClass(IScalableTableAttribute.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantFullAccess(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantFullAccess", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadData(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWriteData(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadWriteData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantStream(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)Kernel.call((Object)this, (String)"grantStream", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantStreamRead(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantStreamRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantTableListStreams(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantTableListStreams", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWriteData(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantWriteData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConditionalCheckFailedRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests() {
        return (Metric)Kernel.call((Object)this, (String)"metricConditionalCheckFailedRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedReadCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedReadCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedWriteCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedWriteCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccessfulRequestLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccessfulRequestLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @Deprecated
    @NotNull
    public Metric metricSystemErrors(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSystemErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @Deprecated
    @NotNull
    public Metric metricSystemErrors() {
        return (Metric)Kernel.call((Object)this, (String)"metricSystemErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public IMetric metricSystemErrorsForOperations(@Nullable SystemErrorsForOperationsMetricOptions props) {
        return (IMetric)Kernel.call((Object)this, (String)"metricSystemErrorsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public IMetric metricSystemErrorsForOperations() {
        return (IMetric)Kernel.call((Object)this, (String)"metricSystemErrorsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricUserErrors(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricUserErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricUserErrors() {
        return (Metric)Kernel.call((Object)this, (String)"metricUserErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    protected Boolean getHasIndex() {
        return (Boolean)Kernel.get((Object)this, (String)"hasIndex", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    protected List<String> getRegionalArns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"regionalArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)Kernel.get((Object)this, (String)"tableArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public String getTableStreamArn() {
        return (String)Kernel.get((Object)this, (String)"tableStreamArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Table> {
        private final Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder replicationRegions(List<String> replicationRegions) {
            this.props.replicationRegions(replicationRegions);
            return this;
        }

        @Deprecated
        public Builder serverSideEncryption(Boolean serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

