/**
 * <h1>Amazon DynamoDB Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Here is a minimal deployable DynamoDB table definition:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING())));
 * </pre></blockquote>
 * <p>
 * <h2>Importing existing tables</h2>
 * <p>
 * To import an existing table into your CDK application, use the <code>Table.fromTableName</code>, <code>Table.fromTableArn</code> or <code>Table.fromTableAttributes</code>
 * factory method. This method accepts table name or table ARN which describes the properties of an already
 * existing table:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object table = Table.fromTableArn(this, "ImportedTable", "arn:aws:dynamodb:us-east-1:111111111:table/my-table");
 * // now you can just call methods on the table
 * table.grantReadWriteData(user);
 * </pre></blockquote>
 * <p>
 * If you intend to use the <code>tableStreamArn</code> (including indirectly, for example by creating an
 * <code>&#64;aws-cdk/aws-lambda-event-source.DynamoEventSource</code> on the imported table), you <em>must</em> use the
 * <code>Table.fromTableAttributes</code> method and the <code>tableStreamArn</code> property <em>must</em> be populated.
 * <p>
 * <h2>Keys</h2>
 * <p>
 * When a table is defined, you must define it's schema using the <code>partitionKey</code>
 * (required) and <code>sortKey</code> (optional) properties.
 * <p>
 * <h2>Billing Mode</h2>
 * <p>
 * DynamoDB supports two billing modes:
 * <p>
 * <ul>
 * <li>PROVISIONED - the default mode where the table and global secondary indexes have configured read and write capacity.</li>
 * <li>PAY_PER_REQUEST - on-demand pricing and scaling. You only pay for what you use and there is no read and write capacity for the table or its global secondary indexes.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .billingMode(dynamodb.BillingMode.getPAY_PER_REQUEST()));
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.
 * <p>
 * <h2>Configure AutoScaling for your table</h2>
 * <p>
 * You can have DynamoDB automatically raise and lower the read and write capacities
 * of your table by setting up autoscaling. You can use this to either keep your
 * tables at a desired utilization level, or by scaling up and down at preconfigured
 * times of the day:
 * <p>
 * Auto-scaling is only relevant for tables with the billing mode, PROVISIONED.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IScalableTableAttribute readScaling = table.autoScaleReadCapacity(new EnableScalingProps().minCapacity(1).maxCapacity(50));
 * 
 * readScaling.scaleOnUtilization(new UtilizationScalingProps()
 *         .targetUtilizationPercent(50));
 * 
 * readScaling.scaleOnSchedule("ScaleUpInTheMorning", new ScalingSchedule()
 *         .schedule(appscaling.Schedule.cron(new CronOptions().hour("8").minute("0")))
 *         .minCapacity(20));
 * 
 * readScaling.scaleOnSchedule("ScaleDownAtNight", new ScalingSchedule()
 *         .schedule(appscaling.Schedule.cron(new CronOptions().hour("20").minute("0")))
 *         .maxCapacity(20));
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html
 * https://aws.amazon.com/blogs/database/how-to-use-aws-cloudformation-to-configure-auto-scaling-for-amazon-dynamodb-tables-and-indexes/
 * <p>
 * <h2>Amazon DynamoDB Global Tables</h2>
 * <p>
 * You can create DynamoDB Global Tables by setting the <code>replicationRegions</code> property on a <code>Table</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table globalTable = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .replicationRegions(asList("us-east-1", "us-east-2", "us-west-2")));
 * </pre></blockquote>
 * <p>
 * When doing so, a CloudFormation Custom Resource will be added to the stack in order to create the replica tables in the
 * selected regions.
 * <p>
 * The default billing mode for Global Tables is <code>PAY_PER_REQUEST</code>.
 * If you want to use <code>PROVISIONED</code>,
 * you have to make sure write auto-scaling is enabled for that Table:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Map.of("name", "id", "type", dynamodb.AttributeType.getSTRING()))
 *         .replicationRegions(asList("us-east-1", "us-east-2", "us-west-2"))
 *         .billingMode(BillingMode.getPROVISIONED())
 *         .build();
 * 
 * globalTable.autoScaleWriteCapacity({
 *   minCapacity: 1,
 *   maxCapacity: 10,
 * }).scaleOnUtilization(Map.of("targetUtilizationPercent", 75));
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * All user data stored in Amazon DynamoDB is fully encrypted at rest. When creating a new table, you can choose to encrypt using the following customer master keys (CMK) to encrypt your table:
 * <p>
 * <ul>
 * <li>AWS owned CMK - By default, all tables are encrypted under an AWS owned customer master key (CMK) in the DynamoDB service account (no additional charges apply).</li>
 * <li>AWS managed CMK - AWS KMS keys (one per region) are created in your account, managed, and used on your behalf by AWS DynamoDB (AWS KMS chages apply).</li>
 * <li>Customer managed CMK - You have full control over the KMS key used to encrypt the DynamoDB Table (AWS KMS charges apply).</li>
 * </ul>
 * <p>
 * Creating a Table encrypted with a customer managed CMK:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(stack, "MyTable", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .encryption(TableEncryption.getCUSTOMER_MANAGED()));
 * 
 * // You can access the CMK that was added to the stack on your behalf by the Table construct via:
 * Object tableEncryptionKey = table.getEncryptionKey();
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.kms.*;
 * 
 * Key encryptionKey = new Key(stack, "Key", new KeyProps()
 *         .enableKeyRotation(true));
 * Table table = new Table(stack, "MyTable", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .encryption(TableEncryption.getCUSTOMER_MANAGED())
 *         .encryptionKey(encryptionKey));
 * </pre></blockquote>
 * <p>
 * In order to use the AWS managed CMK instead, change the code to:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(stack, "MyTable", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .encryption(TableEncryption.getAWS_MANAGED()));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.dynamodb;
