package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for a DynamoDB Table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-17T22:29:44.570Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableProps")
@software.amazon.jsii.Jsii.Proxy(TableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.TableOptions {

    /**
     * Enforces a particular physical table name.
     * <p>
     * Default: <generated>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableProps> {
        private java.lang.String tableName;
        private software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.lang.Boolean pointInTimeRecovery;
        private java.lang.Number readCapacity;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private java.util.List<java.lang.String> replicationRegions;
        private java.lang.Boolean serverSideEncryption;
        private software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private java.lang.String timeToLiveAttribute;
        private java.lang.Number writeCapacity;

        /**
         * Sets the value of {@link TableProps#getTableName}
         * @param tableName Enforces a particular physical table name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getBillingMode}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryption}
         * @param encryption Whether server-side encryption with an AWS managed customer master key is enabled.
         *                   This property cannot be set if <code>serverSideEncryption</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.dynamodb.TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for table encryption.
         *                      This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getReadCapacity}
         * @param readCapacity The read capacity for the table.
         *                     Careful if you add Global Secondary Indexes, as
         *                     those will share the table's provisioned throughput.
         *                     <p>
         *                     Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getReplicationRegions}
         * @param replicationRegions Regions where replica tables will be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicationRegions(java.util.List<java.lang.String> replicationRegions) {
            this.replicationRegions = replicationRegions;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getServerSideEncryption}
         * @param serverSideEncryption Whether server-side encryption with an AWS managed customer master key is enabled.
         *                             This property cannot be set if <code>encryption</code> and/or <code>encryptionKey</code> is set.
         * @return {@code this}
         * @deprecated This property is deprecated. In order to obtain the same behavior as
enabling this, set the `encryption` property to `TableEncryption.AWS_MANAGED` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder serverSideEncryption(java.lang.Boolean serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getSortKey}
         * @param sortKey Table sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getStream}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTimeToLiveAttribute}
         * @param timeToLiveAttribute The name of TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(java.lang.String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getWriteCapacity}
         * @param writeCapacity The write capacity for the table.
         *                      Careful if you add Global Secondary Indexes, as
         *                      those will share the table's provisioned throughput.
         *                      <p>
         *                      Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableProps build() {
            return new Jsii$Proxy(tableName, partitionKey, billingMode, encryption, encryptionKey, pointInTimeRecovery, readCapacity, removalPolicy, replicationRegions, serverSideEncryption, sortKey, stream, timeToLiveAttribute, writeCapacity);
        }
    }

    /**
     * An implementation for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableProps {
        private final java.lang.String tableName;
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private final software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean pointInTimeRecovery;
        private final java.lang.Number readCapacity;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<java.lang.String> replicationRegions;
        private final java.lang.Boolean serverSideEncryption;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private final java.lang.String timeToLiveAttribute;
        private final java.lang.Number writeCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.BillingMode.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.replicationRegions = software.amazon.jsii.Kernel.get(this, "replicationRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serverSideEncryption = software.amazon.jsii.Kernel.get(this, "serverSideEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.StreamViewType.class));
            this.timeToLiveAttribute = software.amazon.jsii.Kernel.get(this, "timeToLiveAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String tableName, final software.amazon.awscdk.services.dynamodb.Attribute partitionKey, final software.amazon.awscdk.services.dynamodb.BillingMode billingMode, final software.amazon.awscdk.services.dynamodb.TableEncryption encryption, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.lang.Boolean pointInTimeRecovery, final java.lang.Number readCapacity, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final java.util.List<java.lang.String> replicationRegions, final java.lang.Boolean serverSideEncryption, final software.amazon.awscdk.services.dynamodb.Attribute sortKey, final software.amazon.awscdk.services.dynamodb.StreamViewType stream, final java.lang.String timeToLiveAttribute, final java.lang.Number writeCapacity) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableName = tableName;
            this.partitionKey = java.util.Objects.requireNonNull(partitionKey, "partitionKey is required");
            this.billingMode = billingMode;
            this.encryption = encryption;
            this.encryptionKey = encryptionKey;
            this.pointInTimeRecovery = pointInTimeRecovery;
            this.readCapacity = readCapacity;
            this.removalPolicy = removalPolicy;
            this.replicationRegions = replicationRegions;
            this.serverSideEncryption = serverSideEncryption;
            this.sortKey = sortKey;
            this.stream = stream;
            this.timeToLiveAttribute = timeToLiveAttribute;
            this.writeCapacity = writeCapacity;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getReplicationRegions() {
            return this.replicationRegions;
        }

        @Override
        public final java.lang.Boolean getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
            return this.stream;
        }

        @Override
        public final java.lang.String getTimeToLiveAttribute() {
            return this.timeToLiveAttribute;
        }

        @Override
        public final java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicationRegions() != null) {
                data.set("replicationRegions", om.valueToTree(this.getReplicationRegions()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getStream() != null) {
                data.set("stream", om.valueToTree(this.getStream()));
            }
            if (this.getTimeToLiveAttribute() != null) {
                data.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
            }
            if (this.getWriteCapacity() != null) {
                data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.TableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableProps.Jsii$Proxy that = (TableProps.Jsii$Proxy) o;

            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (!partitionKey.equals(that.partitionKey)) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicationRegions != null ? !this.replicationRegions.equals(that.replicationRegions) : that.replicationRegions != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) return false;
            if (this.timeToLiveAttribute != null ? !this.timeToLiveAttribute.equals(that.timeToLiveAttribute) : that.timeToLiveAttribute != null) return false;
            return this.writeCapacity != null ? this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tableName != null ? this.tableName.hashCode() : 0;
            result = 31 * result + (this.partitionKey.hashCode());
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicationRegions != null ? this.replicationRegions.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.stream != null ? this.stream.hashCode() : 0);
            result = 31 * result + (this.timeToLiveAttribute != null ? this.timeToLiveAttribute.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            return result;
        }
    }
}
