package software.amazon.awscdk.services.dynamodb;

/**
 * Provides a DynamoDB table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-23T11:52:28.574Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.Table")
public class Table extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.dynamodb.ITable {

    protected Table(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Table(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table arn.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableArn The table's ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableArn, "tableArn is required") });
    }

    /**
     * Creates a Table construct that represents an external table.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A `TableAttributes` object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table name.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableName The table's name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableName, "tableName is required") });
    }

    /**
     * (deprecated) Permits an IAM Principal to list all DynamoDB Streams.
     * <p>
     * @deprecated Use {@link #grantTableListStreams} for more granular permission
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantListStreams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "grantListStreams", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Add a global secondary index of table.
     * <p>
     * @param props the property of global secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addGlobalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps props) {
        software.amazon.jsii.Kernel.call(this, "addGlobalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a local secondary index of table.
     * <p>
     * @param props the property of local secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLocalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps props) {
        software.amazon.jsii.Kernel.call(this, "addLocalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(final @org.jetbrains.annotations.NotNull java.lang.String indexName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleGlobalSecondaryIndexReadCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(final @org.jetbrains.annotations.NotNull java.lang.String indexName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleGlobalSecondaryIndexWriteCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleReadCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleReadCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleWriteCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleWriteCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantFullAccess(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantFullAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * <p>
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWriteData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table's stream to an IAM principal's policy.
     * <p>
     * If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:DescribeStream", "dynamodb:GetRecords", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grantStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStreamRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantStreamRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM Principal to list streams attached to current dynamodb table.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantTableListStreams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantTableListStreams", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWriteData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Return the given named metric for this Table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the conditional check failed requests this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConditionalCheckFailedRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the conditional check failed requests this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests() {
        return software.amazon.jsii.Kernel.call(this, "metricConditionalCheckFailedRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the consumed read capacity units this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedReadCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the consumed read capacity units this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedReadCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the consumed write capacity units this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedWriteCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the consumed write capacity units this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedWriteCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the successful request latency this table.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessfulRequestLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the successful request latency this table.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessfulRequestLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) Metric for the system errors this table.
     * <p>
     * @deprecated use `metricSystemErrorsForOperations`.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) Metric for the system errors this table.
     * <p>
     * @deprecated use `metricSystemErrorsForOperations`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors() {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the system errors this table.
     * <p>
     * This will sum errors across all possible operations.
     * Note that by default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricSystemErrorsForOperations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.SystemErrorsForOperationsMetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrorsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class), new Object[] { props });
    }

    /**
     * Metric for the system errors this table.
     * <p>
     * This will sum errors across all possible operations.
     * Note that by default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricSystemErrorsForOperations() {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrorsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
    }

    /**
     * How many requests are throttled on this table.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * How many requests are throttled on this table.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledRequests() {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the user errors.
     * <p>
     * Note that this metric reports user errors across all
     * the tables in the account and region the table resides in.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricUserErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the user errors.
     * <p>
     * Note that this metric reports user errors across all
     * the tables in the account and region the table resides in.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors() {
        return software.amazon.jsii.Kernel.call(this, "metricUserErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Validate the table construct.
     * <p>
     * @return an array of validation error message
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Whether this table has indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getHasIndex() {
        return software.amazon.jsii.Kernel.get(this, "hasIndex", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegionalArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "regionalArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Arn of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
        return software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Table name of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * KMS encryption key, if this table uses a customer-managed encryption key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * ARN of the table's stream, if there is one.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.Table}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.Table> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.TableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.TableProps.Builder();
        }

        /**
         * Partition key attribute definition.
         * <p>
         * @return {@code this}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(final software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * <p>
         * Default: PROVISIONED if `replicationRegions` is not specified, PAY_PER_REQUEST otherwise
         * <p>
         * @return {@code this}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * Whether server-side encryption with an AWS managed customer master key is enabled.
         * <p>
         * This property cannot be set if <code>serverSideEncryption</code> is set.
         * <p>
         * Default: - server-side encryption is enabled with an AWS owned customer master key
         * <p>
         * @return {@code this}
         * @param encryption Whether server-side encryption with an AWS managed customer master key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.dynamodb.TableEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for table encryption.
         * <p>
         * This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
         * <p>
         * Default: - If `encryption` is set to `TableEncryption.CUSTOMER_MANAGED` and this
         * property is undefined, a new KMS key will be created and associated with this table.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for table encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Whether point-in-time recovery is enabled.
         * <p>
         * Default: - point-in-time recovery is disabled
         * <p>
         * @return {@code this}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(final java.lang.Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        /**
         * The read capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param readCapacity The read capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(final java.lang.Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        /**
         * The removal policy to apply to the DynamoDB Table.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) Regions where replica tables will be created.
         * <p>
         * Default: - no replica tables are created
         * <p>
         * @return {@code this}
         * @param replicationRegions Regions where replica tables will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicationRegions(final java.util.List<java.lang.String> replicationRegions) {
            this.props.replicationRegions(replicationRegions);
            return this;
        }

        /**
         * (deprecated) Whether server-side encryption with an AWS managed customer master key is enabled.
         * <p>
         * This property cannot be set if <code>encryption</code> and/or <code>encryptionKey</code> is set.
         * <p>
         * Default: - server-side encryption is enabled with an AWS owned customer master key
         * <p>
         * @return {@code this}
         * @deprecated This property is deprecated. In order to obtain the same behavior as
         * enabling this, set the `encryption` property to `TableEncryption.AWS_MANAGED` instead.
         * @param serverSideEncryption Whether server-side encryption with an AWS managed customer master key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder serverSideEncryption(final java.lang.Boolean serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        /**
         * Table sort key attribute definition.
         * <p>
         * Default: no sort key
         * <p>
         * @return {@code this}
         * @param sortKey Table sort key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(final software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * <p>
         * Default: - streams are disabled unless `replicationRegions` is specified
         * <p>
         * @return {@code this}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(final software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        /**
         * The name of TTL attribute.
         * <p>
         * Default: - TTL is disabled
         * <p>
         * @return {@code this}
         * @param timeToLiveAttribute The name of TTL attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(final java.lang.String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        /**
         * The write capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param writeCapacity The write capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(final java.lang.Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        /**
         * Enforces a particular physical table name.
         * <p>
         * Default: <generated>
         * <p>
         * @return {@code this}
         * @param tableName Enforces a particular physical table name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.dynamodb.Table}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.Table build() {
            return new software.amazon.awscdk.services.dynamodb.Table(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
