package software.amazon.awscdk.services.dynamodb;

/**
 * Options for configuring a system errors metric that considers multiple operations.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-04-01T14:12:13.786Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.SystemErrorsForOperationsMetricOptions")
@software.amazon.jsii.Jsii.Proxy(SystemErrorsForOperationsMetricOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SystemErrorsForOperationsMetricOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricOptions {

    /**
     * The operations to apply the metric to.
     * <p>
     * Default: - All operations available by DynamoDB tables will be considered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.Operation> getOperations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SystemErrorsForOperationsMetricOptions> {
        private java.util.List<software.amazon.awscdk.services.dynamodb.Operation> operations;
        private java.lang.String account;
        private java.lang.String color;
        private java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private java.lang.String label;
        private software.amazon.awscdk.core.Duration period;
        private java.lang.String region;
        private java.lang.String statistic;
        private software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getOperations}
         * @param operations The operations to apply the metric to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder operations(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Operation> operations) {
            this.operations = (java.util.List<software.amazon.awscdk.services.dynamodb.Operation>)operations;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getDimensions}
         * @param dimensions Dimensions of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dimensions(java.util.Map<java.lang.String, ? extends java.lang.Object> dimensions) {
            this.dimensions = (java.util.Map<java.lang.String, java.lang.Object>)dimensions;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getPeriod}
         * @param period The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.core.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getUnit}
         * @param unit Unit used to filter the metric stream.
         *             Only refer to datums emitted to the metric stream with the given unit and
         *             ignore all others. Only useful when datums are being emitted to the same
         *             metric stream under different units.
         *             <p>
         *             The default is to use all matric datums in the stream, regardless of unit,
         *             which is recommended in nearly all cases.
         *             <p>
         *             CloudWatch does not honor this property for graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SystemErrorsForOperationsMetricOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SystemErrorsForOperationsMetricOptions build() {
            return new Jsii$Proxy(operations, account, color, dimensions, label, period, region, statistic, unit);
        }
    }

    /**
     * An implementation for {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemErrorsForOperationsMetricOptions {
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Operation> operations;
        private final java.lang.String account;
        private final java.lang.String color;
        private final java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private final java.lang.String label;
        private final software.amazon.awscdk.core.Duration period;
        private final java.lang.String region;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.operations = software.amazon.jsii.Kernel.get(this, "operations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Operation.class)));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.dynamodb.Operation> operations, final java.lang.String account, final java.lang.String color, final java.util.Map<java.lang.String, ? extends java.lang.Object> dimensions, final java.lang.String label, final software.amazon.awscdk.core.Duration period, final java.lang.String region, final java.lang.String statistic, final software.amazon.awscdk.services.cloudwatch.Unit unit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.operations = (java.util.List<software.amazon.awscdk.services.dynamodb.Operation>)operations;
            this.account = account;
            this.color = color;
            this.dimensions = (java.util.Map<java.lang.String, java.lang.Object>)dimensions;
            this.label = label;
            this.period = period;
            this.region = region;
            this.statistic = statistic;
            this.unit = unit;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Operation> getOperations() {
            return this.operations;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.unit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOperations() != null) {
                data.set("operations", om.valueToTree(this.getOperations()));
            }
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.SystemErrorsForOperationsMetricOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SystemErrorsForOperationsMetricOptions.Jsii$Proxy that = (SystemErrorsForOperationsMetricOptions.Jsii$Proxy) o;

            if (this.operations != null ? !this.operations.equals(that.operations) : that.operations != null) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.operations != null ? this.operations.hashCode() : 0;
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
