package software.amazon.awscdk.services.ec2.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:45:19.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.VPNConnectionResource")
public class VPNConnectionResource extends software.amazon.awscdk.Resource {
    protected VPNConnectionResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::VPNConnection``.
     * @param parent the ``cdk.Construct`` this ``VPNConnectionResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``VPNConnectionResource``
     */
    public VPNConnectionResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResourceProps.class);
    }

    public java.lang.String getVpnConnectionName() {
        return this.jsiiGet("vpnConnectionName", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     */
    public static interface VpnTunnelOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        java.lang.Object getPreSharedKey();
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        void setPreSharedKey(final java.lang.String value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        void setPreSharedKey(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        java.lang.Object getTunnelInsideCidr();
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        void setTunnelInsideCidr(final java.lang.String value);
        /**
         * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        void setTunnelInsideCidr(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link VpnTunnelOptionsSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpnTunnelOptionsSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _preSharedKey;
            @javax.annotation.Nullable
            private java.lang.Object _tunnelInsideCidr;

            /**
             * Sets the value of PreSharedKey
             * @param value ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @return {@code this}
             */
            public Builder withPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
                this._preSharedKey = value;
                return this;
            }
            /**
             * Sets the value of PreSharedKey
             * @param value ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @return {@code this}
             */
            public Builder withPreSharedKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._preSharedKey = value;
                return this;
            }
            /**
             * Sets the value of TunnelInsideCidr
             * @param value ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @return {@code this}
             */
            public Builder withTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
                this._tunnelInsideCidr = value;
                return this;
            }
            /**
             * Sets the value of TunnelInsideCidr
             * @param value ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @return {@code this}
             */
            public Builder withTunnelInsideCidr(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._tunnelInsideCidr = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpnTunnelOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpnTunnelOptionsSpecificationProperty build() {
                return new VpnTunnelOptionsSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $preSharedKey = _preSharedKey;
                    @javax.annotation.Nullable
                    private java.lang.Object $tunnelInsideCidr = _tunnelInsideCidr;

                    @Override
                    public java.lang.Object getPreSharedKey() {
                        return this.$preSharedKey;
                    }

                    @Override
                    public void setPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$preSharedKey = value;
                    }

                    @Override
                    public void setPreSharedKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$preSharedKey = value;
                    }

                    @Override
                    public java.lang.Object getTunnelInsideCidr() {
                        return this.$tunnelInsideCidr;
                    }

                    @Override
                    public void setTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
                        this.$tunnelInsideCidr = value;
                    }

                    @Override
                    public void setTunnelInsideCidr(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$tunnelInsideCidr = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.VpnTunnelOptionsSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPreSharedKey() {
                return this.jsiiGet("preSharedKey", java.lang.Object.class);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            @Override
            public void setPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("preSharedKey", value);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.PreSharedKey``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
             */
            @Override
            public void setPreSharedKey(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("preSharedKey", value);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTunnelInsideCidr() {
                return this.jsiiGet("tunnelInsideCidr", java.lang.Object.class);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            @Override
            public void setTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("tunnelInsideCidr", value);
            }

            /**
             * ``VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
             */
            @Override
            public void setTunnelInsideCidr(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("tunnelInsideCidr", value);
            }
        }
    }
}
