package software.amazon.awscdk.services.ec2;

/**
 * Manage the allowed network connections for constructs with Security Groups.
 * 
 * Security Groups can be thought of as a firewall for network-connected
 * devices. This class makes it easy to allow network connections to and
 * from security groups, and between security groups individually. When
 * establishing connectivity between security groups, it will automatically
 * add rules in both security groups
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-12T09:53:43.787Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Connections")
public class Connections extends software.amazon.jsii.JsiiObject {
    protected Connections(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Connections(final software.amazon.awscdk.services.ec2.ConnectionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Allow connections from the peer on our default port
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow connections from the peer on our default port
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")).toArray());
    }

    /**
     * Allow default connections from all IPv4 ranges
     */
    public void allowDefaultPortFromAnyIpv4(@javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class, java.util.stream.Stream.of(description).toArray());
    }

    /**
     * Allow default connections from all IPv4 ranges
     */
    public void allowDefaultPortFromAnyIpv4() {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class);
    }

    /**
     * Allow hosts inside the security group to connect to each other
     */
    public void allowDefaultPortInternally(@javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortInternally", Void.class, java.util.stream.Stream.of(description).toArray());
    }

    /**
     * Allow hosts inside the security group to connect to each other
     */
    public void allowDefaultPortInternally() {
        this.jsiiCall("allowDefaultPortInternally", Void.class);
    }

    /**
     * Allow connections from the peer on our default port
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortTo", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow connections from the peer on our default port
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortTo", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")).toArray());
    }

    /**
     * Allow connections from the peer on the given port
     */
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowFrom", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow connections from the peer on the given port
     */
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowFrom", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))).toArray());
    }

    /**
     * Allow from any IPv4 ranges
     */
    public void allowFromAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowFromAnyIPv4", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow from any IPv4 ranges
     */
    public void allowFromAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowFromAnyIPv4", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")).toArray());
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port
     */
    public void allowInternally(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowInternally", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port
     */
    public void allowInternally(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowInternally", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")).toArray());
    }

    /**
     * Allow connections to the peer on the given port
     */
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowTo", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow connections to the peer on the given port
     */
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowTo", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))).toArray());
    }

    /**
     * Allow to all IPv4 ranges
     */
    public void allowToAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowToAnyIPv4", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow to all IPv4 ranges
     */
    public void allowToAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowToAnyIPv4", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")).toArray());
    }

    /**
     * Allow connections to the security group on their default port
     */
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowToDefaultPort", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Allow connections to the security group on their default port
     */
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowToDefaultPort", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")).toArray());
    }

    /**
     * The rule that defines how to represent this peer in a security group
     */
    public software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule() {
        return this.jsiiGet("securityGroupRule", software.amazon.awscdk.services.ec2.ISecurityGroupRule.class);
    }

    /**
     * The default port configured for this connection peer, if available
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
        return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
    }

    /**
     * Underlying securityGroup for this Connections object, if present
     * 
     * May be empty if this Connections object is not managing a SecurityGroup,
     * but simply representing a Connectable peer.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.ec2.SecurityGroupRef getSecurityGroup() {
        return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.SecurityGroupRef.class);
    }
}
