package software.amazon.awscdk.services.ec2.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-12T09:53:43.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource")
public class LaunchTemplateResource extends software.amazon.awscdk.Resource {
    protected LaunchTemplateResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::LaunchTemplate``.
     * @param parent the ``cdk.Construct`` this ``LaunchTemplateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``LaunchTemplateResource``
     */
    public LaunchTemplateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::EC2::LaunchTemplate``.
     * @param parent the ``cdk.Construct`` this ``LaunchTemplateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public LaunchTemplateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute DefaultVersionNumber
     */
    public java.lang.String getLaunchTemplateDefaultVersionNumber() {
        return this.jsiiGet("launchTemplateDefaultVersionNumber", java.lang.String.class);
    }

    public java.lang.String getLaunchTemplateId() {
        return this.jsiiGet("launchTemplateId", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute LatestVersionNumber
     */
    public java.lang.String getLaunchTemplateLatestVersionNumber() {
        return this.jsiiGet("launchTemplateLatestVersionNumber", java.lang.String.class);
    }

    public software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        java.lang.Object getDeviceName();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        void setDeviceName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        java.lang.Object getNoDevice();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        void setNoDevice(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        java.lang.Object getVirtualName();
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        void setVirtualName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        void setVirtualName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.Object _noDevice;
            @javax.annotation.Nullable
            private java.lang.Object _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @return {@code this}
             */
            public Builder withDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                this._deviceName = value;
                return this;
            }
            /**
             * Sets the value of DeviceName
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @return {@code this}
             */
            public Builder withDeviceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deviceName = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deviceName = _deviceName;
                    @javax.annotation.Nullable
                    private java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private java.lang.Object $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private java.lang.Object $virtualName = _virtualName;

                    @Override
                    public java.lang.Object getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deviceName = value;
                    }

                    @Override
                    public void setDeviceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deviceName = value;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public java.lang.Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public java.lang.Object getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$virtualName = value;
                    }

                    @Override
                    public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$virtualName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @Override
            public void setDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deviceName", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @Override
            public void setDeviceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceName", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @Override
            public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("noDevice", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @Override
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noDevice", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @Override
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }

            /**
             * ``LaunchTemplateResource.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @Override
            public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        java.lang.Object getCpuCredits();
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        void setCpuCredits(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        void setCpuCredits(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param value ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @return {@code this}
             */
            public Builder withCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this._cpuCredits = value;
                return this;
            }
            /**
             * Sets the value of CpuCredits
             * @param value ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @return {@code this}
             */
            public Builder withCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cpuCredits = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $cpuCredits = _cpuCredits;

                    @Override
                    public java.lang.Object getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    @Override
                    public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cpuCredits = value;
                    }

                    @Override
                    public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cpuCredits = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @Override
            public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cpuCredits", value);
            }

            /**
             * ``LaunchTemplateResource.CreditSpecificationProperty.CpuCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @Override
            public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cpuCredits", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        java.lang.Object getIops();
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        java.lang.Object getKmsKeyId();
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        void setKmsKeyId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        void setKmsKeyId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        java.lang.Object getSnapshotId();
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        void setSnapshotId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        java.lang.Object getVolumeType();
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        void setVolumeType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        void setVolumeType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Object _iops;
            @javax.annotation.Nullable
            private java.lang.Object _kmsKeyId;
            @javax.annotation.Nullable
            private java.lang.Object _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Object _volumeSize;
            @javax.annotation.Nullable
            private java.lang.Object _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``LaunchTemplateResource.EbsProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``LaunchTemplateResource.EbsProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of KmsKeyId
             * @param value ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @return {@code this}
             */
            public Builder withKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsKeyId = value;
                return this;
            }
            /**
             * Sets the value of KmsKeyId
             * @param value ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @return {@code this}
             */
            public Builder withKmsKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kmsKeyId = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EbsProperty build() {
                return new EbsProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private java.lang.Object $iops = _iops;
                    @javax.annotation.Nullable
                    private java.lang.Object $kmsKeyId = _kmsKeyId;
                    @javax.annotation.Nullable
                    private java.lang.Object $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private java.lang.Object $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private java.lang.Object $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public java.lang.Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$iops = value;
                    }

                    @Override
                    public java.lang.Object getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public void setKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$kmsKeyId = value;
                    }

                    @Override
                    public void setKmsKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kmsKeyId = value;
                    }

                    @Override
                    public java.lang.Object getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public java.lang.Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public java.lang.Object getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$volumeType = value;
                    }

                    @Override
                    public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$volumeType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKmsKeyId() {
                return this.jsiiGet("kmsKeyId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @Override
            public void setKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kmsKeyId", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.KmsKeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @Override
            public void setKmsKeyId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kmsKeyId", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @Override
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @Override
            public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("snapshotId", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @Override
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }

            /**
             * ``LaunchTemplateResource.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @Override
            public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        java.lang.Object getType();
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        void setType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        void setType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _type;

            /**
             * Sets the value of Type
             * @param value ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$type = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``LaunchTemplateResource.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        java.lang.Object getArn();
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        void setArn(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        void setArn(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        java.lang.Object getName();
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        void setName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        void setName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _arn;
            @javax.annotation.Nullable
            private java.lang.Object _name;

            /**
             * Sets the value of Arn
             * @param value ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @return {@code this}
             */
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }
            /**
             * Sets the value of Arn
             * @param value ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @return {@code this}
             */
            public Builder withArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._arn = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $arn = _arn;
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;

                    @Override
                    public java.lang.Object getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$arn = value;
                    }

                    @Override
                    public void setArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$arn = value;
                    }

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getArn() {
                return this.jsiiGet("arn", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @Override
            public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("arn", value);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @Override
            public void setArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("arn", value);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``LaunchTemplateResource.IamInstanceProfileProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        java.lang.Object getMarketType();
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        void setMarketType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        void setMarketType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        java.lang.Object getSpotOptions();
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        void setSpotOptions(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        void setSpotOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value);

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _marketType;
            @javax.annotation.Nullable
            private java.lang.Object _spotOptions;

            /**
             * Sets the value of MarketType
             * @param value ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @return {@code this}
             */
            public Builder withMarketType(@javax.annotation.Nullable final java.lang.String value) {
                this._marketType = value;
                return this;
            }
            /**
             * Sets the value of MarketType
             * @param value ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @return {@code this}
             */
            public Builder withMarketType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._marketType = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @return {@code this}
             */
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._spotOptions = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @return {@code this}
             */
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $marketType = _marketType;
                    @javax.annotation.Nullable
                    private java.lang.Object $spotOptions = _spotOptions;

                    @Override
                    public java.lang.Object getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public void setMarketType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$marketType = value;
                    }

                    @Override
                    public void setMarketType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$marketType = value;
                    }

                    @Override
                    public java.lang.Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    @Override
                    public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$spotOptions = value;
                    }

                    @Override
                    public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                        this.$spotOptions = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMarketType() {
                return this.jsiiGet("marketType", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @Override
            public void setMarketType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("marketType", value);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.MarketType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @Override
            public void setMarketType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("marketType", value);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSpotOptions() {
                return this.jsiiGet("spotOptions", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @Override
            public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotOptions", value);
            }

            /**
             * ``LaunchTemplateResource.InstanceMarketOptionsProperty.SpotOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @Override
            public void setSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty value) {
                this.jsiiSet("spotOptions", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link Ipv6AddProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                this._ipv6Address = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Address
             * @param value ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Address = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public Ipv6AddProperty build() {
                return new Ipv6AddProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6Address = _ipv6Address;

                    @Override
                    public java.lang.Object getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                        this.$ipv6Address = value;
                    }

                    @Override
                    public void setIpv6Address(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6Address = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.Ipv6AddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @Override
            public void setIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ipv6Address", value);
            }

            /**
             * ``LaunchTemplateResource.Ipv6AddProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @Override
            public void setIpv6Address(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        void setBlockDeviceMappings(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        void setBlockDeviceMappings(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        java.lang.Object getCreditSpecification();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        void setCreditSpecification(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        void setCreditSpecification(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        java.lang.Object getDisableApiTermination();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        void setDisableApiTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        void setDisableApiTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        void setEbsOptimized(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        void setEbsOptimized(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        java.lang.Object getElasticGpuSpecifications();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        void setElasticGpuSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        void setElasticGpuSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        java.lang.Object getImageId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        void setImageId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        void setImageId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        java.lang.Object getInstanceInitiatedShutdownBehavior();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        void setInstanceInitiatedShutdownBehavior(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        void setInstanceInitiatedShutdownBehavior(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        java.lang.Object getInstanceMarketOptions();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        void setInstanceMarketOptions(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        void setInstanceMarketOptions(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        java.lang.Object getInstanceType();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        void setInstanceType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        java.lang.Object getKernelId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        void setKernelId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        void setKernelId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        java.lang.Object getKeyName();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        void setKeyName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        void setKeyName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        void setNetworkInterfaces(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        void setNetworkInterfaces(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        java.lang.Object getPlacement();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        void setPlacement(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        void setPlacement(final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        java.lang.Object getRamDiskId();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        void setRamDiskId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        void setRamDiskId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        java.lang.Object getSecurityGroupIds();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        void setSecurityGroupIds(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        void setSecurityGroupIds(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        java.lang.Object getSecurityGroups();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        void setSecurityGroups(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        void setSecurityGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        void setTagSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        void setTagSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        java.lang.Object getUserData();
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        void setUserData(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        void setUserData(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _creditSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _disableApiTermination;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _elasticGpuSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.Object _imageId;
            @javax.annotation.Nullable
            private java.lang.Object _instanceInitiatedShutdownBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _instanceMarketOptions;
            @javax.annotation.Nullable
            private java.lang.Object _instanceType;
            @javax.annotation.Nullable
            private java.lang.Object _kernelId;
            @javax.annotation.Nullable
            private java.lang.Object _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.Object _ramDiskId;
            @javax.annotation.Nullable
            private java.lang.Object _securityGroupIds;
            @javax.annotation.Nullable
            private java.lang.Object _securityGroups;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _userData;

            /**
             * Sets the value of BlockDeviceMappings
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @return {@code this}
             */
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @return {@code this}
             */
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @return {@code this}
             */
            public Builder withDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @return {@code this}
             */
            public Builder withDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @return {@code this}
             */
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @return {@code this}
             */
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of ImageId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @return {@code this}
             */
            public Builder withImageId(@javax.annotation.Nullable final java.lang.String value) {
                this._imageId = value;
                return this;
            }
            /**
             * Sets the value of ImageId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @return {@code this}
             */
            public Builder withImageId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._imageId = value;
                return this;
            }
            /**
             * Sets the value of InstanceInitiatedShutdownBehavior
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @return {@code this}
             */
            public Builder withInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstanceInitiatedShutdownBehavior
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @return {@code this}
             */
            public Builder withInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @return {@code this}
             */
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @return {@code this}
             */
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @return {@code this}
             */
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @return {@code this}
             */
            public Builder withKernelId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @return {@code this}
             */
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @return {@code this}
             */
            public Builder withKeyName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamDiskId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @return {@code this}
             */
            public Builder withRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramDiskId = value;
                return this;
            }
            /**
             * Sets the value of RamDiskId
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @return {@code this}
             */
            public Builder withRamDiskId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ramDiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @return {@code this}
             */
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @return {@code this}
             */
            public Builder withUserData(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._userData = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private java.lang.Object $creditSpecification = _creditSpecification;
                    @javax.annotation.Nullable
                    private java.lang.Object $disableApiTermination = _disableApiTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private java.lang.Object $elasticGpuSpecifications = _elasticGpuSpecifications;
                    @javax.annotation.Nullable
                    private java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private java.lang.Object $imageId = _imageId;
                    @javax.annotation.Nullable
                    private java.lang.Object $instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                    @javax.annotation.Nullable
                    private java.lang.Object $instanceMarketOptions = _instanceMarketOptions;
                    @javax.annotation.Nullable
                    private java.lang.Object $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private java.lang.Object $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private java.lang.Object $keyName = _keyName;
                    @javax.annotation.Nullable
                    private java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private java.lang.Object $ramDiskId = _ramDiskId;
                    @javax.annotation.Nullable
                    private java.lang.Object $securityGroupIds = _securityGroupIds;
                    @javax.annotation.Nullable
                    private java.lang.Object $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private java.lang.Object $userData = _userData;

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public java.lang.Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public java.lang.Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public void setDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public void setDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public java.lang.Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public java.lang.Object getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$imageId = value;
                    }

                    @Override
                    public void setImageId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$imageId = value;
                    }

                    @Override
                    public java.lang.Object getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                        this.$instanceInitiatedShutdownBehavior = value;
                    }

                    @Override
                    public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$instanceInitiatedShutdownBehavior = value;
                    }

                    @Override
                    public java.lang.Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public java.lang.Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public void setInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public java.lang.Object getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public void setKernelId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public java.lang.Object getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public void setKeyName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$keyName = value;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public java.lang.Object getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public void setRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$ramDiskId = value;
                    }

                    @Override
                    public void setRamDiskId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ramDiskId = value;
                    }

                    @Override
                    public java.lang.Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public java.lang.Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public java.lang.Object getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                        this.$userData = value;
                    }

                    @Override
                    public void setUserData(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$userData = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.LaunchTemplateDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @Override
            public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockDeviceMappings", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @Override
            public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("blockDeviceMappings", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCreditSpecification() {
                return this.jsiiGet("creditSpecification", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @Override
            public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("creditSpecification", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.CreditSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @Override
            public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty value) {
                this.jsiiSet("creditSpecification", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDisableApiTermination() {
                return this.jsiiGet("disableApiTermination", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @Override
            public void setDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("disableApiTermination", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.DisableApiTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @Override
            public void setDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("disableApiTermination", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @Override
            public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ebsOptimized", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @Override
            public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebsOptimized", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElasticGpuSpecifications() {
                return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @Override
            public void setElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("elasticGpuSpecifications", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ElasticGpuSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @Override
            public void setElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("elasticGpuSpecifications", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @Override
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iamInstanceProfile", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @Override
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty value) {
                this.jsiiSet("iamInstanceProfile", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getImageId() {
                return this.jsiiGet("imageId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @Override
            public void setImageId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("imageId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @Override
            public void setImageId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("imageId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstanceInitiatedShutdownBehavior() {
                return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @Override
            public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceInitiatedShutdownBehavior", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @Override
            public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceInitiatedShutdownBehavior", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstanceMarketOptions() {
                return this.jsiiGet("instanceMarketOptions", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @Override
            public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceMarketOptions", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceMarketOptions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @Override
            public void setInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty value) {
                this.jsiiSet("instanceMarketOptions", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @Override
            public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceType", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @Override
            public void setInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceType", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKernelId() {
                return this.jsiiGet("kernelId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @Override
            public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kernelId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @Override
            public void setKernelId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kernelId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKeyName() {
                return this.jsiiGet("keyName", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @Override
            public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyName", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @Override
            public void setKeyName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyName", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @Override
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("monitoring", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @Override
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty value) {
                this.jsiiSet("monitoring", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @Override
            public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaces", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @Override
            public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("networkInterfaces", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @Override
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("placement", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @Override
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty value) {
                this.jsiiSet("placement", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRamDiskId() {
                return this.jsiiGet("ramDiskId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @Override
            public void setRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ramDiskId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.RamDiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @Override
            public void setRamDiskId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ramDiskId", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroupIds", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroupIds", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @Override
            public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroups", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @Override
            public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroups", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @Override
            public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagSpecifications", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @Override
            public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagSpecifications", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getUserData() {
                return this.jsiiGet("userData", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @Override
            public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("userData", value);
            }

            /**
             * ``LaunchTemplateResource.LaunchTemplateDataProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @Override
            public void setUserData(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("userData", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.MonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MonitoringProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MonitoringProperty build() {
                return new MonitoringProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``LaunchTemplateResource.MonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        java.lang.Object getDescription();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        void setDeviceIndex(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        java.lang.Object getGroups();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        void setGroups(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        void setGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        java.lang.Object getNetworkInterfaceId();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _description;
            @javax.annotation.Nullable
            private java.lang.Object _deviceIndex;
            @javax.annotation.Nullable
            private java.lang.Object _groups;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Object _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private java.lang.Object $groups = _groups;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private java.lang.Object $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddress = _privateIpAddress;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private java.lang.Object $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private java.lang.Object $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public java.lang.Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public java.lang.Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public java.lang.Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public java.lang.Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$subnetId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @Override
            public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("deviceIndex", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @Override
            public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGroups() {
                return this.jsiiGet("groups", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @Override
            public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groups", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @Override
            public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groups", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @Override
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @Override
            public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaceId", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }

            /**
             * ``LaunchTemplateResource.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        java.lang.Object getAffinity();
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        void setAffinity(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Affinity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        void setAffinity(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        java.lang.Object getAvailabilityZone();
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        void setAvailabilityZone(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        java.lang.Object getGroupName();
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        void setGroupName(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        void setGroupName(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        java.lang.Object getHostId();
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        void setHostId(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.HostId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        void setHostId(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        java.lang.Object getTenancy();
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        void setTenancy(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        void setTenancy(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PlacementProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _affinity;
            @javax.annotation.Nullable
            private java.lang.Object _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.Object _groupName;
            @javax.annotation.Nullable
            private java.lang.Object _hostId;
            @javax.annotation.Nullable
            private java.lang.Object _tenancy;

            /**
             * Sets the value of Affinity
             * @param value ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @return {@code this}
             */
            public Builder withAffinity(@javax.annotation.Nullable final java.lang.String value) {
                this._affinity = value;
                return this;
            }
            /**
             * Sets the value of Affinity
             * @param value ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @return {@code this}
             */
            public Builder withAffinity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._affinity = value;
                return this;
            }
            /**
             * Sets the value of AvailabilityZone
             * @param value ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of AvailabilityZone
             * @param value ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of HostId
             * @param value ``LaunchTemplateResource.PlacementProperty.HostId``
             * @return {@code this}
             */
            public Builder withHostId(@javax.annotation.Nullable final java.lang.String value) {
                this._hostId = value;
                return this;
            }
            /**
             * Sets the value of HostId
             * @param value ``LaunchTemplateResource.PlacementProperty.HostId``
             * @return {@code this}
             */
            public Builder withHostId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._hostId = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @return {@code this}
             */
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @return {@code this}
             */
            public Builder withTenancy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PlacementProperty build() {
                return new PlacementProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $affinity = _affinity;
                    @javax.annotation.Nullable
                    private java.lang.Object $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private java.lang.Object $groupName = _groupName;
                    @javax.annotation.Nullable
                    private java.lang.Object $hostId = _hostId;
                    @javax.annotation.Nullable
                    private java.lang.Object $tenancy = _tenancy;

                    @Override
                    public java.lang.Object getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public void setAffinity(@javax.annotation.Nullable final java.lang.String value) {
                        this.$affinity = value;
                    }

                    @Override
                    public void setAffinity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$affinity = value;
                    }

                    @Override
                    public java.lang.Object getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public void setAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public java.lang.Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$groupName = value;
                    }

                    @Override
                    public java.lang.Object getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public void setHostId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$hostId = value;
                    }

                    @Override
                    public void setHostId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$hostId = value;
                    }

                    @Override
                    public java.lang.Object getTenancy() {
                        return this.$tenancy;
                    }

                    @Override
                    public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
                        this.$tenancy = value;
                    }

                    @Override
                    public void setTenancy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tenancy = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAffinity() {
                return this.jsiiGet("affinity", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @Override
            public void setAffinity(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("affinity", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Affinity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @Override
            public void setAffinity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("affinity", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @Override
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @Override
            public void setAvailabilityZone(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("availabilityZone", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGroupName() {
                return this.jsiiGet("groupName", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @Override
            public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("groupName", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @Override
            public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupName", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHostId() {
                return this.jsiiGet("hostId", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @Override
            public void setHostId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("hostId", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.HostId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @Override
            public void setHostId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("hostId", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTenancy() {
                return this.jsiiGet("tenancy", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @Override
            public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("tenancy", value);
            }

            /**
             * ``LaunchTemplateResource.PlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @Override
            public void setTenancy(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tenancy", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _primary;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $primary = _primary;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddress = _privateIpAddress;

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$primary = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddress = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PrivateIpAddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @Override
            public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("primary", value);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @Override
            public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", value);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }

            /**
             * ``LaunchTemplateResource.PrivateIpAddProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        java.lang.Object getInstanceInterruptionBehavior();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        void setInstanceInterruptionBehavior(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        void setInstanceInterruptionBehavior(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        java.lang.Object getMaxPrice();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        void setMaxPrice(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        void setMaxPrice(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        java.lang.Object getSpotInstanceType();
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        void setSpotInstanceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        void setSpotInstanceType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _maxPrice;
            @javax.annotation.Nullable
            private java.lang.Object _spotInstanceType;

            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of MaxPrice
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @return {@code this}
             */
            public Builder withMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._maxPrice = value;
                return this;
            }
            /**
             * Sets the value of MaxPrice
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @return {@code this}
             */
            public Builder withMaxPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxPrice = value;
                return this;
            }
            /**
             * Sets the value of SpotInstanceType
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @return {@code this}
             */
            public Builder withSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._spotInstanceType = value;
                return this;
            }
            /**
             * Sets the value of SpotInstanceType
             * @param value ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @return {@code this}
             */
            public Builder withSpotInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._spotInstanceType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotOptionsProperty build() {
                return new SpotOptionsProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxPrice = _maxPrice;
                    @javax.annotation.Nullable
                    private java.lang.Object $spotInstanceType = _spotInstanceType;

                    @Override
                    public java.lang.Object getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public java.lang.Object getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public void setMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public void setMaxPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public java.lang.Object getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    @Override
                    public void setSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$spotInstanceType = value;
                    }

                    @Override
                    public void setSpotInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$spotInstanceType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @Override
            public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceInterruptionBehavior", value);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @Override
            public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("instanceInterruptionBehavior", value);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxPrice() {
                return this.jsiiGet("maxPrice", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @Override
            public void setMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("maxPrice", value);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.MaxPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @Override
            public void setMaxPrice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxPrice", value);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSpotInstanceType() {
                return this.jsiiGet("spotInstanceType", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @Override
            public void setSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotInstanceType", value);
            }

            /**
             * ``LaunchTemplateResource.SpotOptionsProperty.SpotInstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @Override
            public void setSpotInstanceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("spotInstanceType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        java.lang.Object getResourceType();
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        void setResourceType(final java.lang.String value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        void setResourceType(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        java.lang.Object getTags();
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        void setTags(final software.amazon.awscdk.Token value);
        /**
         * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        void setTags(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _resourceType;
            @javax.annotation.Nullable
            private java.lang.Object _tags;

            /**
             * Sets the value of ResourceType
             * @param value ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of ResourceType
             * @param value ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tags = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagSpecificationProperty build() {
                return new TagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private java.lang.Object $tags = _tags;

                    @Override
                    public java.lang.Object getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public void setResourceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public java.lang.Object getTags() {
                        return this.$tags;
                    }

                    @Override
                    public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tags = value;
                    }

                    @Override
                    public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tags = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.TagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResourceType() {
                return this.jsiiGet("resourceType", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @Override
            public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceType", value);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @Override
            public void setResourceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourceType", value);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTags() {
                return this.jsiiGet("tags", java.lang.Object.class);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @Override
            public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tags", value);
            }

            /**
             * ``LaunchTemplateResource.TagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @Override
            public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tags", value);
            }
        }
    }
}
