package software.amazon.awscdk.services.ec2;

/**
 * The goal of this module is to make possible to write statements like this:
 * 
 *   ```ts
 *  *  database.connections.allowFrom(fleet);
 *  *  fleet.connections.allowTo(database);
 *  *  rdgw.connections.allowFromCidrIp('0.3.1.5/86');
 *  *  rgdw.connections.allowTrafficTo(fleet, new AllPorts());
 *  *  ```
 * 
 * The insight here is that some connecting peers have information on what ports should
 * be involved in the connection, and some don't.
 * An object that has a Connections object
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T13:57:01.203Z")
public interface IConnectable extends software.amazon.jsii.JsiiSerializable {
    software.amazon.awscdk.services.ec2.Connections getConnections();

    /**
     * @return a {@link Builder} of {@link IConnectable}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IConnectable}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.Connections _connections;

        /**
         * Sets the value of Connections
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withConnections(final software.amazon.awscdk.services.ec2.Connections value) {
            this._connections = java.util.Objects.requireNonNull(value, "connections is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IConnectable}
         * @throws NullPointerException if any required attribute was not provided
         */
        public IConnectable build() {
            return new IConnectable() {
                private final software.amazon.awscdk.services.ec2.Connections $connections = java.util.Objects.requireNonNull(_connections, "connections is required");

                @Override
                public software.amazon.awscdk.services.ec2.Connections getConnections() {
                    return this.$connections;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }
    }
}
