package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T12:14:31.993Z")
public interface ConnectionRule extends software.amazon.jsii.JsiiSerializable {
    /**
     * Start of port range for the TCP and UDP protocols, or an ICMP type number.
     * 
     * If you specify icmp for the IpProtocol property, you can specify
     * -1 as a wildcard (i.e., any ICMP type number).
     */
    java.lang.Number getFromPort();
    /**
     * Start of port range for the TCP and UDP protocols, or an ICMP type number.
     * 
     * If you specify icmp for the IpProtocol property, you can specify
     * -1 as a wildcard (i.e., any ICMP type number).
     */
    void setFromPort(final java.lang.Number value);
    /**
     * Description of this connection. It is applied to both the ingress rule
     * and the egress rule.
     * @default No description
     */
    java.lang.String getDescription();
    /**
     * Description of this connection. It is applied to both the ingress rule
     * and the egress rule.
     * @default No description
     */
    void setDescription(final java.lang.String value);
    /**
     * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
     * Use -1 to specify all protocols. If you specify -1, or a protocol number
     * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
     * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
     * must specify a port range. For protocol 58 (ICMPv6), you can optionally
     * specify a port range; if you don't, traffic for all types and codes is
     * allowed.
     * @default tcp
     */
    java.lang.String getProtocol();
    /**
     * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
     * Use -1 to specify all protocols. If you specify -1, or a protocol number
     * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
     * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
     * must specify a port range. For protocol 58 (ICMPv6), you can optionally
     * specify a port range; if you don't, traffic for all types and codes is
     * allowed.
     * @default tcp
     */
    void setProtocol(final java.lang.String value);
    /**
     * End of port range for the TCP and UDP protocols, or an ICMP code.
     * 
     * If you specify icmp for the IpProtocol property, you can specify -1 as a
     * wildcard (i.e., any ICMP code).
     * @default If toPort is not specified, it will be the same as fromPort.
     */
    java.lang.Number getToPort();
    /**
     * End of port range for the TCP and UDP protocols, or an ICMP code.
     * 
     * If you specify icmp for the IpProtocol property, you can specify -1 as a
     * wildcard (i.e., any ICMP code).
     * @default If toPort is not specified, it will be the same as fromPort.
     */
    void setToPort(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link ConnectionRule}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ConnectionRule}
     */
    final class Builder {
        private java.lang.Number _fromPort;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _protocol;
        @javax.annotation.Nullable
        private java.lang.Number _toPort;

        /**
         * Sets the value of FromPort
         * @param value Start of port range for the TCP and UDP protocols, or an ICMP type number.

If you specify icmp for the IpProtocol property, you can specify
-1 as a wildcard (i.e., any ICMP type number).
         * @return {@code this}
         */
        public Builder withFromPort(final java.lang.Number value) {
            this._fromPort = java.util.Objects.requireNonNull(value, "fromPort is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value Description of this connection. It is applied to both the ingress rule
and the egress rule.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
Use -1 to specify all protocols. If you specify -1, or a protocol number
other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
must specify a port range. For protocol 58 (ICMPv6), you can optionally
specify a port range; if you don't, traffic for all types and codes is
allowed.
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of ToPort
         * @param value End of port range for the TCP and UDP protocols, or an ICMP code.

If you specify icmp for the IpProtocol property, you can specify -1 as a
wildcard (i.e., any ICMP code).
         * @return {@code this}
         */
        public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._toPort = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ConnectionRule build() {
            return new ConnectionRule() {
                private java.lang.Number $fromPort = java.util.Objects.requireNonNull(_fromPort, "fromPort is required");
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.String $protocol = _protocol;
                @javax.annotation.Nullable
                private java.lang.Number $toPort = _toPort;

                @Override
                public java.lang.Number getFromPort() {
                    return this.$fromPort;
                }

                @Override
                public void setFromPort(final java.lang.Number value) {
                    this.$fromPort = java.util.Objects.requireNonNull(value, "fromPort is required");
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.String getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                    this.$protocol = value;
                }

                @Override
                public java.lang.Number getToPort() {
                    return this.$toPort;
                }

                @Override
                public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$toPort = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ConnectionRule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Start of port range for the TCP and UDP protocols, or an ICMP type number.
         * 
         * If you specify icmp for the IpProtocol property, you can specify
         * -1 as a wildcard (i.e., any ICMP type number).
         */
        @Override
        public java.lang.Number getFromPort() {
            return this.jsiiGet("fromPort", java.lang.Number.class);
        }

        /**
         * Start of port range for the TCP and UDP protocols, or an ICMP type number.
         * 
         * If you specify icmp for the IpProtocol property, you can specify
         * -1 as a wildcard (i.e., any ICMP type number).
         */
        @Override
        public void setFromPort(final java.lang.Number value) {
            this.jsiiSet("fromPort", java.util.Objects.requireNonNull(value, "fromPort is required"));
        }

        /**
         * Description of this connection. It is applied to both the ingress rule
         * and the egress rule.
         * @default No description
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Description of this connection. It is applied to both the ingress rule
         * and the egress rule.
         * @default No description
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
         * Use -1 to specify all protocols. If you specify -1, or a protocol number
         * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
         * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
         * must specify a port range. For protocol 58 (ICMPv6), you can optionally
         * specify a port range; if you don't, traffic for all types and codes is
         * allowed.
         * @default tcp
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getProtocol() {
            return this.jsiiGet("protocol", java.lang.String.class);
        }

        /**
         * The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
         * Use -1 to specify all protocols. If you specify -1, or a protocol number
         * other than tcp, udp, icmp, or 58 (ICMPv6), traffic on all ports is
         * allowed, regardless of any ports you specify. For tcp, udp, and icmp, you
         * must specify a port range. For protocol 58 (ICMPv6), you can optionally
         * specify a port range; if you don't, traffic for all types and codes is
         * allowed.
         * @default tcp
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * End of port range for the TCP and UDP protocols, or an ICMP code.
         * 
         * If you specify icmp for the IpProtocol property, you can specify -1 as a
         * wildcard (i.e., any ICMP code).
         * @default If toPort is not specified, it will be the same as fromPort.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getToPort() {
            return this.jsiiGet("toPort", java.lang.Number.class);
        }

        /**
         * End of port range for the TCP and UDP protocols, or an ICMP code.
         * 
         * If you specify icmp for the IpProtocol property, you can specify -1 as a
         * wildcard (i.e., any ICMP code).
         * @default If toPort is not specified, it will be the same as fromPort.
         */
        @Override
        public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("toPort", value);
        }
    }
}
