package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a VPC to be built
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-08T13:06:01.360Z")
public interface SubnetConfiguration extends software.amazon.jsii.JsiiSerializable {
    /**
     * The common Logical Name for the `VpcSubnet`
     * 
     * Thi name will be suffixed with an integer correlating to a specific
     * availability zone.
     */
    java.lang.String getName();
    /**
     * The common Logical Name for the `VpcSubnet`
     * 
     * Thi name will be suffixed with an integer correlating to a specific
     * availability zone.
     */
    void setName(final java.lang.String value);
    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();
    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value);
    /**
     * The CIDR Mask or the number of leading 1 bits in the routing mask
     * 
     * Valid values are 16 - 28
     */
    java.lang.Number getCidrMask();
    /**
     * The CIDR Mask or the number of leading 1 bits in the routing mask
     * 
     * Valid values are 16 - 28
     */
    void setCidrMask(final java.lang.Number value);
    /**
     * The AWS resource tags to associate with the resource.
     */
    java.util.Map<java.lang.String, java.lang.String> getTags();
    /**
     * The AWS resource tags to associate with the resource.
     */
    void setTags(final java.util.Map<java.lang.String, java.lang.String> value);

    /**
     * @return a {@link Builder} of {@link SubnetConfiguration}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SubnetConfiguration}
     */
    final class Builder {
        private java.lang.String _name;
        private software.amazon.awscdk.services.ec2.SubnetType _subnetType;
        @javax.annotation.Nullable
        private java.lang.Number _cidrMask;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _tags;

        /**
         * Sets the value of Name
         * @param value The common Logical Name for the `VpcSubnet`

Thi name will be suffixed with an integer correlating to a specific
availability zone.
         * @return {@code this}
         */
        public Builder withName(final java.lang.String value) {
            this._name = java.util.Objects.requireNonNull(value, "name is required");
            return this;
        }
        /**
         * Sets the value of SubnetType
         * @param value The type of Subnet to configure.

The Subnet type will control the ability to route and connect to the
Internet.
         * @return {@code this}
         */
        public Builder withSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            this._subnetType = java.util.Objects.requireNonNull(value, "subnetType is required");
            return this;
        }
        /**
         * Sets the value of CidrMask
         * @param value The CIDR Mask or the number of leading 1 bits in the routing mask

Valid values are 16 - 28
         * @return {@code this}
         */
        public Builder withCidrMask(@javax.annotation.Nullable final java.lang.Number value) {
            this._cidrMask = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value The AWS resource tags to associate with the resource.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SubnetConfiguration build() {
            return new SubnetConfiguration() {
                private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                private software.amazon.awscdk.services.ec2.SubnetType $subnetType = java.util.Objects.requireNonNull(_subnetType, "subnetType is required");
                @javax.annotation.Nullable
                private java.lang.Number $cidrMask = _cidrMask;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $tags = _tags;

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public void setName(final java.lang.String value) {
                    this.$name = java.util.Objects.requireNonNull(value, "name is required");
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
                    return this.$subnetType;
                }

                @Override
                public void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
                    this.$subnetType = java.util.Objects.requireNonNull(value, "subnetType is required");
                }

                @Override
                public java.lang.Number getCidrMask() {
                    return this.$cidrMask;
                }

                @Override
                public void setCidrMask(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$cidrMask = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getTags() {
                    return this.$tags;
                }

                @Override
                public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$tags = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SubnetConfiguration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The common Logical Name for the `VpcSubnet`
         * 
         * Thi name will be suffixed with an integer correlating to a specific
         * availability zone.
         */
        @Override
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The common Logical Name for the `VpcSubnet`
         * 
         * Thi name will be suffixed with an integer correlating to a specific
         * availability zone.
         */
        @Override
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }

        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        @Override
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }

        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        @Override
        public void setSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            this.jsiiSet("subnetType", java.util.Objects.requireNonNull(value, "subnetType is required"));
        }

        /**
         * The CIDR Mask or the number of leading 1 bits in the routing mask
         * 
         * Valid values are 16 - 28
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getCidrMask() {
            return this.jsiiGet("cidrMask", java.lang.Number.class);
        }

        /**
         * The CIDR Mask or the number of leading 1 bits in the routing mask
         * 
         * Valid values are 16 - 28
         */
        @Override
        public void setCidrMask(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("cidrMask", value);
        }

        /**
         * The AWS resource tags to associate with the resource.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.jsiiGet("tags", java.util.Map.class);
        }

        /**
         * The AWS resource tags to associate with the resource.
         */
        @Override
        public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("tags", value);
        }
    }
}
