package software.amazon.awscdk.services.ec2;

/**
 * The type of Subnet
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T19:56:02.668Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetType")
public enum SubnetType {
    /**
     * Isolated Subnets do not route Outbound traffic
     * 
     * This can be good for subnets with RDS or
     * Elasticache endpoints
     */
    Isolated,
    /**
     * Subnet that routes to the internet, but not vice versa.
     * 
     * Instances in a private subnet can connect to the Internet, but will not
     * allow connections to be initiated from the Internet.
     * 
     * Outbound traffic will be routed via a NAT Gateway. Preference being in
     * the same AZ, but if not available will use another AZ (control by
     * specifing `maxGateways` on VpcNetwork). This might be used for
     * experimental cost conscious accounts or accounts where HA outbound
     * traffic is not needed.
     */
    Private,
    /**
     * Subnet connected to the Internet
     * 
     * Instances in a Public subnet can connect to the Internet and can be
     * connected to from the Internet as long as they are launched with public
     * IPs (controlled on the AutoScalingGroup or other constructs that launch
     * instances).
     * 
     * Public subnets route outbound traffic via an Internet Gateway.
     */
    Public,
}
