package software.amazon.awscdk.services.ec2.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-14T09:49:44.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResource")
public class SecurityGroupResource extends software.amazon.awscdk.Resource {
    protected SecurityGroupResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::SecurityGroup``.
     * @param parent the ``cdk.Construct`` this ``SecurityGroupResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``SecurityGroupResource``
     */
    public SecurityGroupResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps.class);
    }

    /**
     * @cloudformation_attribute GroupId
     */
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    public java.lang.String getSecurityGroupName() {
        return this.jsiiGet("securityGroupName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute VpcId
     */
    public java.lang.String getSecurityGroupVpcId() {
        return this.jsiiGet("securityGroupVpcId", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.Object getIpProtocol();
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.Object getCidrIp();
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.Object getCidrIpv6();
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.Object getDescription();
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        java.lang.Object getDestinationPrefixListId();
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        void setDestinationPrefixListId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        void setDestinationPrefixListId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        java.lang.Object getDestinationSecurityGroupId();
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        void setDestinationSecurityGroupId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        void setDestinationSecurityGroupId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.EgressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.EgressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EgressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EgressProperty}
         */
        final class Builder {
            private java.lang.Object _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.Object _cidrIp;
            @javax.annotation.Nullable
            private java.lang.Object _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.Object _description;
            @javax.annotation.Nullable
            private java.lang.Object _destinationPrefixListId;
            @javax.annotation.Nullable
            private java.lang.Object _destinationSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.Object _fromPort;
            @javax.annotation.Nullable
            private java.lang.Object _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @return {@code this}
             */
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of IpProtocol
             * @param value ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @return {@code this}
             */
            public Builder withIpProtocol(final software.amazon.awscdk.Token value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value ``SecurityGroupResource.EgressProperty.CidrIp``
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value ``SecurityGroupResource.EgressProperty.CidrIp``
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``SecurityGroupResource.EgressProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``SecurityGroupResource.EgressProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DestinationPrefixListId
             * @param value ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @return {@code this}
             */
            public Builder withDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationPrefixListId = value;
                return this;
            }
            /**
             * Sets the value of DestinationPrefixListId
             * @param value ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @return {@code this}
             */
            public Builder withDestinationPrefixListId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._destinationPrefixListId = value;
                return this;
            }
            /**
             * Sets the value of DestinationSecurityGroupId
             * @param value ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @return {@code this}
             */
            public Builder withDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of DestinationSecurityGroupId
             * @param value ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @return {@code this}
             */
            public Builder withDestinationSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._destinationSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value ``SecurityGroupResource.EgressProperty.FromPort``
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value ``SecurityGroupResource.EgressProperty.FromPort``
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value ``SecurityGroupResource.EgressProperty.ToPort``
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value ``SecurityGroupResource.EgressProperty.ToPort``
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EgressProperty build() {
                return new EgressProperty() {
                    private java.lang.Object $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private java.lang.Object $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private java.lang.Object $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $destinationPrefixListId = _destinationPrefixListId;
                    @javax.annotation.Nullable
                    private java.lang.Object $destinationSecurityGroupId = _destinationSecurityGroupId;
                    @javax.annotation.Nullable
                    private java.lang.Object $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private java.lang.Object $toPort = _toPort;

                    @Override
                    public java.lang.Object getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public void setIpProtocol(final java.lang.String value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public void setIpProtocol(final software.amazon.awscdk.Token value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public java.lang.Object getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public java.lang.Object getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public java.lang.Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getDestinationPrefixListId() {
                        return this.$destinationPrefixListId;
                    }

                    @Override
                    public void setDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationPrefixListId = value;
                    }

                    @Override
                    public void setDestinationPrefixListId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$destinationPrefixListId = value;
                    }

                    @Override
                    public java.lang.Object getDestinationSecurityGroupId() {
                        return this.$destinationSecurityGroupId;
                    }

                    @Override
                    public void setDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationSecurityGroupId = value;
                    }

                    @Override
                    public void setDestinationSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$destinationSecurityGroupId = value;
                    }

                    @Override
                    public java.lang.Object getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public java.lang.Object getToPort() {
                        return this.$toPort;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$toPort = value;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$toPort = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.EgressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public java.lang.Object getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * ``SecurityGroupResource.EgressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDestinationPrefixListId() {
                return this.jsiiGet("destinationPrefixListId", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            public void setDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationPrefixListId", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationPrefixListId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            public void setDestinationPrefixListId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationPrefixListId", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDestinationSecurityGroupId() {
                return this.jsiiGet("destinationSecurityGroupId", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            public void setDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationSecurityGroupId", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.DestinationSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            public void setDestinationSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("destinationSecurityGroupId", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }

            /**
             * ``SecurityGroupResource.EgressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.Object getIpProtocol();
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.IpProtocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.Object getCidrIp();
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIp``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.Object getCidrIpv6();
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.CidrIpv6``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.Object getDescription();
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.IngressProperty.FromPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        java.lang.Object getSourceSecurityGroupId();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        void setSourceSecurityGroupId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        void setSourceSecurityGroupId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        java.lang.Object getSourceSecurityGroupName();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        void setSourceSecurityGroupName(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        void setSourceSecurityGroupName(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        java.lang.Object getSourceSecurityGroupOwnerId();
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        void setSourceSecurityGroupOwnerId(final java.lang.String value);
        /**
         * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        void setSourceSecurityGroupOwnerId(final software.amazon.awscdk.Token value);
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * ``SecurityGroupResource.IngressProperty.ToPort``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IngressProperty}
         */
        final class Builder {
            private java.lang.Object _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.Object _cidrIp;
            @javax.annotation.Nullable
            private java.lang.Object _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.Object _description;
            @javax.annotation.Nullable
            private java.lang.Object _fromPort;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSecurityGroupName;
            @javax.annotation.Nullable
            private java.lang.Object _sourceSecurityGroupOwnerId;
            @javax.annotation.Nullable
            private java.lang.Object _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @return {@code this}
             */
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of IpProtocol
             * @param value ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @return {@code this}
             */
            public Builder withIpProtocol(final software.amazon.awscdk.Token value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value ``SecurityGroupResource.IngressProperty.CidrIp``
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value ``SecurityGroupResource.IngressProperty.CidrIp``
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``SecurityGroupResource.IngressProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``SecurityGroupResource.IngressProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value ``SecurityGroupResource.IngressProperty.FromPort``
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value ``SecurityGroupResource.IngressProperty.FromPort``
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupId
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupId
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupName
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupName
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupOwnerId
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupOwnerId
             * @param value ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupOwnerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value ``SecurityGroupResource.IngressProperty.ToPort``
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value ``SecurityGroupResource.IngressProperty.ToPort``
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IngressProperty build() {
                return new IngressProperty() {
                    private java.lang.Object $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private java.lang.Object $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private java.lang.Object $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceSecurityGroupId = _sourceSecurityGroupId;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceSecurityGroupName = _sourceSecurityGroupName;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceSecurityGroupOwnerId = _sourceSecurityGroupOwnerId;
                    @javax.annotation.Nullable
                    private java.lang.Object $toPort = _toPort;

                    @Override
                    public java.lang.Object getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public void setIpProtocol(final java.lang.String value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public void setIpProtocol(final software.amazon.awscdk.Token value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public java.lang.Object getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public java.lang.Object getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public java.lang.Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public java.lang.Object getSourceSecurityGroupId() {
                        return this.$sourceSecurityGroupId;
                    }

                    @Override
                    public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupId = value;
                    }

                    @Override
                    public void setSourceSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceSecurityGroupId = value;
                    }

                    @Override
                    public java.lang.Object getSourceSecurityGroupName() {
                        return this.$sourceSecurityGroupName;
                    }

                    @Override
                    public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupName = value;
                    }

                    @Override
                    public void setSourceSecurityGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceSecurityGroupName = value;
                    }

                    @Override
                    public java.lang.Object getSourceSecurityGroupOwnerId() {
                        return this.$sourceSecurityGroupOwnerId;
                    }

                    @Override
                    public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupOwnerId = value;
                    }

                    @Override
                    public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceSecurityGroupOwnerId = value;
                    }

                    @Override
                    public java.lang.Object getToPort() {
                        return this.$toPort;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$toPort = value;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$toPort = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.IngressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public java.lang.Object getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * ``SecurityGroupResource.IngressProperty.IpProtocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIp``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.CidrIpv6``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.FromPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupId() {
                return this.jsiiGet("sourceSecurityGroupId", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupId", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            public void setSourceSecurityGroupId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupId", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupName() {
                return this.jsiiGet("sourceSecurityGroupName", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupName", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            public void setSourceSecurityGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupName", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceSecurityGroupOwnerId() {
                return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupOwnerId", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.SourceSecurityGroupOwnerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceSecurityGroupOwnerId", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }

            /**
             * ``SecurityGroupResource.IngressProperty.ToPort``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
}
