/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2.cloudformation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.cloudformation.SpotFleetResource")
public class SpotFleetResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(SpotFleetResource.class, (String)"resourceTypeName", String.class);

    protected SpotFleetResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public SpotFleetResource(Construct parent, String name, SpotFleetResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public SpotFleetResourceProps getPropertyOverrides() {
        return (SpotFleetResourceProps)this.jsiiGet("propertyOverrides", SpotFleetResourceProps.class);
    }

    public String getSpotFleetName() {
        return (String)this.jsiiGet("spotFleetName", String.class);
    }

    public static interface TargetGroupsConfigProperty
    extends JsiiSerializable {
        public Object getTargetGroups();

        public void setTargetGroups(Token var1);

        public void setTargetGroups(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _targetGroups;

            public Builder withTargetGroups(Token value) {
                this._targetGroups = Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }

            public Builder withTargetGroups(List<Object> value) {
                this._targetGroups = Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }

            public TargetGroupsConfigProperty build() {
                return new TargetGroupsConfigProperty(){
                    private Object $targetGroups;
                    {
                        this.$targetGroups = Objects.requireNonNull(_targetGroups, "targetGroups is required");
                    }

                    @Override
                    public Object getTargetGroups() {
                        return this.$targetGroups;
                    }

                    @Override
                    public void setTargetGroups(Token value) {
                        this.$targetGroups = Objects.requireNonNull(value, "targetGroups is required");
                    }

                    @Override
                    public void setTargetGroups(List<Object> value) {
                        this.$targetGroups = Objects.requireNonNull(value, "targetGroups is required");
                    }
                };
            }
        }
    }

    public static interface TargetGroupProperty
    extends JsiiSerializable {
        public Object getArn();

        public void setArn(String var1);

        public void setArn(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _arn;

            public Builder withArn(String value) {
                this._arn = Objects.requireNonNull(value, "arn is required");
                return this;
            }

            public Builder withArn(Token value) {
                this._arn = Objects.requireNonNull(value, "arn is required");
                return this;
            }

            public TargetGroupProperty build() {
                return new TargetGroupProperty(){
                    private Object $arn;
                    {
                        this.$arn = Objects.requireNonNull(_arn, "arn is required");
                    }

                    @Override
                    public Object getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(String value) {
                        this.$arn = Objects.requireNonNull(value, "arn is required");
                    }

                    @Override
                    public void setArn(Token value) {
                        this.$arn = Objects.requireNonNull(value, "arn is required");
                    }
                };
            }
        }
    }

    public static interface SpotPlacementProperty
    extends JsiiSerializable {
        public Object getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public void setAvailabilityZone(Token var1);

        public Object getGroupName();

        public void setGroupName(String var1);

        public void setGroupName(Token var1);

        public Object getTenancy();

        public void setTenancy(String var1);

        public void setTenancy(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _availabilityZone;
            @Nullable
            private Object _groupName;
            @Nullable
            private Object _tenancy;

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable Token value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withGroupName(@Nullable Token value) {
                this._groupName = value;
                return this;
            }

            public Builder withTenancy(@Nullable String value) {
                this._tenancy = value;
                return this;
            }

            public Builder withTenancy(@Nullable Token value) {
                this._tenancy = value;
                return this;
            }

            public SpotPlacementProperty build() {
                return new SpotPlacementProperty(){
                    @Nullable
                    private Object $availabilityZone;
                    @Nullable
                    private Object $groupName;
                    @Nullable
                    private Object $tenancy;
                    {
                        this.$availabilityZone = _availabilityZone;
                        this.$groupName = _groupName;
                        this.$tenancy = _tenancy;
                    }

                    @Override
                    public Object getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable Token value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@Nullable String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@Nullable Token value) {
                        this.$groupName = value;
                    }

                    @Override
                    public Object getTenancy() {
                        return this.$tenancy;
                    }

                    @Override
                    public void setTenancy(@Nullable String value) {
                        this.$tenancy = value;
                    }

                    @Override
                    public void setTenancy(@Nullable Token value) {
                        this.$tenancy = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetTagSpecificationProperty
    extends JsiiSerializable {
        public Object getResourceType();

        public void setResourceType(String var1);

        public void setResourceType(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _resourceType;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withResourceType(@Nullable Token value) {
                this._resourceType = value;
                return this;
            }

            public SpotFleetTagSpecificationProperty build() {
                return new SpotFleetTagSpecificationProperty(){
                    @Nullable
                    private Object $resourceType;
                    {
                        this.$resourceType = _resourceType;
                    }

                    @Override
                    public Object getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@Nullable String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public void setResourceType(@Nullable Token value) {
                        this.$resourceType = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetRequestConfigDataProperty
    extends JsiiSerializable {
        public Object getIamFleetRole();

        public void setIamFleetRole(String var1);

        public void setIamFleetRole(Token var1);

        public Object getTargetCapacity();

        public void setTargetCapacity(Number var1);

        public void setTargetCapacity(Token var1);

        public Object getAllocationStrategy();

        public void setAllocationStrategy(String var1);

        public void setAllocationStrategy(Token var1);

        public Object getExcessCapacityTerminationPolicy();

        public void setExcessCapacityTerminationPolicy(String var1);

        public void setExcessCapacityTerminationPolicy(Token var1);

        public Object getInstanceInterruptionBehavior();

        public void setInstanceInterruptionBehavior(String var1);

        public void setInstanceInterruptionBehavior(Token var1);

        public Object getLaunchSpecifications();

        public void setLaunchSpecifications(Token var1);

        public void setLaunchSpecifications(List<Object> var1);

        public Object getLaunchTemplateConfigs();

        public void setLaunchTemplateConfigs(Token var1);

        public void setLaunchTemplateConfigs(List<Object> var1);

        public Object getLoadBalancersConfig();

        public void setLoadBalancersConfig(Token var1);

        public void setLoadBalancersConfig(LoadBalancersConfigProperty var1);

        public Object getReplaceUnhealthyInstances();

        public void setReplaceUnhealthyInstances(Boolean var1);

        public void setReplaceUnhealthyInstances(Token var1);

        public Object getSpotPrice();

        public void setSpotPrice(String var1);

        public void setSpotPrice(Token var1);

        public Object getTerminateInstancesWithExpiration();

        public void setTerminateInstancesWithExpiration(Boolean var1);

        public void setTerminateInstancesWithExpiration(Token var1);

        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getValidFrom();

        public void setValidFrom(String var1);

        public void setValidFrom(Token var1);

        public Object getValidUntil();

        public void setValidUntil(String var1);

        public void setValidUntil(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _iamFleetRole;
            private Object _targetCapacity;
            @Nullable
            private Object _allocationStrategy;
            @Nullable
            private Object _excessCapacityTerminationPolicy;
            @Nullable
            private Object _instanceInterruptionBehavior;
            @Nullable
            private Object _launchSpecifications;
            @Nullable
            private Object _launchTemplateConfigs;
            @Nullable
            private Object _loadBalancersConfig;
            @Nullable
            private Object _replaceUnhealthyInstances;
            @Nullable
            private Object _spotPrice;
            @Nullable
            private Object _terminateInstancesWithExpiration;
            @Nullable
            private Object _type;
            @Nullable
            private Object _validFrom;
            @Nullable
            private Object _validUntil;

            public Builder withIamFleetRole(String value) {
                this._iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }

            public Builder withIamFleetRole(Token value) {
                this._iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }

            public Builder withTargetCapacity(Number value) {
                this._targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }

            public Builder withTargetCapacity(Token value) {
                this._targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }

            public Builder withAllocationStrategy(@Nullable String value) {
                this._allocationStrategy = value;
                return this;
            }

            public Builder withAllocationStrategy(@Nullable Token value) {
                this._allocationStrategy = value;
                return this;
            }

            public Builder withExcessCapacityTerminationPolicy(@Nullable String value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }

            public Builder withExcessCapacityTerminationPolicy(@Nullable Token value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }

            public Builder withInstanceInterruptionBehavior(@Nullable String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withInstanceInterruptionBehavior(@Nullable Token value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withLaunchSpecifications(@Nullable Token value) {
                this._launchSpecifications = value;
                return this;
            }

            public Builder withLaunchSpecifications(@Nullable List<Object> value) {
                this._launchSpecifications = value;
                return this;
            }

            public Builder withLaunchTemplateConfigs(@Nullable Token value) {
                this._launchTemplateConfigs = value;
                return this;
            }

            public Builder withLaunchTemplateConfigs(@Nullable List<Object> value) {
                this._launchTemplateConfigs = value;
                return this;
            }

            public Builder withLoadBalancersConfig(@Nullable Token value) {
                this._loadBalancersConfig = value;
                return this;
            }

            public Builder withLoadBalancersConfig(@Nullable LoadBalancersConfigProperty value) {
                this._loadBalancersConfig = value;
                return this;
            }

            public Builder withReplaceUnhealthyInstances(@Nullable Boolean value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }

            public Builder withReplaceUnhealthyInstances(@Nullable Token value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable String value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable Token value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withTerminateInstancesWithExpiration(@Nullable Boolean value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }

            public Builder withTerminateInstancesWithExpiration(@Nullable Token value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public Builder withType(@Nullable Token value) {
                this._type = value;
                return this;
            }

            public Builder withValidFrom(@Nullable String value) {
                this._validFrom = value;
                return this;
            }

            public Builder withValidFrom(@Nullable Token value) {
                this._validFrom = value;
                return this;
            }

            public Builder withValidUntil(@Nullable String value) {
                this._validUntil = value;
                return this;
            }

            public Builder withValidUntil(@Nullable Token value) {
                this._validUntil = value;
                return this;
            }

            public SpotFleetRequestConfigDataProperty build() {
                return new SpotFleetRequestConfigDataProperty(){
                    private Object $iamFleetRole;
                    private Object $targetCapacity;
                    @Nullable
                    private Object $allocationStrategy;
                    @Nullable
                    private Object $excessCapacityTerminationPolicy;
                    @Nullable
                    private Object $instanceInterruptionBehavior;
                    @Nullable
                    private Object $launchSpecifications;
                    @Nullable
                    private Object $launchTemplateConfigs;
                    @Nullable
                    private Object $loadBalancersConfig;
                    @Nullable
                    private Object $replaceUnhealthyInstances;
                    @Nullable
                    private Object $spotPrice;
                    @Nullable
                    private Object $terminateInstancesWithExpiration;
                    @Nullable
                    private Object $type;
                    @Nullable
                    private Object $validFrom;
                    @Nullable
                    private Object $validUntil;
                    {
                        this.$iamFleetRole = Objects.requireNonNull(_iamFleetRole, "iamFleetRole is required");
                        this.$targetCapacity = Objects.requireNonNull(_targetCapacity, "targetCapacity is required");
                        this.$allocationStrategy = _allocationStrategy;
                        this.$excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                        this.$instanceInterruptionBehavior = _instanceInterruptionBehavior;
                        this.$launchSpecifications = _launchSpecifications;
                        this.$launchTemplateConfigs = _launchTemplateConfigs;
                        this.$loadBalancersConfig = _loadBalancersConfig;
                        this.$replaceUnhealthyInstances = _replaceUnhealthyInstances;
                        this.$spotPrice = _spotPrice;
                        this.$terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                        this.$type = _type;
                        this.$validFrom = _validFrom;
                        this.$validUntil = _validUntil;
                    }

                    @Override
                    public Object getIamFleetRole() {
                        return this.$iamFleetRole;
                    }

                    @Override
                    public void setIamFleetRole(String value) {
                        this.$iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                    }

                    @Override
                    public void setIamFleetRole(Token value) {
                        this.$iamFleetRole = Objects.requireNonNull(value, "iamFleetRole is required");
                    }

                    @Override
                    public Object getTargetCapacity() {
                        return this.$targetCapacity;
                    }

                    @Override
                    public void setTargetCapacity(Number value) {
                        this.$targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public void setTargetCapacity(Token value) {
                        this.$targetCapacity = Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public Object getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable String value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable Token value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public Object getExcessCapacityTerminationPolicy() {
                        return this.$excessCapacityTerminationPolicy;
                    }

                    @Override
                    public void setExcessCapacityTerminationPolicy(@Nullable String value) {
                        this.$excessCapacityTerminationPolicy = value;
                    }

                    @Override
                    public void setExcessCapacityTerminationPolicy(@Nullable Token value) {
                        this.$excessCapacityTerminationPolicy = value;
                    }

                    @Override
                    public Object getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable Token value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public Object getLaunchSpecifications() {
                        return this.$launchSpecifications;
                    }

                    @Override
                    public void setLaunchSpecifications(@Nullable Token value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public void setLaunchSpecifications(@Nullable List<Object> value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public Object getLaunchTemplateConfigs() {
                        return this.$launchTemplateConfigs;
                    }

                    @Override
                    public void setLaunchTemplateConfigs(@Nullable Token value) {
                        this.$launchTemplateConfigs = value;
                    }

                    @Override
                    public void setLaunchTemplateConfigs(@Nullable List<Object> value) {
                        this.$launchTemplateConfigs = value;
                    }

                    @Override
                    public Object getLoadBalancersConfig() {
                        return this.$loadBalancersConfig;
                    }

                    @Override
                    public void setLoadBalancersConfig(@Nullable Token value) {
                        this.$loadBalancersConfig = value;
                    }

                    @Override
                    public void setLoadBalancersConfig(@Nullable LoadBalancersConfigProperty value) {
                        this.$loadBalancersConfig = value;
                    }

                    @Override
                    public Object getReplaceUnhealthyInstances() {
                        return this.$replaceUnhealthyInstances;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@Nullable Boolean value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@Nullable Token value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public Object getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@Nullable String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public void setSpotPrice(@Nullable Token value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public Object getTerminateInstancesWithExpiration() {
                        return this.$terminateInstancesWithExpiration;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@Nullable Boolean value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@Nullable Token value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@Nullable String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@Nullable Token value) {
                        this.$type = value;
                    }

                    @Override
                    public Object getValidFrom() {
                        return this.$validFrom;
                    }

                    @Override
                    public void setValidFrom(@Nullable String value) {
                        this.$validFrom = value;
                    }

                    @Override
                    public void setValidFrom(@Nullable Token value) {
                        this.$validFrom = value;
                    }

                    @Override
                    public Object getValidUntil() {
                        return this.$validUntil;
                    }

                    @Override
                    public void setValidUntil(@Nullable String value) {
                        this.$validUntil = value;
                    }

                    @Override
                    public void setValidUntil(@Nullable Token value) {
                        this.$validUntil = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetMonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _enabled;

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable Token value) {
                this._enabled = value;
                return this;
            }

            public SpotFleetMonitoringProperty build() {
                return new SpotFleetMonitoringProperty(){
                    @Nullable
                    private Object $enabled;
                    {
                        this.$enabled = _enabled;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@Nullable Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@Nullable Token value) {
                        this.$enabled = value;
                    }
                };
            }
        }
    }

    public static interface SpotFleetLaunchSpecificationProperty
    extends JsiiSerializable {
        public Object getImageId();

        public void setImageId(String var1);

        public void setImageId(Token var1);

        public Object getInstanceType();

        public void setInstanceType(String var1);

        public void setInstanceType(Token var1);

        public Object getBlockDeviceMappings();

        public void setBlockDeviceMappings(Token var1);

        public void setBlockDeviceMappings(List<Object> var1);

        public Object getEbsOptimized();

        public void setEbsOptimized(Boolean var1);

        public void setEbsOptimized(Token var1);

        public Object getIamInstanceProfile();

        public void setIamInstanceProfile(Token var1);

        public void setIamInstanceProfile(IamInstanceProfileSpecificationProperty var1);

        public Object getKernelId();

        public void setKernelId(String var1);

        public void setKernelId(Token var1);

        public Object getKeyName();

        public void setKeyName(String var1);

        public void setKeyName(Token var1);

        public Object getMonitoring();

        public void setMonitoring(Token var1);

        public void setMonitoring(SpotFleetMonitoringProperty var1);

        public Object getNetworkInterfaces();

        public void setNetworkInterfaces(Token var1);

        public void setNetworkInterfaces(List<Object> var1);

        public Object getPlacement();

        public void setPlacement(Token var1);

        public void setPlacement(SpotPlacementProperty var1);

        public Object getRamdiskId();

        public void setRamdiskId(String var1);

        public void setRamdiskId(Token var1);

        public Object getSecurityGroups();

        public void setSecurityGroups(Token var1);

        public void setSecurityGroups(List<Object> var1);

        public Object getSpotPrice();

        public void setSpotPrice(String var1);

        public void setSpotPrice(Token var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(Token var1);

        public Object getTagSpecifications();

        public void setTagSpecifications(Token var1);

        public void setTagSpecifications(List<Object> var1);

        public Object getUserData();

        public void setUserData(String var1);

        public void setUserData(Token var1);

        public Object getWeightedCapacity();

        public void setWeightedCapacity(Number var1);

        public void setWeightedCapacity(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _imageId;
            private Object _instanceType;
            @Nullable
            private Object _blockDeviceMappings;
            @Nullable
            private Object _ebsOptimized;
            @Nullable
            private Object _iamInstanceProfile;
            @Nullable
            private Object _kernelId;
            @Nullable
            private Object _keyName;
            @Nullable
            private Object _monitoring;
            @Nullable
            private Object _networkInterfaces;
            @Nullable
            private Object _placement;
            @Nullable
            private Object _ramdiskId;
            @Nullable
            private Object _securityGroups;
            @Nullable
            private Object _spotPrice;
            @Nullable
            private Object _subnetId;
            @Nullable
            private Object _tagSpecifications;
            @Nullable
            private Object _userData;
            @Nullable
            private Object _weightedCapacity;

            public Builder withImageId(String value) {
                this._imageId = Objects.requireNonNull(value, "imageId is required");
                return this;
            }

            public Builder withImageId(Token value) {
                this._imageId = Objects.requireNonNull(value, "imageId is required");
                return this;
            }

            public Builder withInstanceType(String value) {
                this._instanceType = Objects.requireNonNull(value, "instanceType is required");
                return this;
            }

            public Builder withInstanceType(Token value) {
                this._instanceType = Objects.requireNonNull(value, "instanceType is required");
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable Token value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable List<Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Boolean value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Token value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable Token value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withKernelId(@Nullable String value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKernelId(@Nullable Token value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKeyName(@Nullable String value) {
                this._keyName = value;
                return this;
            }

            public Builder withKeyName(@Nullable Token value) {
                this._keyName = value;
                return this;
            }

            public Builder withMonitoring(@Nullable Token value) {
                this._monitoring = value;
                return this;
            }

            public Builder withMonitoring(@Nullable SpotFleetMonitoringProperty value) {
                this._monitoring = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable Token value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable List<Object> value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withPlacement(@Nullable Token value) {
                this._placement = value;
                return this;
            }

            public Builder withPlacement(@Nullable SpotPlacementProperty value) {
                this._placement = value;
                return this;
            }

            public Builder withRamdiskId(@Nullable String value) {
                this._ramdiskId = value;
                return this;
            }

            public Builder withRamdiskId(@Nullable Token value) {
                this._ramdiskId = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable Token value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable List<Object> value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable String value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable Token value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable Token value) {
                this._subnetId = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable Token value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable List<Object> value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withUserData(@Nullable String value) {
                this._userData = value;
                return this;
            }

            public Builder withUserData(@Nullable Token value) {
                this._userData = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Number value) {
                this._weightedCapacity = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Token value) {
                this._weightedCapacity = value;
                return this;
            }

            public SpotFleetLaunchSpecificationProperty build() {
                return new SpotFleetLaunchSpecificationProperty(){
                    private Object $imageId;
                    private Object $instanceType;
                    @Nullable
                    private Object $blockDeviceMappings;
                    @Nullable
                    private Object $ebsOptimized;
                    @Nullable
                    private Object $iamInstanceProfile;
                    @Nullable
                    private Object $kernelId;
                    @Nullable
                    private Object $keyName;
                    @Nullable
                    private Object $monitoring;
                    @Nullable
                    private Object $networkInterfaces;
                    @Nullable
                    private Object $placement;
                    @Nullable
                    private Object $ramdiskId;
                    @Nullable
                    private Object $securityGroups;
                    @Nullable
                    private Object $spotPrice;
                    @Nullable
                    private Object $subnetId;
                    @Nullable
                    private Object $tagSpecifications;
                    @Nullable
                    private Object $userData;
                    @Nullable
                    private Object $weightedCapacity;
                    {
                        this.$imageId = Objects.requireNonNull(_imageId, "imageId is required");
                        this.$instanceType = Objects.requireNonNull(_instanceType, "instanceType is required");
                        this.$blockDeviceMappings = _blockDeviceMappings;
                        this.$ebsOptimized = _ebsOptimized;
                        this.$iamInstanceProfile = _iamInstanceProfile;
                        this.$kernelId = _kernelId;
                        this.$keyName = _keyName;
                        this.$monitoring = _monitoring;
                        this.$networkInterfaces = _networkInterfaces;
                        this.$placement = _placement;
                        this.$ramdiskId = _ramdiskId;
                        this.$securityGroups = _securityGroups;
                        this.$spotPrice = _spotPrice;
                        this.$subnetId = _subnetId;
                        this.$tagSpecifications = _tagSpecifications;
                        this.$userData = _userData;
                        this.$weightedCapacity = _weightedCapacity;
                    }

                    @Override
                    public Object getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(String value) {
                        this.$imageId = Objects.requireNonNull(value, "imageId is required");
                    }

                    @Override
                    public void setImageId(Token value) {
                        this.$imageId = Objects.requireNonNull(value, "imageId is required");
                    }

                    @Override
                    public Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(String value) {
                        this.$instanceType = Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public void setInstanceType(Token value) {
                        this.$instanceType = Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable Token value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable List<Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Token value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable Token value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable IamInstanceProfileSpecificationProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public Object getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@Nullable String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public void setKernelId(@Nullable Token value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public Object getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@Nullable String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public void setKeyName(@Nullable Token value) {
                        this.$keyName = value;
                    }

                    @Override
                    public Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@Nullable Token value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@Nullable SpotFleetMonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable Token value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable List<Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@Nullable Token value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@Nullable SpotPlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public Object getRamdiskId() {
                        return this.$ramdiskId;
                    }

                    @Override
                    public void setRamdiskId(@Nullable String value) {
                        this.$ramdiskId = value;
                    }

                    @Override
                    public void setRamdiskId(@Nullable Token value) {
                        this.$ramdiskId = value;
                    }

                    @Override
                    public Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable Token value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable List<Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public Object getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@Nullable String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public void setSpotPrice(@Nullable Token value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable Token value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable Token value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable List<Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public Object getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@Nullable String value) {
                        this.$userData = value;
                    }

                    @Override
                    public void setUserData(@Nullable Token value) {
                        this.$userData = value;
                    }

                    @Override
                    public Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Token value) {
                        this.$weightedCapacity = value;
                    }
                };
            }
        }
    }

    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        public Object getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public void setPrivateIpAddress(Token var1);

        public Object getPrimary();

        public void setPrimary(Boolean var1);

        public void setPrimary(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _privateIpAddress;
            @Nullable
            private Object _primary;

            public Builder withPrivateIpAddress(String value) {
                this._privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            public Builder withPrivateIpAddress(Token value) {
                this._privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            public Builder withPrimary(@Nullable Boolean value) {
                this._primary = value;
                return this;
            }

            public Builder withPrimary(@Nullable Token value) {
                this._primary = value;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty(){
                    private Object $privateIpAddress;
                    @Nullable
                    private Object $primary;
                    {
                        this.$privateIpAddress = Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                        this.$primary = _primary;
                    }

                    @Override
                    public Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(String value) {
                        this.$privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public void setPrivateIpAddress(Token value) {
                        this.$privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@Nullable Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@Nullable Token value) {
                        this.$primary = value;
                    }
                };
            }
        }
    }

    public static interface LoadBalancersConfigProperty
    extends JsiiSerializable {
        public Object getClassicLoadBalancersConfig();

        public void setClassicLoadBalancersConfig(Token var1);

        public void setClassicLoadBalancersConfig(ClassicLoadBalancersConfigProperty var1);

        public Object getTargetGroupsConfig();

        public void setTargetGroupsConfig(Token var1);

        public void setTargetGroupsConfig(TargetGroupsConfigProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _classicLoadBalancersConfig;
            @Nullable
            private Object _targetGroupsConfig;

            public Builder withClassicLoadBalancersConfig(@Nullable Token value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }

            public Builder withClassicLoadBalancersConfig(@Nullable ClassicLoadBalancersConfigProperty value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }

            public Builder withTargetGroupsConfig(@Nullable Token value) {
                this._targetGroupsConfig = value;
                return this;
            }

            public Builder withTargetGroupsConfig(@Nullable TargetGroupsConfigProperty value) {
                this._targetGroupsConfig = value;
                return this;
            }

            public LoadBalancersConfigProperty build() {
                return new LoadBalancersConfigProperty(){
                    @Nullable
                    private Object $classicLoadBalancersConfig;
                    @Nullable
                    private Object $targetGroupsConfig;
                    {
                        this.$classicLoadBalancersConfig = _classicLoadBalancersConfig;
                        this.$targetGroupsConfig = _targetGroupsConfig;
                    }

                    @Override
                    public Object getClassicLoadBalancersConfig() {
                        return this.$classicLoadBalancersConfig;
                    }

                    @Override
                    public void setClassicLoadBalancersConfig(@Nullable Token value) {
                        this.$classicLoadBalancersConfig = value;
                    }

                    @Override
                    public void setClassicLoadBalancersConfig(@Nullable ClassicLoadBalancersConfigProperty value) {
                        this.$classicLoadBalancersConfig = value;
                    }

                    @Override
                    public Object getTargetGroupsConfig() {
                        return this.$targetGroupsConfig;
                    }

                    @Override
                    public void setTargetGroupsConfig(@Nullable Token value) {
                        this.$targetGroupsConfig = value;
                    }

                    @Override
                    public void setTargetGroupsConfig(@Nullable TargetGroupsConfigProperty value) {
                        this.$targetGroupsConfig = value;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateOverridesProperty
    extends JsiiSerializable {
        public Object getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public void setAvailabilityZone(Token var1);

        public Object getInstanceType();

        public void setInstanceType(String var1);

        public void setInstanceType(Token var1);

        public Object getSpotPrice();

        public void setSpotPrice(String var1);

        public void setSpotPrice(Token var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(Token var1);

        public Object getWeightedCapacity();

        public void setWeightedCapacity(Number var1);

        public void setWeightedCapacity(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _availabilityZone;
            @Nullable
            private Object _instanceType;
            @Nullable
            private Object _spotPrice;
            @Nullable
            private Object _subnetId;
            @Nullable
            private Object _weightedCapacity;

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable Token value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withInstanceType(@Nullable String value) {
                this._instanceType = value;
                return this;
            }

            public Builder withInstanceType(@Nullable Token value) {
                this._instanceType = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable String value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSpotPrice(@Nullable Token value) {
                this._spotPrice = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable Token value) {
                this._subnetId = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Number value) {
                this._weightedCapacity = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Token value) {
                this._weightedCapacity = value;
                return this;
            }

            public LaunchTemplateOverridesProperty build() {
                return new LaunchTemplateOverridesProperty(){
                    @Nullable
                    private Object $availabilityZone;
                    @Nullable
                    private Object $instanceType;
                    @Nullable
                    private Object $spotPrice;
                    @Nullable
                    private Object $subnetId;
                    @Nullable
                    private Object $weightedCapacity;
                    {
                        this.$availabilityZone = _availabilityZone;
                        this.$instanceType = _instanceType;
                        this.$spotPrice = _spotPrice;
                        this.$subnetId = _subnetId;
                        this.$weightedCapacity = _weightedCapacity;
                    }

                    @Override
                    public Object getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable Token value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public Object getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@Nullable String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public void setInstanceType(@Nullable Token value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public Object getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@Nullable String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public void setSpotPrice(@Nullable Token value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable Token value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Token value) {
                        this.$weightedCapacity = value;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateConfigProperty
    extends JsiiSerializable {
        public Object getLaunchTemplateSpecification();

        public void setLaunchTemplateSpecification(Token var1);

        public void setLaunchTemplateSpecification(FleetLaunchTemplateSpecificationProperty var1);

        public Object getOverrides();

        public void setOverrides(Token var1);

        public void setOverrides(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _launchTemplateSpecification;
            @Nullable
            private Object _overrides;

            public Builder withLaunchTemplateSpecification(@Nullable Token value) {
                this._launchTemplateSpecification = value;
                return this;
            }

            public Builder withLaunchTemplateSpecification(@Nullable FleetLaunchTemplateSpecificationProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }

            public Builder withOverrides(@Nullable Token value) {
                this._overrides = value;
                return this;
            }

            public Builder withOverrides(@Nullable List<Object> value) {
                this._overrides = value;
                return this;
            }

            public LaunchTemplateConfigProperty build() {
                return new LaunchTemplateConfigProperty(){
                    @Nullable
                    private Object $launchTemplateSpecification;
                    @Nullable
                    private Object $overrides;
                    {
                        this.$launchTemplateSpecification = _launchTemplateSpecification;
                        this.$overrides = _overrides;
                    }

                    @Override
                    public Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@Nullable Token value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@Nullable FleetLaunchTemplateSpecificationProperty value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public Object getOverrides() {
                        return this.$overrides;
                    }

                    @Override
                    public void setOverrides(@Nullable Token value) {
                        this.$overrides = value;
                    }

                    @Override
                    public void setOverrides(@Nullable List<Object> value) {
                        this.$overrides = value;
                    }
                };
            }
        }
    }

    public static interface InstanceNetworkInterfaceSpecificationProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public void setAssociatePublicIpAddress(Boolean var1);

        public void setAssociatePublicIpAddress(Token var1);

        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(Token var1);

        public Object getDescription();

        public void setDescription(String var1);

        public void setDescription(Token var1);

        public Object getDeviceIndex();

        public void setDeviceIndex(Number var1);

        public void setDeviceIndex(Token var1);

        public Object getGroups();

        public void setGroups(Token var1);

        public void setGroups(List<Object> var1);

        public Object getIpv6AddressCount();

        public void setIpv6AddressCount(Number var1);

        public void setIpv6AddressCount(Token var1);

        public Object getIpv6Addresses();

        public void setIpv6Addresses(Token var1);

        public void setIpv6Addresses(List<Object> var1);

        public Object getNetworkInterfaceId();

        public void setNetworkInterfaceId(String var1);

        public void setNetworkInterfaceId(Token var1);

        public Object getPrivateIpAddresses();

        public void setPrivateIpAddresses(Token var1);

        public void setPrivateIpAddresses(List<Object> var1);

        public Object getSecondaryPrivateIpAddressCount();

        public void setSecondaryPrivateIpAddressCount(Number var1);

        public void setSecondaryPrivateIpAddressCount(Token var1);

        public Object getSubnetId();

        public void setSubnetId(String var1);

        public void setSubnetId(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _associatePublicIpAddress;
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _description;
            @Nullable
            private Object _deviceIndex;
            @Nullable
            private Object _groups;
            @Nullable
            private Object _ipv6AddressCount;
            @Nullable
            private Object _ipv6Addresses;
            @Nullable
            private Object _networkInterfaceId;
            @Nullable
            private Object _privateIpAddresses;
            @Nullable
            private Object _secondaryPrivateIpAddressCount;
            @Nullable
            private Object _subnetId;

            public Builder withAssociatePublicIpAddress(@Nullable Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withAssociatePublicIpAddress(@Nullable Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDescription(@Nullable String value) {
                this._description = value;
                return this;
            }

            public Builder withDescription(@Nullable Token value) {
                this._description = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Number value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Token value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withGroups(@Nullable Token value) {
                this._groups = value;
                return this;
            }

            public Builder withGroups(@Nullable List<Object> value) {
                this._groups = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Number value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Token value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable Token value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable List<Object> value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable String value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable Token value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable Token value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable List<Object> value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withSubnetId(@Nullable Token value) {
                this._subnetId = value;
                return this;
            }

            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new InstanceNetworkInterfaceSpecificationProperty(){
                    @Nullable
                    private Object $associatePublicIpAddress;
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $description;
                    @Nullable
                    private Object $deviceIndex;
                    @Nullable
                    private Object $groups;
                    @Nullable
                    private Object $ipv6AddressCount;
                    @Nullable
                    private Object $ipv6Addresses;
                    @Nullable
                    private Object $networkInterfaceId;
                    @Nullable
                    private Object $privateIpAddresses;
                    @Nullable
                    private Object $secondaryPrivateIpAddressCount;
                    @Nullable
                    private Object $subnetId;
                    {
                        this.$associatePublicIpAddress = _associatePublicIpAddress;
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$description = _description;
                        this.$deviceIndex = _deviceIndex;
                        this.$groups = _groups;
                        this.$ipv6AddressCount = _ipv6AddressCount;
                        this.$ipv6Addresses = _ipv6Addresses;
                        this.$networkInterfaceId = _networkInterfaceId;
                        this.$privateIpAddresses = _privateIpAddresses;
                        this.$secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                        this.$subnetId = _subnetId;
                    }

                    @Override
                    public Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Token value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@Nullable String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@Nullable Token value) {
                        this.$description = value;
                    }

                    @Override
                    public Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Token value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@Nullable Token value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@Nullable List<Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Token value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable Token value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable List<Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public Object getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable Token value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable Token value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable List<Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Token value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@Nullable Token value) {
                        this.$subnetId = value;
                    }
                };
            }
        }
    }

    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        public Object getIpv6Address();

        public void setIpv6Address(String var1);

        public void setIpv6Address(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _ipv6Address;

            public Builder withIpv6Address(String value) {
                this._ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            public Builder withIpv6Address(Token value) {
                this._ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty(){
                    private Object $ipv6Address;
                    {
                        this.$ipv6Address = Objects.requireNonNull(_ipv6Address, "ipv6Address is required");
                    }

                    @Override
                    public Object getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(String value) {
                        this.$ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                    }

                    @Override
                    public void setIpv6Address(Token value) {
                        this.$ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                    }
                };
            }
        }
    }

    public static interface IamInstanceProfileSpecificationProperty
    extends JsiiSerializable {
        public Object getArn();

        public void setArn(String var1);

        public void setArn(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _arn;

            public Builder withArn(@Nullable String value) {
                this._arn = value;
                return this;
            }

            public Builder withArn(@Nullable Token value) {
                this._arn = value;
                return this;
            }

            public IamInstanceProfileSpecificationProperty build() {
                return new IamInstanceProfileSpecificationProperty(){
                    @Nullable
                    private Object $arn;
                    {
                        this.$arn = _arn;
                    }

                    @Override
                    public Object getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@Nullable String value) {
                        this.$arn = value;
                    }

                    @Override
                    public void setArn(@Nullable Token value) {
                        this.$arn = value;
                    }
                };
            }
        }
    }

    public static interface GroupIdentifierProperty
    extends JsiiSerializable {
        public Object getGroupId();

        public void setGroupId(String var1);

        public void setGroupId(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _groupId;

            public Builder withGroupId(String value) {
                this._groupId = Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            public Builder withGroupId(Token value) {
                this._groupId = Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            public GroupIdentifierProperty build() {
                return new GroupIdentifierProperty(){
                    private Object $groupId;
                    {
                        this.$groupId = Objects.requireNonNull(_groupId, "groupId is required");
                    }

                    @Override
                    public Object getGroupId() {
                        return this.$groupId;
                    }

                    @Override
                    public void setGroupId(String value) {
                        this.$groupId = Objects.requireNonNull(value, "groupId is required");
                    }

                    @Override
                    public void setGroupId(Token value) {
                        this.$groupId = Objects.requireNonNull(value, "groupId is required");
                    }
                };
            }
        }
    }

    public static interface FleetLaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        public Object getVersion();

        public void setVersion(String var1);

        public void setVersion(Token var1);

        public Object getLaunchTemplateId();

        public void setLaunchTemplateId(String var1);

        public void setLaunchTemplateId(Token var1);

        public Object getLaunchTemplateName();

        public void setLaunchTemplateName(String var1);

        public void setLaunchTemplateName(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _version;
            @Nullable
            private Object _launchTemplateId;
            @Nullable
            private Object _launchTemplateName;

            public Builder withVersion(String value) {
                this._version = Objects.requireNonNull(value, "version is required");
                return this;
            }

            public Builder withVersion(Token value) {
                this._version = Objects.requireNonNull(value, "version is required");
                return this;
            }

            public Builder withLaunchTemplateId(@Nullable String value) {
                this._launchTemplateId = value;
                return this;
            }

            public Builder withLaunchTemplateId(@Nullable Token value) {
                this._launchTemplateId = value;
                return this;
            }

            public Builder withLaunchTemplateName(@Nullable String value) {
                this._launchTemplateName = value;
                return this;
            }

            public Builder withLaunchTemplateName(@Nullable Token value) {
                this._launchTemplateName = value;
                return this;
            }

            public FleetLaunchTemplateSpecificationProperty build() {
                return new FleetLaunchTemplateSpecificationProperty(){
                    private Object $version;
                    @Nullable
                    private Object $launchTemplateId;
                    @Nullable
                    private Object $launchTemplateName;
                    {
                        this.$version = Objects.requireNonNull(_version, "version is required");
                        this.$launchTemplateId = _launchTemplateId;
                        this.$launchTemplateName = _launchTemplateName;
                    }

                    @Override
                    public Object getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(String value) {
                        this.$version = Objects.requireNonNull(value, "version is required");
                    }

                    @Override
                    public void setVersion(Token value) {
                        this.$version = Objects.requireNonNull(value, "version is required");
                    }

                    @Override
                    public Object getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public void setLaunchTemplateId(@Nullable String value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public void setLaunchTemplateId(@Nullable Token value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public Object getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    @Override
                    public void setLaunchTemplateName(@Nullable String value) {
                        this.$launchTemplateName = value;
                    }

                    @Override
                    public void setLaunchTemplateName(@Nullable Token value) {
                        this.$launchTemplateName = value;
                    }
                };
            }
        }
    }

    public static interface EbsBlockDeviceProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(Token var1);

        public Object getEncrypted();

        public void setEncrypted(Boolean var1);

        public void setEncrypted(Token var1);

        public Object getIops();

        public void setIops(Number var1);

        public void setIops(Token var1);

        public Object getSnapshotId();

        public void setSnapshotId(String var1);

        public void setSnapshotId(Token var1);

        public Object getVolumeSize();

        public void setVolumeSize(Number var1);

        public void setVolumeSize(Token var1);

        public Object getVolumeType();

        public void setVolumeType(String var1);

        public void setVolumeType(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _encrypted;
            @Nullable
            private Object _iops;
            @Nullable
            private Object _snapshotId;
            @Nullable
            private Object _volumeSize;
            @Nullable
            private Object _volumeType;

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Boolean value) {
                this._encrypted = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Token value) {
                this._encrypted = value;
                return this;
            }

            public Builder withIops(@Nullable Number value) {
                this._iops = value;
                return this;
            }

            public Builder withIops(@Nullable Token value) {
                this._iops = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable String value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable Token value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Number value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Token value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeType(@Nullable String value) {
                this._volumeType = value;
                return this;
            }

            public Builder withVolumeType(@Nullable Token value) {
                this._volumeType = value;
                return this;
            }

            public EbsBlockDeviceProperty build() {
                return new EbsBlockDeviceProperty(){
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $encrypted;
                    @Nullable
                    private Object $iops;
                    @Nullable
                    private Object $snapshotId;
                    @Nullable
                    private Object $volumeSize;
                    @Nullable
                    private Object $volumeType;
                    {
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$encrypted = _encrypted;
                        this.$iops = _iops;
                        this.$snapshotId = _snapshotId;
                        this.$volumeSize = _volumeSize;
                        this.$volumeType = _volumeType;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@Nullable Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@Nullable Token value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@Nullable Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@Nullable Token value) {
                        this.$iops = value;
                    }

                    @Override
                    public Object getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@Nullable String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public void setSnapshotId(@Nullable Token value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Token value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public Object getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@Nullable String value) {
                        this.$volumeType = value;
                    }

                    @Override
                    public void setVolumeType(@Nullable Token value) {
                        this.$volumeType = value;
                    }
                };
            }
        }
    }

    public static interface ClassicLoadBalancersConfigProperty
    extends JsiiSerializable {
        public Object getClassicLoadBalancers();

        public void setClassicLoadBalancers(Token var1);

        public void setClassicLoadBalancers(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _classicLoadBalancers;

            public Builder withClassicLoadBalancers(Token value) {
                this._classicLoadBalancers = Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }

            public Builder withClassicLoadBalancers(List<Object> value) {
                this._classicLoadBalancers = Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }

            public ClassicLoadBalancersConfigProperty build() {
                return new ClassicLoadBalancersConfigProperty(){
                    private Object $classicLoadBalancers;
                    {
                        this.$classicLoadBalancers = Objects.requireNonNull(_classicLoadBalancers, "classicLoadBalancers is required");
                    }

                    @Override
                    public Object getClassicLoadBalancers() {
                        return this.$classicLoadBalancers;
                    }

                    @Override
                    public void setClassicLoadBalancers(Token value) {
                        this.$classicLoadBalancers = Objects.requireNonNull(value, "classicLoadBalancers is required");
                    }

                    @Override
                    public void setClassicLoadBalancers(List<Object> value) {
                        this.$classicLoadBalancers = Objects.requireNonNull(value, "classicLoadBalancers is required");
                    }
                };
            }
        }
    }

    public static interface ClassicLoadBalancerProperty
    extends JsiiSerializable {
        public Object getName();

        public void setName(String var1);

        public void setName(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _name;

            public Builder withName(String value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withName(Token value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public ClassicLoadBalancerProperty build() {
                return new ClassicLoadBalancerProperty(){
                    private Object $name;
                    {
                        this.$name = Objects.requireNonNull(_name, "name is required");
                    }

                    @Override
                    public Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(String value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public void setName(Token value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }
                };
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public Object getDeviceName();

        public void setDeviceName(String var1);

        public void setDeviceName(Token var1);

        public Object getEbs();

        public void setEbs(Token var1);

        public void setEbs(EbsBlockDeviceProperty var1);

        public Object getNoDevice();

        public void setNoDevice(String var1);

        public void setNoDevice(Token var1);

        public Object getVirtualName();

        public void setVirtualName(String var1);

        public void setVirtualName(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _deviceName;
            @Nullable
            private Object _ebs;
            @Nullable
            private Object _noDevice;
            @Nullable
            private Object _virtualName;

            public Builder withDeviceName(String value) {
                this._deviceName = Objects.requireNonNull(value, "deviceName is required");
                return this;
            }

            public Builder withDeviceName(Token value) {
                this._deviceName = Objects.requireNonNull(value, "deviceName is required");
                return this;
            }

            public Builder withEbs(@Nullable Token value) {
                this._ebs = value;
                return this;
            }

            public Builder withEbs(@Nullable EbsBlockDeviceProperty value) {
                this._ebs = value;
                return this;
            }

            public Builder withNoDevice(@Nullable String value) {
                this._noDevice = value;
                return this;
            }

            public Builder withNoDevice(@Nullable Token value) {
                this._noDevice = value;
                return this;
            }

            public Builder withVirtualName(@Nullable String value) {
                this._virtualName = value;
                return this;
            }

            public Builder withVirtualName(@Nullable Token value) {
                this._virtualName = value;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty(){
                    private Object $deviceName;
                    @Nullable
                    private Object $ebs;
                    @Nullable
                    private Object $noDevice;
                    @Nullable
                    private Object $virtualName;
                    {
                        this.$deviceName = Objects.requireNonNull(_deviceName, "deviceName is required");
                        this.$ebs = _ebs;
                        this.$noDevice = _noDevice;
                        this.$virtualName = _virtualName;
                    }

                    @Override
                    public Object getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(String value) {
                        this.$deviceName = Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public void setDeviceName(Token value) {
                        this.$deviceName = Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@Nullable Token value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@Nullable EbsBlockDeviceProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@Nullable String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public void setNoDevice(@Nullable Token value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public Object getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@Nullable String value) {
                        this.$virtualName = value;
                    }

                    @Override
                    public void setVirtualName(@Nullable Token value) {
                        this.$virtualName = value;
                    }
                };
            }
        }
    }
}

