package software.amazon.awscdk.services.ec2;

/**
 * VpcNetwork deploys an AWS VPC, with public and private subnets per Availability Zone.
 * For example:
 * 
 * import { VpcNetwork } from '@aws-cdk/aws-ec2'
 * 
 * const vpc = new VpcNetwork(this, {
 *    cidr: "10.0.0.0/16"
 * })
 * 
 * // Iterate the public subnets
 * for (let subnet of vpc.publicSubnets) {
 * 
 * }
 * 
 * // Iterate the private subnets
 * for (let subnet of vpc.privateSubnets) {
 * 
 * }
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-19T13:24:20.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcNetwork")
public class VpcNetwork extends software.amazon.awscdk.services.ec2.VpcNetworkRef implements software.amazon.awscdk.ITaggable {
    protected VpcNetwork(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_CIDR_RANGE", java.lang.String.class);
        DEFAULT_SUBNETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_SUBNETS", java.util.List.class);
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region.
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcNetworkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region.
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    /**
     * The default CIDR range used when creating VPCs.
     * This can be overridden using VpcNetworkProps when creating a VPCNetwork resource.
     * e.g. new VpcResource(this, { cidr: '192.168.0.0./16' })
     */
    public final static java.lang.String DEFAULT_CIDR_RANGE;
    /**
     * The default subnet configuration
     * 
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * AZs for this VPC
     */
    @Override
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * @return The IPv4 CidrBlock as returned by the VPC
     */
    public java.lang.String getCidr() {
        return this.jsiiGet("cidr", java.lang.String.class);
    }

    /**
     * List of isolated subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetRef> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetRef> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.VpcSubnetRef> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     * Manage tags for this construct and children
     */
    @Override
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }

    /**
     * Identifier for this VPC
     */
    @Override
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }
}
