package software.amazon.awscdk.services.ec2;

/**
 * Creates an Amazon EC2 security group within a VPC.
 * 
 * This class has an additional optimization over SecurityGroupRef that it can also create
 * inline ingress and egress rule (which saves on the total number of resources inside
 * the template).
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:40:19.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.services.ec2.SecurityGroupRef implements software.amazon.awscdk.ITaggable {
    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public SecurityGroup(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))).toArray());
    }

    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))).toArray());
    }

    /**
     * An attribute that represents the security group name.
     */
    public java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    /**
     * The ID of the security group
     */
    @Override
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    /**
     * Manage tags for this construct and children
     */
    @Override
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }

    /**
     * An attribute that represents the physical VPC ID this security group is part of.
     */
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }
}
