package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:19:22.414Z")
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Default port range for initiating connections to and from this object
     * @default No default port range
     */
    software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange();
    /**
     * Default port range for initiating connections to and from this object
     * @default No default port range
     */
    void setDefaultPortRange(final software.amazon.awscdk.services.ec2.IPortRange value);
    /**
     * Class that represents the rule by which others can connect to this connectable
     * 
     * This object is required, but will be derived from securityGroup if that is passed.
     * @default Derived from securityGroup if set.
     */
    software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule();
    /**
     * Class that represents the rule by which others can connect to this connectable
     * 
     * This object is required, but will be derived from securityGroup if that is passed.
     * @default Derived from securityGroup if set.
     */
    void setSecurityGroupRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule value);
    /**
     * What securityGroup(s) this object is managing connections for
     * @default No security groups
     */
    java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> getSecurityGroups();
    /**
     * What securityGroup(s) this object is managing connections for
     * @default No security groups
     */
    void setSecurityGroups(final java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> value);

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ConnectionsProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.IPortRange _defaultPortRange;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroupRule _securityGroupRule;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> _securityGroups;

        /**
         * Sets the value of DefaultPortRange
         * @param value Default port range for initiating connections to and from this object
         * @return {@code this}
         */
        public Builder withDefaultPortRange(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange value) {
            this._defaultPortRange = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupRule
         * @param value Class that represents the rule by which others can connect to this connectable

This object is required, but will be derived from securityGroup if that is passed.
         * @return {@code this}
         */
        public Builder withSecurityGroupRule(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroupRule value) {
            this._securityGroupRule = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroups
         * @param value What securityGroup(s) this object is managing connections for
         * @return {@code this}
         */
        public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> value) {
            this._securityGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ConnectionsProps build() {
            return new ConnectionsProps() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.IPortRange $defaultPortRange = _defaultPortRange;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.ISecurityGroupRule $securityGroupRule = _securityGroupRule;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> $securityGroups = _securityGroups;

                @Override
                public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
                    return this.$defaultPortRange;
                }

                @Override
                public void setDefaultPortRange(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange value) {
                    this.$defaultPortRange = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule() {
                    return this.$securityGroupRule;
                }

                @Override
                public void setSecurityGroupRule(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroupRule value) {
                    this.$securityGroupRule = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> getSecurityGroups() {
                    return this.$securityGroups;
                }

                @Override
                public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> value) {
                    this.$securityGroups = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ConnectionsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Default port range for initiating connections to and from this object
         * @default No default port range
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
            return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
        }

        /**
         * Default port range for initiating connections to and from this object
         * @default No default port range
         */
        @Override
        public void setDefaultPortRange(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange value) {
            this.jsiiSet("defaultPortRange", value);
        }

        /**
         * Class that represents the rule by which others can connect to this connectable
         * 
         * This object is required, but will be derived from securityGroup if that is passed.
         * @default Derived from securityGroup if set.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule() {
            return this.jsiiGet("securityGroupRule", software.amazon.awscdk.services.ec2.ISecurityGroupRule.class);
        }

        /**
         * Class that represents the rule by which others can connect to this connectable
         * 
         * This object is required, but will be derived from securityGroup if that is passed.
         * @default Derived from securityGroup if set.
         */
        @Override
        public void setSecurityGroupRule(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroupRule value) {
            this.jsiiSet("securityGroupRule", value);
        }

        /**
         * What securityGroup(s) this object is managing connections for
         * @default No security groups
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> getSecurityGroups() {
            return this.jsiiGet("securityGroups", java.util.List.class);
        }

        /**
         * What securityGroup(s) this object is managing connections for
         * @default No security groups
         */
        @Override
        public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SecurityGroupRef> value) {
            this.jsiiSet("securityGroups", value);
        }
    }
}
