package software.amazon.awscdk.services.ec2;

/**
 * Properties that reference an external VpcNetwork
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:19:22.433Z")
public interface VpcNetworkRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * List of availability zones for the subnets in this VPC.
     */
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * List of availability zones for the subnets in this VPC.
     */
    void setAvailabilityZones(final java.util.List<java.lang.String> value);
    /**
     * VPC's identifier
     */
    java.lang.String getVpcId();
    /**
     * VPC's identifier
     */
    void setVpcId(final java.lang.String value);
    /**
     * List of isolated subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    java.util.List<java.lang.String> getIsolatedSubnetIds();
    /**
     * List of isolated subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    void setIsolatedSubnetIds(final java.util.List<java.lang.String> value);
    /**
     * List of names for the isolated subnets
     * 
     * Must be undefined or have a name for every isolated subnet group.
     */
    java.util.List<java.lang.String> getIsolatedSubnetNames();
    /**
     * List of names for the isolated subnets
     * 
     * Must be undefined or have a name for every isolated subnet group.
     */
    void setIsolatedSubnetNames(final java.util.List<java.lang.String> value);
    /**
     * List of private subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    java.util.List<java.lang.String> getPrivateSubnetIds();
    /**
     * List of private subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    void setPrivateSubnetIds(final java.util.List<java.lang.String> value);
    /**
     * List of names for the private subnets
     * 
     * Must be undefined or have a name for every private subnet group.
     */
    java.util.List<java.lang.String> getPrivateSubnetNames();
    /**
     * List of names for the private subnets
     * 
     * Must be undefined or have a name for every private subnet group.
     */
    void setPrivateSubnetNames(final java.util.List<java.lang.String> value);
    /**
     * List of public subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    java.util.List<java.lang.String> getPublicSubnetIds();
    /**
     * List of public subnet IDs
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    void setPublicSubnetIds(final java.util.List<java.lang.String> value);
    /**
     * List of names for the public subnets
     * 
     * Must be undefined or have a name for every public subnet group.
     */
    java.util.List<java.lang.String> getPublicSubnetNames();
    /**
     * List of names for the public subnets
     * 
     * Must be undefined or have a name for every public subnet group.
     */
    void setPublicSubnetNames(final java.util.List<java.lang.String> value);

    /**
     * @return a {@link Builder} of {@link VpcNetworkRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcNetworkRefProps}
     */
    final class Builder {
        private java.util.List<java.lang.String> _availabilityZones;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetNames;

        /**
         * Sets the value of AvailabilityZones
         * @param value List of availability zones for the subnets in this VPC.
         * @return {@code this}
         */
        public Builder withAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value VPC's identifier
         * @return {@code this}
         */
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetIds
         * @param value List of isolated subnet IDs

Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        public Builder withIsolatedSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetNames
         * @param value List of names for the isolated subnets

Must be undefined or have a name for every isolated subnet group.
         * @return {@code this}
         */
        public Builder withIsolatedSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetIds
         * @param value List of private subnet IDs

Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        public Builder withPrivateSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetNames
         * @param value List of names for the private subnets

Must be undefined or have a name for every private subnet group.
         * @return {@code this}
         */
        public Builder withPrivateSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetIds
         * @param value List of public subnet IDs

Must be undefined or match the availability zones in length and order.
         * @return {@code this}
         */
        public Builder withPublicSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetNames
         * @param value List of names for the public subnets

Must be undefined or have a name for every public subnet group.
         * @return {@code this}
         */
        public Builder withPublicSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetNames = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcNetworkRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcNetworkRefProps build() {
            return new VpcNetworkRefProps() {
                private java.util.List<java.lang.String> $availabilityZones = java.util.Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                private java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $isolatedSubnetIds = _isolatedSubnetIds;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $isolatedSubnetNames = _isolatedSubnetNames;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $privateSubnetIds = _privateSubnetIds;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $privateSubnetNames = _privateSubnetNames;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $publicSubnetIds = _publicSubnetIds;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $publicSubnetNames = _publicSubnetNames;

                @Override
                public java.util.List<java.lang.String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public void setAvailabilityZones(final java.util.List<java.lang.String> value) {
                    this.$availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public void setVpcId(final java.lang.String value) {
                    this.$vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetIds() {
                    return this.$isolatedSubnetIds;
                }

                @Override
                public void setIsolatedSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$isolatedSubnetIds = value;
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetNames() {
                    return this.$isolatedSubnetNames;
                }

                @Override
                public void setIsolatedSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$isolatedSubnetNames = value;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetIds() {
                    return this.$privateSubnetIds;
                }

                @Override
                public void setPrivateSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$privateSubnetIds = value;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetNames() {
                    return this.$privateSubnetNames;
                }

                @Override
                public void setPrivateSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$privateSubnetNames = value;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetIds() {
                    return this.$publicSubnetIds;
                }

                @Override
                public void setPublicSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$publicSubnetIds = value;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetNames() {
                    return this.$publicSubnetNames;
                }

                @Override
                public void setPublicSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$publicSubnetNames = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcNetworkRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * List of availability zones for the subnets in this VPC.
         */
        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * List of availability zones for the subnets in this VPC.
         */
        @Override
        public void setAvailabilityZones(final java.util.List<java.lang.String> value) {
            this.jsiiSet("availabilityZones", java.util.Objects.requireNonNull(value, "availabilityZones is required"));
        }

        /**
         * VPC's identifier
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * VPC's identifier
         */
        @Override
        public void setVpcId(final java.lang.String value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }

        /**
         * List of isolated subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.jsiiGet("isolatedSubnetIds", java.util.List.class);
        }

        /**
         * List of isolated subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        public void setIsolatedSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("isolatedSubnetIds", value);
        }

        /**
         * List of names for the isolated subnets
         * 
         * Must be undefined or have a name for every isolated subnet group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.jsiiGet("isolatedSubnetNames", java.util.List.class);
        }

        /**
         * List of names for the isolated subnets
         * 
         * Must be undefined or have a name for every isolated subnet group.
         */
        @Override
        public void setIsolatedSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("isolatedSubnetNames", value);
        }

        /**
         * List of private subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.jsiiGet("privateSubnetIds", java.util.List.class);
        }

        /**
         * List of private subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        public void setPrivateSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("privateSubnetIds", value);
        }

        /**
         * List of names for the private subnets
         * 
         * Must be undefined or have a name for every private subnet group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.jsiiGet("privateSubnetNames", java.util.List.class);
        }

        /**
         * List of names for the private subnets
         * 
         * Must be undefined or have a name for every private subnet group.
         */
        @Override
        public void setPrivateSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("privateSubnetNames", value);
        }

        /**
         * List of public subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.jsiiGet("publicSubnetIds", java.util.List.class);
        }

        /**
         * List of public subnet IDs
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        public void setPublicSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("publicSubnetIds", value);
        }

        /**
         * List of names for the public subnets
         * 
         * Must be undefined or have a name for every public subnet group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.jsiiGet("publicSubnetNames", java.util.List.class);
        }

        /**
         * List of names for the public subnets
         * 
         * Must be undefined or have a name for every public subnet group.
         */
        @Override
        public void setPublicSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("publicSubnetNames", value);
        }
    }
}
