package software.amazon.awscdk.services.ec2;

import static java.util.Arrays.asList;

import java.util.List;
import software.amazon.jsii.JsiiModule;

public final class $Module extends JsiiModule {
    public $Module() {
        super("@aws-cdk/aws-ec2", "0.21.0", $Module.class, "aws-ec2@0.21.0.jsii.tgz");
    }

    @Override
    public List<Class<? extends JsiiModule>> getDependencies() {
        return asList(software.amazon.awscdk.services.iam.$Module.class, software.amazon.awscdk.$Module.class, software.amazon.awscdk.cxapi.$Module.class);
    }

    @Override
    protected Class<?> resolveClass(final String fqn) throws ClassNotFoundException {
        switch (fqn) {
            case "@aws-cdk/aws-ec2.AllTraffic": return software.amazon.awscdk.services.ec2.AllTraffic.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxEdition": return software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxGeneration": return software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxImage": return software.amazon.awscdk.services.ec2.AmazonLinuxImage.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxImageProps": return software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxStorage": return software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxVirt": return software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class;
            case "@aws-cdk/aws-ec2.AnyIPv4": return software.amazon.awscdk.services.ec2.AnyIPv4.class;
            case "@aws-cdk/aws-ec2.AnyIPv6": return software.amazon.awscdk.services.ec2.AnyIPv6.class;
            case "@aws-cdk/aws-ec2.CfnCustomerGateway": return software.amazon.awscdk.services.ec2.CfnCustomerGateway.class;
            case "@aws-cdk/aws-ec2.CfnCustomerGatewayProps": return software.amazon.awscdk.services.ec2.CfnCustomerGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnDHCPOptions": return software.amazon.awscdk.services.ec2.CfnDHCPOptions.class;
            case "@aws-cdk/aws-ec2.CfnDHCPOptionsProps": return software.amazon.awscdk.services.ec2.CfnDHCPOptionsProps.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TagRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2FleetProps": return software.amazon.awscdk.services.ec2.CfnEC2FleetProps.class;
            case "@aws-cdk/aws-ec2.CfnEIP": return software.amazon.awscdk.services.ec2.CfnEIP.class;
            case "@aws-cdk/aws-ec2.CfnEIPAssociation": return software.amazon.awscdk.services.ec2.CfnEIPAssociation.class;
            case "@aws-cdk/aws-ec2.CfnEIPAssociationProps": return software.amazon.awscdk.services.ec2.CfnEIPAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnEIPProps": return software.amazon.awscdk.services.ec2.CfnEIPProps.class;
            case "@aws-cdk/aws-ec2.CfnEgressOnlyInternetGateway": return software.amazon.awscdk.services.ec2.CfnEgressOnlyInternetGateway.class;
            case "@aws-cdk/aws-ec2.CfnEgressOnlyInternetGatewayProps": return software.amazon.awscdk.services.ec2.CfnEgressOnlyInternetGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnFlowLog": return software.amazon.awscdk.services.ec2.CfnFlowLog.class;
            case "@aws-cdk/aws-ec2.CfnFlowLogProps": return software.amazon.awscdk.services.ec2.CfnFlowLogProps.class;
            case "@aws-cdk/aws-ec2.CfnHost": return software.amazon.awscdk.services.ec2.CfnHost.class;
            case "@aws-cdk/aws-ec2.CfnHostProps": return software.amazon.awscdk.services.ec2.CfnHostProps.class;
            case "@aws-cdk/aws-ec2.CfnInstance": return software.amazon.awscdk.services.ec2.CfnInstance.class;
            case "@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty": return software.amazon.awscdk.services.ec2.CfnInstance.AssociationParameterProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnInstance.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.EbsProperty": return software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty": return software.amazon.awscdk.services.ec2.CfnInstance.ElasticInferenceAcceleratorProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnInstance.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.LicenseSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.CfnInstance.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty": return software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.SsmAssociationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.VolumeProperty": return software.amazon.awscdk.services.ec2.CfnInstance.VolumeProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstanceProps": return software.amazon.awscdk.services.ec2.CfnInstanceProps.class;
            case "@aws-cdk/aws-ec2.CfnInternetGateway": return software.amazon.awscdk.services.ec2.CfnInternetGateway.class;
            case "@aws-cdk/aws-ec2.CfnInternetGatewayProps": return software.amazon.awscdk.services.ec2.CfnInternetGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.Ipv6AddProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateIpAddProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplateProps": return software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.class;
            case "@aws-cdk/aws-ec2.CfnNatGateway": return software.amazon.awscdk.services.ec2.CfnNatGateway.class;
            case "@aws-cdk/aws-ec2.CfnNatGatewayProps": return software.amazon.awscdk.services.ec2.CfnNatGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAcl": return software.amazon.awscdk.services.ec2.CfnNetworkAcl.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry.IcmpProperty": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.IcmpProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry.PortRangeProperty": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.PortRangeProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntryProps": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntryProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclProps": return software.amazon.awscdk.services.ec2.CfnNetworkAclProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceAttachment": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceAttachmentProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfacePermission": return software.amazon.awscdk.services.ec2.CfnNetworkInterfacePermission.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfacePermissionProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfacePermissionProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps.class;
            case "@aws-cdk/aws-ec2.CfnPlacementGroup": return software.amazon.awscdk.services.ec2.CfnPlacementGroup.class;
            case "@aws-cdk/aws-ec2.CfnPlacementGroupProps": return software.amazon.awscdk.services.ec2.CfnPlacementGroupProps.class;
            case "@aws-cdk/aws-ec2.CfnRoute": return software.amazon.awscdk.services.ec2.CfnRoute.class;
            case "@aws-cdk/aws-ec2.CfnRouteProps": return software.amazon.awscdk.services.ec2.CfnRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnRouteTable": return software.amazon.awscdk.services.ec2.CfnRouteTable.class;
            case "@aws-cdk/aws-ec2.CfnRouteTableProps": return software.amazon.awscdk.services.ec2.CfnRouteTableProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup.EgressProperty": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup.IngressProperty": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupEgress": return software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupEgressProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupIngress": return software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupIngressProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupIngressProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet": return software.amazon.awscdk.services.ec2.CfnSpotFleet.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancerProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.GroupIdentifierProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateOverridesProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleetProps": return software.amazon.awscdk.services.ec2.CfnSpotFleetProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnet": return software.amazon.awscdk.services.ec2.CfnSubnet.class;
            case "@aws-cdk/aws-ec2.CfnSubnetCidrBlock": return software.amazon.awscdk.services.ec2.CfnSubnetCidrBlock.class;
            case "@aws-cdk/aws-ec2.CfnSubnetCidrBlockProps": return software.amazon.awscdk.services.ec2.CfnSubnetCidrBlockProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetNetworkAclAssociation": return software.amazon.awscdk.services.ec2.CfnSubnetNetworkAclAssociation.class;
            case "@aws-cdk/aws-ec2.CfnSubnetNetworkAclAssociationProps": return software.amazon.awscdk.services.ec2.CfnSubnetNetworkAclAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetProps": return software.amazon.awscdk.services.ec2.CfnSubnetProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetRouteTableAssociation": return software.amazon.awscdk.services.ec2.CfnSubnetRouteTableAssociation.class;
            case "@aws-cdk/aws-ec2.CfnSubnetRouteTableAssociationProps": return software.amazon.awscdk.services.ec2.CfnSubnetRouteTableAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGateway": return software.amazon.awscdk.services.ec2.CfnTransitGateway.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayAttachment": return software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachment.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayAttachmentProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRoute": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRoute.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTable": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTable.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableAssociation": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableAssociation.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableAssociationProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTablePropagation": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTablePropagation.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTablePropagationProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTablePropagationProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableProps.class;
            case "@aws-cdk/aws-ec2.CfnTrunkInterfaceAssociation": return software.amazon.awscdk.services.ec2.CfnTrunkInterfaceAssociation.class;
            case "@aws-cdk/aws-ec2.CfnTrunkInterfaceAssociationProps": return software.amazon.awscdk.services.ec2.CfnTrunkInterfaceAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnVPC": return software.amazon.awscdk.services.ec2.CfnVPC.class;
            case "@aws-cdk/aws-ec2.CfnVPCCidrBlock": return software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.class;
            case "@aws-cdk/aws-ec2.CfnVPCCidrBlockProps": return software.amazon.awscdk.services.ec2.CfnVPCCidrBlockProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCDHCPOptionsAssociation": return software.amazon.awscdk.services.ec2.CfnVPCDHCPOptionsAssociation.class;
            case "@aws-cdk/aws-ec2.CfnVPCDHCPOptionsAssociationProps": return software.amazon.awscdk.services.ec2.CfnVPCDHCPOptionsAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpoint": return software.amazon.awscdk.services.ec2.CfnVPCEndpoint.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointConnectionNotification": return software.amazon.awscdk.services.ec2.CfnVPCEndpointConnectionNotification.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointConnectionNotificationProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointConnectionNotificationProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissions": return software.amazon.awscdk.services.ec2.CfnVPCEndpointServicePermissions.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointServicePermissionsProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCGatewayAttachment": return software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachment.class;
            case "@aws-cdk/aws-ec2.CfnVPCGatewayAttachmentProps": return software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCPeeringConnection": return software.amazon.awscdk.services.ec2.CfnVPCPeeringConnection.class;
            case "@aws-cdk/aws-ec2.CfnVPCPeeringConnectionProps": return software.amazon.awscdk.services.ec2.CfnVPCPeeringConnectionProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCProps": return software.amazon.awscdk.services.ec2.CfnVPCProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnection": return software.amazon.awscdk.services.ec2.CfnVPNConnection.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionProps": return software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionRoute": return software.amazon.awscdk.services.ec2.CfnVPNConnectionRoute.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionRouteProps": return software.amazon.awscdk.services.ec2.CfnVPNConnectionRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNGateway": return software.amazon.awscdk.services.ec2.CfnVPNGateway.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayProps": return software.amazon.awscdk.services.ec2.CfnVPNGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayRoutePropagation": return software.amazon.awscdk.services.ec2.CfnVPNGatewayRoutePropagation.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayRoutePropagationProps": return software.amazon.awscdk.services.ec2.CfnVPNGatewayRoutePropagationProps.class;
            case "@aws-cdk/aws-ec2.CfnVolume": return software.amazon.awscdk.services.ec2.CfnVolume.class;
            case "@aws-cdk/aws-ec2.CfnVolumeAttachment": return software.amazon.awscdk.services.ec2.CfnVolumeAttachment.class;
            case "@aws-cdk/aws-ec2.CfnVolumeAttachmentProps": return software.amazon.awscdk.services.ec2.CfnVolumeAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnVolumeProps": return software.amazon.awscdk.services.ec2.CfnVolumeProps.class;
            case "@aws-cdk/aws-ec2.CidrIPv4": return software.amazon.awscdk.services.ec2.CidrIPv4.class;
            case "@aws-cdk/aws-ec2.CidrIPv6": return software.amazon.awscdk.services.ec2.CidrIPv6.class;
            case "@aws-cdk/aws-ec2.ConnectionRule": return software.amazon.awscdk.services.ec2.ConnectionRule.class;
            case "@aws-cdk/aws-ec2.Connections": return software.amazon.awscdk.services.ec2.Connections.class;
            case "@aws-cdk/aws-ec2.ConnectionsProps": return software.amazon.awscdk.services.ec2.ConnectionsProps.class;
            case "@aws-cdk/aws-ec2.DefaultInstanceTenancy": return software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class;
            case "@aws-cdk/aws-ec2.GenericLinuxImage": return software.amazon.awscdk.services.ec2.GenericLinuxImage.class;
            case "@aws-cdk/aws-ec2.IConnectable": return software.amazon.awscdk.services.ec2.IConnectable.class;
            case "@aws-cdk/aws-ec2.IMachineImageSource": return software.amazon.awscdk.services.ec2.IMachineImageSource.class;
            case "@aws-cdk/aws-ec2.IPortRange": return software.amazon.awscdk.services.ec2.IPortRange.class;
            case "@aws-cdk/aws-ec2.ISecurityGroupRule": return software.amazon.awscdk.services.ec2.ISecurityGroupRule.class;
            case "@aws-cdk/aws-ec2.IcmpAllTypeCodes": return software.amazon.awscdk.services.ec2.IcmpAllTypeCodes.class;
            case "@aws-cdk/aws-ec2.IcmpAllTypesAndCodes": return software.amazon.awscdk.services.ec2.IcmpAllTypesAndCodes.class;
            case "@aws-cdk/aws-ec2.IcmpPing": return software.amazon.awscdk.services.ec2.IcmpPing.class;
            case "@aws-cdk/aws-ec2.IcmpTypeAndCode": return software.amazon.awscdk.services.ec2.IcmpTypeAndCode.class;
            case "@aws-cdk/aws-ec2.InstanceClass": return software.amazon.awscdk.services.ec2.InstanceClass.class;
            case "@aws-cdk/aws-ec2.InstanceSize": return software.amazon.awscdk.services.ec2.InstanceSize.class;
            case "@aws-cdk/aws-ec2.InstanceType": return software.amazon.awscdk.services.ec2.InstanceType.class;
            case "@aws-cdk/aws-ec2.InstanceTypePair": return software.amazon.awscdk.services.ec2.InstanceTypePair.class;
            case "@aws-cdk/aws-ec2.LinuxOS": return software.amazon.awscdk.services.ec2.LinuxOS.class;
            case "@aws-cdk/aws-ec2.MachineImage": return software.amazon.awscdk.services.ec2.MachineImage.class;
            case "@aws-cdk/aws-ec2.NetworkInterfaceSecondaryPrivateIpAddresses": return software.amazon.awscdk.services.ec2.NetworkInterfaceSecondaryPrivateIpAddresses.class;
            case "@aws-cdk/aws-ec2.OperatingSystem": return software.amazon.awscdk.services.ec2.OperatingSystem.class;
            case "@aws-cdk/aws-ec2.OperatingSystemType": return software.amazon.awscdk.services.ec2.OperatingSystemType.class;
            case "@aws-cdk/aws-ec2.PrefixList": return software.amazon.awscdk.services.ec2.PrefixList.class;
            case "@aws-cdk/aws-ec2.Protocol": return software.amazon.awscdk.services.ec2.Protocol.class;
            case "@aws-cdk/aws-ec2.SecurityGroup": return software.amazon.awscdk.services.ec2.SecurityGroup.class;
            case "@aws-cdk/aws-ec2.SecurityGroupProps": return software.amazon.awscdk.services.ec2.SecurityGroupProps.class;
            case "@aws-cdk/aws-ec2.SecurityGroupRef": return software.amazon.awscdk.services.ec2.SecurityGroupRef.class;
            case "@aws-cdk/aws-ec2.SecurityGroupRefProps": return software.amazon.awscdk.services.ec2.SecurityGroupRefProps.class;
            case "@aws-cdk/aws-ec2.SubnetConfiguration": return software.amazon.awscdk.services.ec2.SubnetConfiguration.class;
            case "@aws-cdk/aws-ec2.SubnetIpv6CidrBlocks": return software.amazon.awscdk.services.ec2.SubnetIpv6CidrBlocks.class;
            case "@aws-cdk/aws-ec2.SubnetType": return software.amazon.awscdk.services.ec2.SubnetType.class;
            case "@aws-cdk/aws-ec2.TcpAllPorts": return software.amazon.awscdk.services.ec2.TcpAllPorts.class;
            case "@aws-cdk/aws-ec2.TcpPort": return software.amazon.awscdk.services.ec2.TcpPort.class;
            case "@aws-cdk/aws-ec2.TcpPortFromAttribute": return software.amazon.awscdk.services.ec2.TcpPortFromAttribute.class;
            case "@aws-cdk/aws-ec2.TcpPortRange": return software.amazon.awscdk.services.ec2.TcpPortRange.class;
            case "@aws-cdk/aws-ec2.UdpAllPorts": return software.amazon.awscdk.services.ec2.UdpAllPorts.class;
            case "@aws-cdk/aws-ec2.UdpPort": return software.amazon.awscdk.services.ec2.UdpPort.class;
            case "@aws-cdk/aws-ec2.UdpPortFromAttribute": return software.amazon.awscdk.services.ec2.UdpPortFromAttribute.class;
            case "@aws-cdk/aws-ec2.UdpPortRange": return software.amazon.awscdk.services.ec2.UdpPortRange.class;
            case "@aws-cdk/aws-ec2.VPCCidrBlockAssociations": return software.amazon.awscdk.services.ec2.VPCCidrBlockAssociations.class;
            case "@aws-cdk/aws-ec2.VPCEndpointDnsEntries": return software.amazon.awscdk.services.ec2.VPCEndpointDnsEntries.class;
            case "@aws-cdk/aws-ec2.VPCEndpointNetworkInterfaceIds": return software.amazon.awscdk.services.ec2.VPCEndpointNetworkInterfaceIds.class;
            case "@aws-cdk/aws-ec2.VPCIpv6CidrBlocks": return software.amazon.awscdk.services.ec2.VPCIpv6CidrBlocks.class;
            case "@aws-cdk/aws-ec2.VpcNetwork": return software.amazon.awscdk.services.ec2.VpcNetwork.class;
            case "@aws-cdk/aws-ec2.VpcNetworkProps": return software.amazon.awscdk.services.ec2.VpcNetworkProps.class;
            case "@aws-cdk/aws-ec2.VpcNetworkProvider": return software.amazon.awscdk.services.ec2.VpcNetworkProvider.class;
            case "@aws-cdk/aws-ec2.VpcNetworkProviderProps": return software.amazon.awscdk.services.ec2.VpcNetworkProviderProps.class;
            case "@aws-cdk/aws-ec2.VpcNetworkRef": return software.amazon.awscdk.services.ec2.VpcNetworkRef.class;
            case "@aws-cdk/aws-ec2.VpcNetworkRefProps": return software.amazon.awscdk.services.ec2.VpcNetworkRefProps.class;
            case "@aws-cdk/aws-ec2.VpcPlacementStrategy": return software.amazon.awscdk.services.ec2.VpcPlacementStrategy.class;
            case "@aws-cdk/aws-ec2.VpcPrivateSubnet": return software.amazon.awscdk.services.ec2.VpcPrivateSubnet.class;
            case "@aws-cdk/aws-ec2.VpcPublicSubnet": return software.amazon.awscdk.services.ec2.VpcPublicSubnet.class;
            case "@aws-cdk/aws-ec2.VpcSubnet": return software.amazon.awscdk.services.ec2.VpcSubnet.class;
            case "@aws-cdk/aws-ec2.VpcSubnetProps": return software.amazon.awscdk.services.ec2.VpcSubnetProps.class;
            case "@aws-cdk/aws-ec2.VpcSubnetRef": return software.amazon.awscdk.services.ec2.VpcSubnetRef.class;
            case "@aws-cdk/aws-ec2.VpcSubnetRefProps": return software.amazon.awscdk.services.ec2.VpcSubnetRefProps.class;
            case "@aws-cdk/aws-ec2.WindowsImage": return software.amazon.awscdk.services.ec2.WindowsImage.class;
            case "@aws-cdk/aws-ec2.WindowsOS": return software.amazon.awscdk.services.ec2.WindowsOS.class;
            case "@aws-cdk/aws-ec2.WindowsVersion": return software.amazon.awscdk.services.ec2.WindowsVersion.class;
            case "@aws-cdk/aws-ec2.cloudformation.CustomerGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.CustomerGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.CustomerGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.CustomerGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.DHCPOptionsResource": return software.amazon.awscdk.services.ec2.cloudformation.DHCPOptionsResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.DHCPOptionsResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.DHCPOptionsResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateConfigRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateConfigRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateOverridesRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateOverridesRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateSpecificationRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.FleetLaunchTemplateSpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.OnDemandOptionsRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.OnDemandOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.SpotOptionsRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.SpotOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.TagRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.TagRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResource.TargetCapacitySpecificationRequestProperty": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResource.TargetCapacitySpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.EC2FleetResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.EC2FleetResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.EIPAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.EIPAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.EIPAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.EIPAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.EIPResource": return software.amazon.awscdk.services.ec2.cloudformation.EIPResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.EIPResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.EIPResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.EgressOnlyInternetGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.EgressOnlyInternetGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.EgressOnlyInternetGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.EgressOnlyInternetGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.FlowLogResource": return software.amazon.awscdk.services.ec2.cloudformation.FlowLogResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.FlowLogResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.FlowLogResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.HostResource": return software.amazon.awscdk.services.ec2.cloudformation.HostResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.HostResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.HostResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.AssociationParameterProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.AssociationParameterProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.EbsProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.EbsProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.ElasticInferenceAcceleratorProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.ElasticInferenceAcceleratorProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.LaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.LaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.LicenseSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.LicenseSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.NoDeviceProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.NoDeviceProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.SsmAssociationProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.SsmAssociationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResource.VolumeProperty": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResource.VolumeProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.InstanceResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.InstanceResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.InternetGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.InternetGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.InternetGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.InternetGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.EbsProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.EbsProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.IamInstanceProfileProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.InstanceMarketOptionsProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.Ipv6AddProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.Ipv6AddProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.LaunchTemplateDataProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.LaunchTemplateDataProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.MonitoringProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.MonitoringProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.PlacementProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PlacementProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.PrivateIpAddProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.PrivateIpAddProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.SpotOptionsProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResource.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResource.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.LaunchTemplateResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.LaunchTemplateResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NatGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.NatGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NatGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NatGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclEntryResource": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclEntryResource.IcmpProperty": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.IcmpProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclEntryResource.PortRangeProperty": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResource.PortRangeProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclEntryResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclEntryResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclResource": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkAclResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NetworkAclResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceAttachmentResource": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceAttachmentResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceAttachmentResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceAttachmentResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfacePermissionResource": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfacePermissionResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfacePermissionResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfacePermissionResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceResource": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceResource.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResource.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.NetworkInterfaceResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.NetworkInterfaceResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.PlacementGroupResource": return software.amazon.awscdk.services.ec2.cloudformation.PlacementGroupResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.PlacementGroupResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.PlacementGroupResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.RouteResource": return software.amazon.awscdk.services.ec2.cloudformation.RouteResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.RouteResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.RouteResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.RouteTableResource": return software.amazon.awscdk.services.ec2.cloudformation.RouteTableResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.RouteTableResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.RouteTableResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupEgressResource": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupEgressResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupEgressResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupEgressResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupIngressResource": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupIngressResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupIngressResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupIngressResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResource": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResource.EgressProperty": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.EgressProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResource.IngressProperty": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResource.IngressProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SecurityGroupResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SecurityGroupResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.ClassicLoadBalancerProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.ClassicLoadBalancerProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.ClassicLoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.ClassicLoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.EbsBlockDeviceProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.FleetLaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.FleetLaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.GroupIdentifierProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.GroupIdentifierProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.IamInstanceProfileSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.InstanceNetworkInterfaceSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.LaunchTemplateConfigProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.LaunchTemplateConfigProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.LaunchTemplateOverridesProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.LaunchTemplateOverridesProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.LoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.LoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.SpotFleetLaunchSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetLaunchSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetMonitoringProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetRequestConfigDataProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.SpotFleetTagSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotFleetTagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.SpotPlacementProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.SpotPlacementProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.TargetGroupProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.TargetGroupProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResource.TargetGroupsConfigProperty": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResource.TargetGroupsConfigProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.SpotFleetResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SpotFleetResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetCidrBlockResource": return software.amazon.awscdk.services.ec2.cloudformation.SubnetCidrBlockResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetCidrBlockResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SubnetCidrBlockResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetNetworkAclAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.SubnetNetworkAclAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetNetworkAclAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SubnetNetworkAclAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetResource": return software.amazon.awscdk.services.ec2.cloudformation.SubnetResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SubnetResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetRouteTableAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.SubnetRouteTableAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.SubnetRouteTableAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.SubnetRouteTableAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayAttachmentResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayAttachmentResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayAttachmentResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayAttachmentResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTableAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTableAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTableAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTableAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTablePropagationResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTablePropagationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTablePropagationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTablePropagationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTableResource": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTableResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TransitGatewayRouteTableResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TransitGatewayRouteTableResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.TrunkInterfaceAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.TrunkInterfaceAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.TrunkInterfaceAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.TrunkInterfaceAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCCidrBlockResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCCidrBlockResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCCidrBlockResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCCidrBlockResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCDHCPOptionsAssociationResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCDHCPOptionsAssociationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCDHCPOptionsAssociationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCDHCPOptionsAssociationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointConnectionNotificationResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointConnectionNotificationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointConnectionNotificationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointConnectionNotificationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointServicePermissionsResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointServicePermissionsResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCEndpointServicePermissionsResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCEndpointServicePermissionsResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCGatewayAttachmentResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCGatewayAttachmentResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCGatewayAttachmentResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCGatewayAttachmentResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCPeeringConnectionResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCPeeringConnectionResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCPeeringConnectionResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCPeeringConnectionResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCResource": return software.amazon.awscdk.services.ec2.cloudformation.VPCResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPCResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPCResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNConnectionResource": return software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNConnectionResource.VpnTunnelOptionsSpecificationProperty": return software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResource.VpnTunnelOptionsSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNConnectionResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNConnectionRouteResource": return software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionRouteResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNConnectionRouteResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPNConnectionRouteResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNGatewayResource": return software.amazon.awscdk.services.ec2.cloudformation.VPNGatewayResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNGatewayResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPNGatewayResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNGatewayRoutePropagationResource": return software.amazon.awscdk.services.ec2.cloudformation.VPNGatewayRoutePropagationResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VPNGatewayRoutePropagationResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VPNGatewayRoutePropagationResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VolumeAttachmentResource": return software.amazon.awscdk.services.ec2.cloudformation.VolumeAttachmentResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VolumeAttachmentResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VolumeAttachmentResourceProps.class;
            case "@aws-cdk/aws-ec2.cloudformation.VolumeResource": return software.amazon.awscdk.services.ec2.cloudformation.VolumeResource.class;
            case "@aws-cdk/aws-ec2.cloudformation.VolumeResourceProps": return software.amazon.awscdk.services.ec2.cloudformation.VolumeResourceProps.class;
            default: throw new ClassNotFoundException("Unknown JSII type: " + fqn);
        }
    }
}
