package software.amazon.awscdk.services.ec2;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:30:41.571Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.Resource {
    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnInstance.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::Instance``.
     * @param parent the ``cdk.Construct`` this ``CfnInstance`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CfnInstance``
     */
    public CfnInstance(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstanceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::EC2::Instance``.
     * @param parent the ``cdk.Construct`` this ``CfnInstance`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public CfnInstance(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute AvailabilityZone
     */
    public java.lang.String getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", java.lang.String.class);
    }

    public java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute PrivateDnsName
     */
    public java.lang.String getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute PrivateIp
     */
    public java.lang.String getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute PublicDnsName
     */
    public java.lang.String getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute PublicIp
     */
    public java.lang.String getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", java.lang.String.class);
    }

    public software.amazon.awscdk.services.ec2.CfnInstanceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnInstanceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    public static interface AssociationParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        java.lang.Object getKey();
        /**
         * ``CfnInstance.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnInstance.AssociationParameterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        java.lang.Object getValue();
        /**
         * ``CfnInstance.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        void setValue(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.AssociationParameterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        void setValue(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link AssociationParameterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AssociationParameterProperty}
         */
        final class Builder {
            private java.lang.Object _key;
            private java.lang.Object _value;

            /**
             * Sets the value of Key
             * @param value ``CfnInstance.AssociationParameterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``CfnInstance.AssociationParameterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnInstance.AssociationParameterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnInstance.AssociationParameterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.util.List<java.lang.Object> value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AssociationParameterProperty build() {
                return new AssociationParameterProperty() {
                    private java.lang.Object $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private java.lang.Object $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.Object getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public void setKey(final software.amazon.awscdk.Token value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final software.amazon.awscdk.Token value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(final java.util.List<java.lang.Object> value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.AssociationParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            @Override
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            @Override
            public void setKey(final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            @Override
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            @Override
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }

            /**
             * ``CfnInstance.AssociationParameterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            @Override
            public void setValue(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        java.lang.Object getDeviceName();
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        void setDeviceName(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        java.lang.Object getNoDevice();
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        void setNoDevice(final software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        java.lang.Object getVirtualName();
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        void setVirtualName(final java.lang.String value);
        /**
         * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        void setVirtualName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        final class Builder {
            private java.lang.Object _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.Object _noDevice;
            @javax.annotation.Nullable
            private java.lang.Object _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
             * @return {@code this}
             */
            public Builder withDeviceName(final java.lang.String value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of DeviceName
             * @param value ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
             * @return {@code this}
             */
            public Builder withDeviceName(final software.amazon.awscdk.Token value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``CfnInstance.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``CfnInstance.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    private java.lang.Object $deviceName = java.util.Objects.requireNonNull(_deviceName, "deviceName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private java.lang.Object $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private java.lang.Object $virtualName = _virtualName;

                    @Override
                    public java.lang.Object getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(final java.lang.String value) {
                        this.$deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public void setDeviceName(final software.amazon.awscdk.Token value) {
                        this.$deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public java.lang.Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public java.lang.Object getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$virtualName = value;
                    }

                    @Override
                    public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$virtualName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            @Override
            public java.lang.Object getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            @Override
            public void setDeviceName(final java.lang.String value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            @Override
            public void setDeviceName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            @Override
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("noDevice", value);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            @Override
            public void setNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty value) {
                this.jsiiSet("noDevice", value);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            @Override
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }

            /**
             * ``CfnInstance.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            @Override
            public void setVirtualName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        java.lang.Object getCpuCredits();
        /**
         * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        void setCpuCredits(final java.lang.String value);
        /**
         * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        void setCpuCredits(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param value ``CfnInstance.CreditSpecificationProperty.CPUCredits``
             * @return {@code this}
             */
            public Builder withCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this._cpuCredits = value;
                return this;
            }
            /**
             * Sets the value of CpuCredits
             * @param value ``CfnInstance.CreditSpecificationProperty.CPUCredits``
             * @return {@code this}
             */
            public Builder withCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cpuCredits = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $cpuCredits = _cpuCredits;

                    @Override
                    public java.lang.Object getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    @Override
                    public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cpuCredits = value;
                    }

                    @Override
                    public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cpuCredits = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            @Override
            public void setCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cpuCredits", value);
            }

            /**
             * ``CfnInstance.CreditSpecificationProperty.CPUCredits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            @Override
            public void setCpuCredits(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cpuCredits", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``CfnInstance.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``CfnInstance.EbsProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``CfnInstance.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``CfnInstance.EbsProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        java.lang.Object getIops();
        /**
         * ``CfnInstance.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``CfnInstance.EbsProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        java.lang.Object getSnapshotId();
        /**
         * ``CfnInstance.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``CfnInstance.EbsProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        void setSnapshotId(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``CfnInstance.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``CfnInstance.EbsProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        java.lang.Object getVolumeType();
        /**
         * ``CfnInstance.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        void setVolumeType(final java.lang.String value);
        /**
         * ``CfnInstance.EbsProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        void setVolumeType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Object _iops;
            @javax.annotation.Nullable
            private java.lang.Object _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Object _volumeSize;
            @javax.annotation.Nullable
            private java.lang.Object _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnInstance.EbsProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnInstance.EbsProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``CfnInstance.EbsProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``CfnInstance.EbsProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``CfnInstance.EbsProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``CfnInstance.EbsProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value ``CfnInstance.EbsProperty.SnapshotId``
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value ``CfnInstance.EbsProperty.SnapshotId``
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``CfnInstance.EbsProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``CfnInstance.EbsProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value ``CfnInstance.EbsProperty.VolumeType``
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value ``CfnInstance.EbsProperty.VolumeType``
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EbsProperty build() {
                return new EbsProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private java.lang.Object $iops = _iops;
                    @javax.annotation.Nullable
                    private java.lang.Object $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private java.lang.Object $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private java.lang.Object $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public java.lang.Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$iops = value;
                    }

                    @Override
                    public java.lang.Object getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public java.lang.Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public java.lang.Object getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$volumeType = value;
                    }

                    @Override
                    public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$volumeType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnInstance.EbsProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnInstance.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``CfnInstance.EbsProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``CfnInstance.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``CfnInstance.EbsProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``CfnInstance.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            @Override
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }

            /**
             * ``CfnInstance.EbsProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            @Override
            public void setSnapshotId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("snapshotId", value);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            @Override
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }

            /**
             * ``CfnInstance.EbsProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            @Override
            public void setVolumeType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        java.lang.Object getType();
        /**
         * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        void setType(final java.lang.String value);
        /**
         * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        void setType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _type;

            /**
             * Sets the value of Type
             * @param value ``CfnInstance.ElasticGpuSpecificationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``CfnInstance.ElasticGpuSpecificationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``CfnInstance.ElasticGpuSpecificationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     */
    public static interface ElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        java.lang.Object getType();
        /**
         * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        void setType(final java.lang.String value);
        /**
         * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        void setType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ElasticInferenceAcceleratorProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticInferenceAcceleratorProperty}
         */
        final class Builder {
            private java.lang.Object _type;

            /**
             * Sets the value of Type
             * @param value ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ElasticInferenceAcceleratorProperty build() {
                return new ElasticInferenceAcceleratorProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.ElasticInferenceAcceleratorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        java.lang.Object getIpv6Address();
        /**
         * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);
        /**
         * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        void setIpv6Address(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        final class Builder {
            private java.lang.Object _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }
            /**
             * Sets the value of Ipv6Address
             * @param value ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(final software.amazon.awscdk.Token value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private java.lang.Object $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.Object getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(final java.lang.String value) {
                        this.$ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                    }

                    @Override
                    public void setIpv6Address(final software.amazon.awscdk.Token value) {
                        this.$ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            @Override
            public java.lang.Object getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            @Override
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }

            /**
             * ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            @Override
            public void setIpv6Address(final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        java.lang.Object getVersion();
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        void setVersion(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        java.lang.Object getLaunchTemplateId();
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        void setLaunchTemplateId(final java.lang.String value);
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        void setLaunchTemplateId(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        java.lang.Object getLaunchTemplateName();
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        void setLaunchTemplateName(final java.lang.String value);
        /**
         * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        void setLaunchTemplateName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _version;
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateName;

            /**
             * Sets the value of Version
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(final java.lang.String value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(final software.amazon.awscdk.Token value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @return {@code this}
             */
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @return {@code this}
             */
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @return {@code this}
             */
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @return {@code this}
             */
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateSpecificationProperty build() {
                return new LaunchTemplateSpecificationProperty() {
                    private java.lang.Object $version = java.util.Objects.requireNonNull(_version, "version is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private java.lang.Object $launchTemplateName = _launchTemplateName;

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(final java.lang.String value) {
                        this.$version = java.util.Objects.requireNonNull(value, "version is required");
                    }

                    @Override
                    public void setVersion(final software.amazon.awscdk.Token value) {
                        this.$version = java.util.Objects.requireNonNull(value, "version is required");
                    }

                    @Override
                    public java.lang.Object getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public void setLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public void setLaunchTemplateId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public java.lang.Object getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    @Override
                    public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$launchTemplateName = value;
                    }

                    @Override
                    public void setLaunchTemplateName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$launchTemplateName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            @Override
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            @Override
            public void setVersion(final java.lang.String value) {
                this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            @Override
            public void setVersion(final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            @Override
            public void setLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateId", value);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            @Override
            public void setLaunchTemplateId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateId", value);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            @Override
            public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateName", value);
            }

            /**
             * ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            @Override
            public void setLaunchTemplateName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     */
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        java.lang.Object getLicenseConfigurationArn();
        /**
         * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        void setLicenseConfigurationArn(final java.lang.String value);
        /**
         * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        void setLicenseConfigurationArn(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param value ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
             * @return {@code this}
             */
            public Builder withLicenseConfigurationArn(final java.lang.String value) {
                this._licenseConfigurationArn = java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required");
                return this;
            }
            /**
             * Sets the value of LicenseConfigurationArn
             * @param value ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
             * @return {@code this}
             */
            public Builder withLicenseConfigurationArn(final software.amazon.awscdk.Token value) {
                this._licenseConfigurationArn = java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LicenseSpecificationProperty build() {
                return new LicenseSpecificationProperty() {
                    private java.lang.Object $licenseConfigurationArn = java.util.Objects.requireNonNull(_licenseConfigurationArn, "licenseConfigurationArn is required");

                    @Override
                    public java.lang.Object getLicenseConfigurationArn() {
                        return this.$licenseConfigurationArn;
                    }

                    @Override
                    public void setLicenseConfigurationArn(final java.lang.String value) {
                        this.$licenseConfigurationArn = java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required");
                    }

                    @Override
                    public void setLicenseConfigurationArn(final software.amazon.awscdk.Token value) {
                        this.$licenseConfigurationArn = java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.LicenseSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
             */
            @Override
            public java.lang.Object getLicenseConfigurationArn() {
                return this.jsiiGet("licenseConfigurationArn", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
             */
            @Override
            public void setLicenseConfigurationArn(final java.lang.String value) {
                this.jsiiSet("licenseConfigurationArn", java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required"));
            }

            /**
             * ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
             */
            @Override
            public void setLicenseConfigurationArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("licenseConfigurationArn", java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        void setDeviceIndex(final java.lang.String value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        java.lang.Object getDescription();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        java.lang.Object getGroupSet();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        void setGroupSet(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        void setGroupSet(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        java.lang.Object getNetworkInterfaceId();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        void setNetworkInterfaceId(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        java.lang.Object getSubnetId();
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        void setSubnetId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        final class Builder {
            private java.lang.Object _deviceIndex;
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _description;
            @javax.annotation.Nullable
            private java.lang.Object _groupSet;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Object _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _subnetId;

            /**
             * Sets the value of DeviceIndex
             * @param value ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(final java.lang.String value) {
                this._deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(final software.amazon.awscdk.Token value) {
                this._deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``CfnInstance.NetworkInterfaceProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``CfnInstance.NetworkInterfaceProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of GroupSet
             * @param value ``CfnInstance.NetworkInterfaceProperty.GroupSet``
             * @return {@code this}
             */
            public Builder withGroupSet(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._groupSet = value;
                return this;
            }
            /**
             * Sets the value of GroupSet
             * @param value ``CfnInstance.NetworkInterfaceProperty.GroupSet``
             * @return {@code this}
             */
            public Builder withGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._groupSet = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``CfnInstance.NetworkInterfaceProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``CfnInstance.NetworkInterfaceProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty() {
                    private java.lang.Object $deviceIndex = java.util.Objects.requireNonNull(_deviceIndex, "deviceIndex is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $groupSet = _groupSet;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private java.lang.Object $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddress = _privateIpAddress;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private java.lang.Object $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private java.lang.Object $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(final java.lang.String value) {
                        this.$deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
                    }

                    @Override
                    public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                        this.$deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
                    }

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.Object getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getGroupSet() {
                        return this.$groupSet;
                    }

                    @Override
                    public void setGroupSet(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$groupSet = value;
                    }

                    @Override
                    public void setGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$groupSet = value;
                    }

                    @Override
                    public java.lang.Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public java.lang.Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public java.lang.Object getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$subnetId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            @Override
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            @Override
            public void setDeviceIndex(final java.lang.String value) {
                this.jsiiSet("deviceIndex", java.util.Objects.requireNonNull(value, "deviceIndex is required"));
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            @Override
            public void setDeviceIndex(final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", java.util.Objects.requireNonNull(value, "deviceIndex is required"));
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGroupSet() {
                return this.jsiiGet("groupSet", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            @Override
            public void setGroupSet(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupSet", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.GroupSet``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            @Override
            public void setGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groupSet", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            @Override
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            @Override
            public void setNetworkInterfaceId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaceId", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("privateIpAddress", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }

            /**
             * ``CfnInstance.NetworkInterfaceProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    public static interface NoDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link NoDeviceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoDeviceProperty}
         */
        final class Builder {


            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NoDeviceProperty build() {
                return new NoDeviceProperty() {

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        java.lang.Object getPrivateIpAddress();
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _primary;
            private java.lang.Object _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(final java.lang.Boolean value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(final software.amazon.awscdk.Token value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private java.lang.Object $primary = java.util.Objects.requireNonNull(_primary, "primary is required");
                    private java.lang.Object $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(final java.lang.Boolean value) {
                        this.$primary = java.util.Objects.requireNonNull(value, "primary is required");
                    }

                    @Override
                    public void setPrimary(final software.amazon.awscdk.Token value) {
                        this.$primary = java.util.Objects.requireNonNull(value, "primary is required");
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(final java.lang.String value) {
                        this.$privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                        this.$privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public void setPrimary(final java.lang.Boolean value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            public java.lang.Object getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }

            /**
             * ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    public static interface SsmAssociationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        java.lang.Object getDocumentName();
        /**
         * ``CfnInstance.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        void setDocumentName(final java.lang.String value);
        /**
         * ``CfnInstance.SsmAssociationProperty.DocumentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        void setDocumentName(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        java.lang.Object getAssociationParameters();
        /**
         * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        void setAssociationParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        void setAssociationParameters(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link SsmAssociationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SsmAssociationProperty}
         */
        final class Builder {
            private java.lang.Object _documentName;
            @javax.annotation.Nullable
            private java.lang.Object _associationParameters;

            /**
             * Sets the value of DocumentName
             * @param value ``CfnInstance.SsmAssociationProperty.DocumentName``
             * @return {@code this}
             */
            public Builder withDocumentName(final java.lang.String value) {
                this._documentName = java.util.Objects.requireNonNull(value, "documentName is required");
                return this;
            }
            /**
             * Sets the value of DocumentName
             * @param value ``CfnInstance.SsmAssociationProperty.DocumentName``
             * @return {@code this}
             */
            public Builder withDocumentName(final software.amazon.awscdk.Token value) {
                this._documentName = java.util.Objects.requireNonNull(value, "documentName is required");
                return this;
            }
            /**
             * Sets the value of AssociationParameters
             * @param value ``CfnInstance.SsmAssociationProperty.AssociationParameters``
             * @return {@code this}
             */
            public Builder withAssociationParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associationParameters = value;
                return this;
            }
            /**
             * Sets the value of AssociationParameters
             * @param value ``CfnInstance.SsmAssociationProperty.AssociationParameters``
             * @return {@code this}
             */
            public Builder withAssociationParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._associationParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SsmAssociationProperty build() {
                return new SsmAssociationProperty() {
                    private java.lang.Object $documentName = java.util.Objects.requireNonNull(_documentName, "documentName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $associationParameters = _associationParameters;

                    @Override
                    public java.lang.Object getDocumentName() {
                        return this.$documentName;
                    }

                    @Override
                    public void setDocumentName(final java.lang.String value) {
                        this.$documentName = java.util.Objects.requireNonNull(value, "documentName is required");
                    }

                    @Override
                    public void setDocumentName(final software.amazon.awscdk.Token value) {
                        this.$documentName = java.util.Objects.requireNonNull(value, "documentName is required");
                    }

                    @Override
                    public java.lang.Object getAssociationParameters() {
                        return this.$associationParameters;
                    }

                    @Override
                    public void setAssociationParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$associationParameters = value;
                    }

                    @Override
                    public void setAssociationParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$associationParameters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.SsmAssociationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            @Override
            public java.lang.Object getDocumentName() {
                return this.jsiiGet("documentName", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            @Override
            public void setDocumentName(final java.lang.String value) {
                this.jsiiSet("documentName", java.util.Objects.requireNonNull(value, "documentName is required"));
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.DocumentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            @Override
            public void setDocumentName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("documentName", java.util.Objects.requireNonNull(value, "documentName is required"));
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociationParameters() {
                return this.jsiiGet("associationParameters", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            @Override
            public void setAssociationParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associationParameters", value);
            }

            /**
             * ``CfnInstance.SsmAssociationProperty.AssociationParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            @Override
            public void setAssociationParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("associationParameters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnInstance.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        java.lang.Object getDevice();
        /**
         * ``CfnInstance.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        void setDevice(final java.lang.String value);
        /**
         * ``CfnInstance.VolumeProperty.Device``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        void setDevice(final software.amazon.awscdk.Token value);
        /**
         * ``CfnInstance.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        java.lang.Object getVolumeId();
        /**
         * ``CfnInstance.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        void setVolumeId(final java.lang.String value);
        /**
         * ``CfnInstance.VolumeProperty.VolumeId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        void setVolumeId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link VolumeProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VolumeProperty}
         */
        final class Builder {
            private java.lang.Object _device;
            private java.lang.Object _volumeId;

            /**
             * Sets the value of Device
             * @param value ``CfnInstance.VolumeProperty.Device``
             * @return {@code this}
             */
            public Builder withDevice(final java.lang.String value) {
                this._device = java.util.Objects.requireNonNull(value, "device is required");
                return this;
            }
            /**
             * Sets the value of Device
             * @param value ``CfnInstance.VolumeProperty.Device``
             * @return {@code this}
             */
            public Builder withDevice(final software.amazon.awscdk.Token value) {
                this._device = java.util.Objects.requireNonNull(value, "device is required");
                return this;
            }
            /**
             * Sets the value of VolumeId
             * @param value ``CfnInstance.VolumeProperty.VolumeId``
             * @return {@code this}
             */
            public Builder withVolumeId(final java.lang.String value) {
                this._volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
                return this;
            }
            /**
             * Sets the value of VolumeId
             * @param value ``CfnInstance.VolumeProperty.VolumeId``
             * @return {@code this}
             */
            public Builder withVolumeId(final software.amazon.awscdk.Token value) {
                this._volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VolumeProperty build() {
                return new VolumeProperty() {
                    private java.lang.Object $device = java.util.Objects.requireNonNull(_device, "device is required");
                    private java.lang.Object $volumeId = java.util.Objects.requireNonNull(_volumeId, "volumeId is required");

                    @Override
                    public java.lang.Object getDevice() {
                        return this.$device;
                    }

                    @Override
                    public void setDevice(final java.lang.String value) {
                        this.$device = java.util.Objects.requireNonNull(value, "device is required");
                    }

                    @Override
                    public void setDevice(final software.amazon.awscdk.Token value) {
                        this.$device = java.util.Objects.requireNonNull(value, "device is required");
                    }

                    @Override
                    public java.lang.Object getVolumeId() {
                        return this.$volumeId;
                    }

                    @Override
                    public void setVolumeId(final java.lang.String value) {
                        this.$volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
                    }

                    @Override
                    public void setVolumeId(final software.amazon.awscdk.Token value) {
                        this.$volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.VolumeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnInstance.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            @Override
            public java.lang.Object getDevice() {
                return this.jsiiGet("device", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            @Override
            public void setDevice(final java.lang.String value) {
                this.jsiiSet("device", java.util.Objects.requireNonNull(value, "device is required"));
            }

            /**
             * ``CfnInstance.VolumeProperty.Device``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            @Override
            public void setDevice(final software.amazon.awscdk.Token value) {
                this.jsiiSet("device", java.util.Objects.requireNonNull(value, "device is required"));
            }

            /**
             * ``CfnInstance.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            @Override
            public java.lang.Object getVolumeId() {
                return this.jsiiGet("volumeId", java.lang.Object.class);
            }

            /**
             * ``CfnInstance.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            @Override
            public void setVolumeId(final java.lang.String value) {
                this.jsiiSet("volumeId", java.util.Objects.requireNonNull(value, "volumeId is required"));
            }

            /**
             * ``CfnInstance.VolumeProperty.VolumeId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            @Override
            public void setVolumeId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeId", java.util.Objects.requireNonNull(value, "volumeId is required"));
            }
        }
    }
}
