package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use
 * 
 * We have both symbolic and concrete enums for every type.
 * 
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:30:41.772Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation
     */
    Standard3,
    /**
     * Standard instances, 4th generation
     */
    Standard4,
    /**
     * Standard instances, 5th generation
     */
    Standard5,
    /**
     * Memory optimized instances, 3rd generation
     */
    Memory3,
    /**
     * Memory optimized instances, 3rd generation
     */
    Memory4,
    /**
     * Compute optimized instances, 3rd generation
     */
    Compute3,
    /**
     * Compute optimized instances, 4th generation
     */
    Compute4,
    /**
     * Compute optimized instances, 5th generation
     */
    Compute5,
    /**
     * Storage-optimized instances, 2nd generation
     */
    Storage2,
    /**
     * Storage/compute balanced instances, 1st generation
     */
    StorageCompute1,
    /**
     * I/O-optimized instances, 3rd generation
     */
    Io3,
    /**
     * Burstable instances, 2nd generation
     */
    Burstable2,
    /**
     * Burstable instances, 3rd generation
     */
    Burstable3,
    /**
     * Memory-intensive instances, 1st generation
     */
    MemoryIntensive1,
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    MemoryIntensive1Extended,
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    Fpga1,
    /**
     * Graphics-optimized instances, 3rd generation
     */
    Graphics3,
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    Parallel2,
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    Parallel3,
}
