package software.amazon.awscdk.services.ec2;

/**
 * VpcNetworkProps allows you to specify configuration options for a VPC
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:30:41.779Z")
public interface VpcNetworkProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
     * The range will be split evenly into two subnets per Availability Zone (one public, one private).
     */
    java.lang.String getCidr();
    /**
     * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
     * The range will be split evenly into two subnets per Availability Zone (one public, one private).
     */
    void setCidr(final java.lang.String value);
    /**
     * The default tenancy of instances launched into the VPC.
     * By default, instances will be launched with default (shared) tenancy.
     * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
     * to a single AWS customer, unless specifically specified at instance launch time.
     * Please note, not all instance types are usable with Dedicated tenancy.
     */
    software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy();
    /**
     * The default tenancy of instances launched into the VPC.
     * By default, instances will be launched with default (shared) tenancy.
     * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
     * to a single AWS customer, unless specifically specified at instance launch time.
     * Please note, not all instance types are usable with Dedicated tenancy.
     */
    void setDefaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value);
    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     */
    java.lang.Boolean getEnableDnsHostnames();
    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     */
    void setEnableDnsHostnames(final java.lang.Boolean value);
    /**
     * Indicates whether the DNS resolution is supported for the VPC. If this attribute
     * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
     * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
     * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
     * at the base of the VPC IPv4 network range plus two will succeed.
     */
    java.lang.Boolean getEnableDnsSupport();
    /**
     * Indicates whether the DNS resolution is supported for the VPC. If this attribute
     * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
     * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
     * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
     * at the base of the VPC IPv4 network range plus two will succeed.
     */
    void setEnableDnsSupport(final java.lang.Boolean value);
    /**
     * Define the maximum number of AZs to use in this region
     * 
     * If the region has more AZs than you want to use (for example, because of EIP limits),
     * pick a lower number here. The AZs will be sorted and picked from the start of the list.
     * @default All AZs in the region
     */
    java.lang.Number getMaxAZs();
    /**
     * Define the maximum number of AZs to use in this region
     * 
     * If the region has more AZs than you want to use (for example, because of EIP limits),
     * pick a lower number here. The AZs will be sorted and picked from the start of the list.
     * @default All AZs in the region
     */
    void setMaxAZs(final java.lang.Number value);
    /**
     * Configures the subnets which will have NAT Gateways
     * 
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     * @default All public subnets
     */
    software.amazon.awscdk.services.ec2.VpcPlacementStrategy getNatGatewayPlacement();
    /**
     * Configures the subnets which will have NAT Gateways
     * 
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     * @default All public subnets
     */
    void setNatGatewayPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value);
    /**
     * The number of NAT Gateways to create.
     * 
     * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
     * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
     * @default maxAZs
     */
    java.lang.Number getNatGateways();
    /**
     * The number of NAT Gateways to create.
     * 
     * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
     * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
     * @default maxAZs
     */
    void setNatGateways(final java.lang.Number value);
    /**
     * Configure the subnets to build for each AZ
     * 
     * The subnets are constructed in the context of the VPC so you only need
     * specify the configuration. The VPC details (VPC ID, specific CIDR,
     * specific AZ will be calculated during creation)
     * 
     * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * subnetConfiguration: [
     *     {
     *       cidrMask: 24,
     *       name: 'ingress',
     *       subnetType: SubnetType.Public,
     *     },
     *     {
     *       cidrMask: 24,
     *       name: 'application',
     *       subnetType: SubnetType.Private,
     *     },
     *     {
     *       cidrMask: 28,
     *       name: 'rds',
     *       subnetType: SubnetType.Isolated,
     *     }
     * ]
     * 
     * `cidrMask` is optional and if not provided the IP space in the VPC will be
     * evenly divided between the requested subnets.
     * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
     */
    java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration();
    /**
     * Configure the subnets to build for each AZ
     * 
     * The subnets are constructed in the context of the VPC so you only need
     * specify the configuration. The VPC details (VPC ID, specific CIDR,
     * specific AZ will be calculated during creation)
     * 
     * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * subnetConfiguration: [
     *     {
     *       cidrMask: 24,
     *       name: 'ingress',
     *       subnetType: SubnetType.Public,
     *     },
     *     {
     *       cidrMask: 24,
     *       name: 'application',
     *       subnetType: SubnetType.Private,
     *     },
     *     {
     *       cidrMask: 28,
     *       name: 'rds',
     *       subnetType: SubnetType.Isolated,
     *     }
     * ]
     * 
     * `cidrMask` is optional and if not provided the IP space in the VPC will be
     * evenly divided between the requested subnets.
     * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
     */
    void setSubnetConfiguration(final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value);
    /**
     * The AWS resource tags to associate with the VPC.
     */
    java.util.Map<java.lang.String, java.lang.String> getTags();
    /**
     * The AWS resource tags to associate with the VPC.
     */
    void setTags(final java.util.Map<java.lang.String, java.lang.String> value);

    /**
     * @return a {@link Builder} of {@link VpcNetworkProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcNetworkProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _cidr;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.DefaultInstanceTenancy _defaultInstanceTenancy;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableDnsHostnames;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableDnsSupport;
        @javax.annotation.Nullable
        private java.lang.Number _maxAZs;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.VpcPlacementStrategy _natGatewayPlacement;
        @javax.annotation.Nullable
        private java.lang.Number _natGateways;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> _subnetConfiguration;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _tags;

        /**
         * Sets the value of Cidr
         * @param value The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
The range will be split evenly into two subnets per Availability Zone (one public, one private).
         * @return {@code this}
         */
        public Builder withCidr(@javax.annotation.Nullable final java.lang.String value) {
            this._cidr = value;
            return this;
        }
        /**
         * Sets the value of DefaultInstanceTenancy
         * @param value The default tenancy of instances launched into the VPC.
By default, instances will be launched with default (shared) tenancy.
By setting this to dedicated tenancy, instances will be launched on hardware dedicated
to a single AWS customer, unless specifically specified at instance launch time.
Please note, not all instance types are usable with Dedicated tenancy.
         * @return {@code this}
         */
        public Builder withDefaultInstanceTenancy(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this._defaultInstanceTenancy = value;
            return this;
        }
        /**
         * Sets the value of EnableDnsHostnames
         * @param value Indicates whether the instances launched in the VPC get public DNS hostnames.
If this attribute is true, instances in the VPC get public DNS hostnames,
but only if the enableDnsSupport attribute is also set to true.
         * @return {@code this}
         */
        public Builder withEnableDnsHostnames(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableDnsHostnames = value;
            return this;
        }
        /**
         * Sets the value of EnableDnsSupport
         * @param value Indicates whether the DNS resolution is supported for the VPC. If this attribute
is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
to IP addresses is not enabled. If this attribute is true, queries to the Amazon
provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
at the base of the VPC IPv4 network range plus two will succeed.
         * @return {@code this}
         */
        public Builder withEnableDnsSupport(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableDnsSupport = value;
            return this;
        }
        /**
         * Sets the value of MaxAZs
         * @param value Define the maximum number of AZs to use in this region

If the region has more AZs than you want to use (for example, because of EIP limits),
pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @return {@code this}
         */
        public Builder withMaxAZs(@javax.annotation.Nullable final java.lang.Number value) {
            this._maxAZs = value;
            return this;
        }
        /**
         * Sets the value of NatGatewayPlacement
         * @param value Configures the subnets which will have NAT Gateways

You can pick a specific group of subnets by specifying the group name;
the picked subnets must be public subnets.
         * @return {@code this}
         */
        public Builder withNatGatewayPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this._natGatewayPlacement = value;
            return this;
        }
        /**
         * Sets the value of NatGateways
         * @param value The number of NAT Gateways to create.

For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
         * @return {@code this}
         */
        public Builder withNatGateways(@javax.annotation.Nullable final java.lang.Number value) {
            this._natGateways = value;
            return this;
        }
        /**
         * Sets the value of SubnetConfiguration
         * @param value Configure the subnets to build for each AZ

The subnets are constructed in the context of the VPC so you only need
specify the configuration. The VPC details (VPC ID, specific CIDR,
specific AZ will be calculated during creation)

For example if you want 1 public subnet, 1 private subnet, and 1 isolated
subnet in each AZ provide the following:
subnetConfiguration: [
    {
      cidrMask: 24,
      name: 'ingress',
      subnetType: SubnetType.Public,
    },
    {
      cidrMask: 24,
      name: 'application',
      subnetType: SubnetType.Private,
    },
    {
      cidrMask: 28,
      name: 'rds',
      subnetType: SubnetType.Isolated,
    }
]

`cidrMask` is optional and if not provided the IP space in the VPC will be
evenly divided between the requested subnets.
         * @return {@code this}
         */
        public Builder withSubnetConfiguration(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this._subnetConfiguration = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value The AWS resource tags to associate with the VPC.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcNetworkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcNetworkProps build() {
            return new VpcNetworkProps() {
                @javax.annotation.Nullable
                private java.lang.String $cidr = _cidr;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.DefaultInstanceTenancy $defaultInstanceTenancy = _defaultInstanceTenancy;
                @javax.annotation.Nullable
                private java.lang.Boolean $enableDnsHostnames = _enableDnsHostnames;
                @javax.annotation.Nullable
                private java.lang.Boolean $enableDnsSupport = _enableDnsSupport;
                @javax.annotation.Nullable
                private java.lang.Number $maxAZs = _maxAZs;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.VpcPlacementStrategy $natGatewayPlacement = _natGatewayPlacement;
                @javax.annotation.Nullable
                private java.lang.Number $natGateways = _natGateways;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> $subnetConfiguration = _subnetConfiguration;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $tags = _tags;

                @Override
                public java.lang.String getCidr() {
                    return this.$cidr;
                }

                @Override
                public void setCidr(@javax.annotation.Nullable final java.lang.String value) {
                    this.$cidr = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
                    return this.$defaultInstanceTenancy;
                }

                @Override
                public void setDefaultInstanceTenancy(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
                    this.$defaultInstanceTenancy = value;
                }

                @Override
                public java.lang.Boolean getEnableDnsHostnames() {
                    return this.$enableDnsHostnames;
                }

                @Override
                public void setEnableDnsHostnames(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$enableDnsHostnames = value;
                }

                @Override
                public java.lang.Boolean getEnableDnsSupport() {
                    return this.$enableDnsSupport;
                }

                @Override
                public void setEnableDnsSupport(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$enableDnsSupport = value;
                }

                @Override
                public java.lang.Number getMaxAZs() {
                    return this.$maxAZs;
                }

                @Override
                public void setMaxAZs(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$maxAZs = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getNatGatewayPlacement() {
                    return this.$natGatewayPlacement;
                }

                @Override
                public void setNatGatewayPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
                    this.$natGatewayPlacement = value;
                }

                @Override
                public java.lang.Number getNatGateways() {
                    return this.$natGateways;
                }

                @Override
                public void setNatGateways(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$natGateways = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
                    return this.$subnetConfiguration;
                }

                @Override
                public void setSubnetConfiguration(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
                    this.$subnetConfiguration = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getTags() {
                    return this.$tags;
                }

                @Override
                public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$tags = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcNetworkProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
         * The range will be split evenly into two subnets per Availability Zone (one public, one private).
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCidr() {
            return this.jsiiGet("cidr", java.lang.String.class);
        }

        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16.
         * The range will be split evenly into two subnets per Availability Zone (one public, one private).
         */
        @Override
        public void setCidr(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cidr", value);
        }

        /**
         * The default tenancy of instances launched into the VPC.
         * By default, instances will be launched with default (shared) tenancy.
         * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
         * to a single AWS customer, unless specifically specified at instance launch time.
         * Please note, not all instance types are usable with Dedicated tenancy.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this.jsiiGet("defaultInstanceTenancy", software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class);
        }

        /**
         * The default tenancy of instances launched into the VPC.
         * By default, instances will be launched with default (shared) tenancy.
         * By setting this to dedicated tenancy, instances will be launched on hardware dedicated
         * to a single AWS customer, unless specifically specified at instance launch time.
         * Please note, not all instance types are usable with Dedicated tenancy.
         */
        @Override
        public void setDefaultInstanceTenancy(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this.jsiiSet("defaultInstanceTenancy", value);
        }

        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames.
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsHostnames() {
            return this.jsiiGet("enableDnsHostnames", java.lang.Boolean.class);
        }

        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames.
         * If this attribute is true, instances in the VPC get public DNS hostnames,
         * but only if the enableDnsSupport attribute is also set to true.
         */
        @Override
        public void setEnableDnsHostnames(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enableDnsHostnames", value);
        }

        /**
         * Indicates whether the DNS resolution is supported for the VPC. If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsSupport() {
            return this.jsiiGet("enableDnsSupport", java.lang.Boolean.class);
        }

        /**
         * Indicates whether the DNS resolution is supported for the VPC. If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         */
        @Override
        public void setEnableDnsSupport(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("enableDnsSupport", value);
        }

        /**
         * Define the maximum number of AZs to use in this region
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @default All AZs in the region
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMaxAZs() {
            return this.jsiiGet("maxAZs", java.lang.Number.class);
        }

        /**
         * Define the maximum number of AZs to use in this region
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * @default All AZs in the region
         */
        @Override
        public void setMaxAZs(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("maxAZs", value);
        }

        /**
         * Configures the subnets which will have NAT Gateways
         * 
         * You can pick a specific group of subnets by specifying the group name;
         * the picked subnets must be public subnets.
         * @default All public subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getNatGatewayPlacement() {
            return this.jsiiGet("natGatewayPlacement", software.amazon.awscdk.services.ec2.VpcPlacementStrategy.class);
        }

        /**
         * Configures the subnets which will have NAT Gateways
         * 
         * You can pick a specific group of subnets by specifying the group name;
         * the picked subnets must be public subnets.
         * @default All public subnets
         */
        @Override
        public void setNatGatewayPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this.jsiiSet("natGatewayPlacement", value);
        }

        /**
         * The number of NAT Gateways to create.
         * 
         * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
         * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
         * @default maxAZs
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getNatGateways() {
            return this.jsiiGet("natGateways", java.lang.Number.class);
        }

        /**
         * The number of NAT Gateways to create.
         * 
         * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
         * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
         * @default maxAZs
         */
        @Override
        public void setNatGateways(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("natGateways", value);
        }

        /**
         * Configure the subnets to build for each AZ
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *     {
         *       cidrMask: 24,
         *       name: 'ingress',
         *       subnetType: SubnetType.Public,
         *     },
         *     {
         *       cidrMask: 24,
         *       name: 'application',
         *       subnetType: SubnetType.Private,
         *     },
         *     {
         *       cidrMask: 28,
         *       name: 'rds',
         *       subnetType: SubnetType.Isolated,
         *     }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this.jsiiGet("subnetConfiguration", java.util.List.class);
        }

        /**
         * Configure the subnets to build for each AZ
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *     {
         *       cidrMask: 24,
         *       name: 'ingress',
         *       subnetType: SubnetType.Public,
         *     },
         *     {
         *       cidrMask: 24,
         *       name: 'application',
         *       subnetType: SubnetType.Private,
         *     },
         *     {
         *       cidrMask: 28,
         *       name: 'rds',
         *       subnetType: SubnetType.Isolated,
         *     }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * @default the VPC CIDR will be evenly divided between 1 public and 1 private subnet per AZ
         */
        @Override
        public void setSubnetConfiguration(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this.jsiiSet("subnetConfiguration", value);
        }

        /**
         * The AWS resource tags to associate with the VPC.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.jsiiGet("tags", java.util.Map.class);
        }

        /**
         * The AWS resource tags to associate with the VPC.
         */
        @Override
        public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("tags", value);
        }
    }
}
