package software.amazon.awscdk.services.ec2;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:48:43.432Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInterface")
public class CfnNetworkInterface extends software.amazon.awscdk.Resource {
    protected CfnNetworkInterface(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnNetworkInterface.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::NetworkInterface``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnNetworkInterface(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getNetworkInterfaceName() {
        return this.jsiiGet("networkInterfaceName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute PrimaryPrivateIpAddress
     */
    public java.lang.String getNetworkInterfacePrimaryPrivateIpAddress() {
        return this.jsiiGet("networkInterfacePrimaryPrivateIpAddress", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute SecondaryPrivateIpAddresses
     */
    public java.util.List<java.lang.String> getNetworkInterfaceSecondaryPrivateIpAddresses() {
        return this.jsiiGet("networkInterfaceSecondaryPrivateIpAddresses", java.util.List.class);
    }

    public software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        java.lang.String getIpv6Address();
        /**
         * ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        final class Builder {
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private java.lang.String $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(final java.lang.String value) {
                        this.$ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkInterface.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            @Override
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }

            /**
             * ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
             */
            @Override
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);
        /**
         * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        java.lang.String getPrivateIpAddress();
        /**
         * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _primary;
            private java.lang.String _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(final java.lang.Boolean value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(final software.amazon.awscdk.Token value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private java.lang.Object $primary = java.util.Objects.requireNonNull(_primary, "primary is required");
                    private java.lang.String $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(final java.lang.Boolean value) {
                        this.$primary = java.util.Objects.requireNonNull(value, "primary is required");
                    }

                    @Override
                    public void setPrimary(final software.amazon.awscdk.Token value) {
                        this.$primary = java.util.Objects.requireNonNull(value, "primary is required");
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(final java.lang.String value) {
                        this.$privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public void setPrimary(final java.lang.Boolean value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }

            /**
             * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            public void setPrimary(final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", java.util.Objects.requireNonNull(value, "primary is required"));
            }

            /**
             * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }
        }
    }
}
