package software.amazon.awscdk.services.ec2;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:48:43.459Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet extends software.amazon.awscdk.Resource {
    protected CfnSpotFleet(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSpotFleet.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::EC2::SpotFleet``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnSpotFleet(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnSpotFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.ec2.CfnSpotFleetProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnSpotFleetProps.class);
    }

    public java.lang.String getSpotFleetName() {
        return this.jsiiGet("spotFleetName", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        java.lang.String getDeviceName();
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        void setDeviceName(final java.lang.String value);
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        void setEbs(final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value);
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        java.lang.String getNoDevice();
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        void setNoDevice(final java.lang.String value);
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        java.lang.String getVirtualName();
        /**
         * ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        void setVirtualName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        final class Builder {
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.String _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``
             * @return {@code this}
             */
            public Builder withDeviceName(final java.lang.String value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    private java.lang.String $deviceName = java.util.Objects.requireNonNull(_deviceName, "deviceName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private java.lang.String $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(final java.lang.String value) {
                        this.$deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public java.lang.String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$virtualName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            @Override
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            @Override
            public void setDeviceName(final java.lang.String value) {
                this.jsiiSet("deviceName", java.util.Objects.requireNonNull(value, "deviceName is required"));
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @Override
            public void setEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value) {
                this.jsiiSet("ebs", value);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            @Override
            public void setNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("noDevice", value);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            @Override
            public void setVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("virtualName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    public static interface ClassicLoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        java.lang.String getName();
        /**
         * ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        void setName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancerProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancerProperty}
         */
        final class Builder {
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ClassicLoadBalancerProperty build() {
                return new ClassicLoadBalancerProperty() {
                    private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(final java.lang.String value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
             */
            @Override
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
             */
            @Override
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    public static interface ClassicLoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        java.lang.Object getClassicLoadBalancers();
        /**
         * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        void setClassicLoadBalancers(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        void setClassicLoadBalancers(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancersConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancersConfigProperty}
         */
        final class Builder {
            private java.lang.Object _classicLoadBalancers;

            /**
             * Sets the value of ClassicLoadBalancers
             * @param value ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
             * @return {@code this}
             */
            public Builder withClassicLoadBalancers(final software.amazon.awscdk.Token value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancers
             * @param value ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
             * @return {@code this}
             */
            public Builder withClassicLoadBalancers(final java.util.List<java.lang.Object> value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ClassicLoadBalancersConfigProperty build() {
                return new ClassicLoadBalancersConfigProperty() {
                    private java.lang.Object $classicLoadBalancers = java.util.Objects.requireNonNull(_classicLoadBalancers, "classicLoadBalancers is required");

                    @Override
                    public java.lang.Object getClassicLoadBalancers() {
                        return this.$classicLoadBalancers;
                    }

                    @Override
                    public void setClassicLoadBalancers(final software.amazon.awscdk.Token value) {
                        this.$classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                    }

                    @Override
                    public void setClassicLoadBalancers(final java.util.List<java.lang.Object> value) {
                        this.$classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
             */
            @Override
            public java.lang.Object getClassicLoadBalancers() {
                return this.jsiiGet("classicLoadBalancers", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
             */
            @Override
            public void setClassicLoadBalancers(final software.amazon.awscdk.Token value) {
                this.jsiiSet("classicLoadBalancers", java.util.Objects.requireNonNull(value, "classicLoadBalancers is required"));
            }

            /**
             * ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
             */
            @Override
            public void setClassicLoadBalancers(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("classicLoadBalancers", java.util.Objects.requireNonNull(value, "classicLoadBalancers is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        void setEncrypted(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        void setEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        java.lang.Object getIops();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        void setIops(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        void setIops(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        java.lang.String getSnapshotId();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        void setSnapshotId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        void setVolumeSize(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        void setVolumeSize(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        java.lang.String getVolumeType();
        /**
         * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        void setVolumeType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsBlockDeviceProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Object _iops;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Object _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EbsBlockDeviceProperty build() {
                return new EbsBlockDeviceProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private java.lang.Object $iops = _iops;
                    @javax.annotation.Nullable
                    private java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private java.lang.Object $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public java.lang.Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$iops = value;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public java.lang.Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$volumeType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @Override
            public void setEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encrypted", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @Override
            public void setIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iops", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            @Override
            public void setSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("snapshotId", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @Override
            public void setVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("volumeSize", value);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            @Override
            public void setVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("volumeType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    public static interface FleetLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        java.lang.String getVersion();
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        java.lang.String getLaunchTemplateId();
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        void setLaunchTemplateId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        java.lang.String getLaunchTemplateName();
        /**
         * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        void setLaunchTemplateName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _version;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateName;

            /**
             * Sets the value of Version
             * @param value ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(final java.lang.String value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @return {@code this}
             */
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @return {@code this}
             */
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FleetLaunchTemplateSpecificationProperty build() {
                return new FleetLaunchTemplateSpecificationProperty() {
                    private java.lang.String $version = java.util.Objects.requireNonNull(_version, "version is required");
                    @javax.annotation.Nullable
                    private java.lang.String $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private java.lang.String $launchTemplateName = _launchTemplateName;

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(final java.lang.String value) {
                        this.$version = java.util.Objects.requireNonNull(value, "version is required");
                    }

                    @Override
                    public java.lang.String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public void setLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    @Override
                    public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$launchTemplateName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
             */
            @Override
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
             */
            @Override
            public void setVersion(final java.lang.String value) {
                this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
             */
            @Override
            public void setLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateId", value);
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
             */
            @Override
            public void setLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("launchTemplateName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.GroupIdentifierProperty.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        java.lang.String getGroupId();
        /**
         * ``CfnSpotFleet.GroupIdentifierProperty.GroupId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        void setGroupId(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link GroupIdentifierProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GroupIdentifierProperty}
         */
        final class Builder {
            private java.lang.String _groupId;

            /**
             * Sets the value of GroupId
             * @param value ``CfnSpotFleet.GroupIdentifierProperty.GroupId``
             * @return {@code this}
             */
            public Builder withGroupId(final java.lang.String value) {
                this._groupId = java.util.Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GroupIdentifierProperty build() {
                return new GroupIdentifierProperty() {
                    private java.lang.String $groupId = java.util.Objects.requireNonNull(_groupId, "groupId is required");

                    @Override
                    public java.lang.String getGroupId() {
                        return this.$groupId;
                    }

                    @Override
                    public void setGroupId(final java.lang.String value) {
                        this.$groupId = java.util.Objects.requireNonNull(value, "groupId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.GroupIdentifierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            @Override
            public java.lang.String getGroupId() {
                return this.jsiiGet("groupId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.GroupIdentifierProperty.GroupId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            @Override
            public void setGroupId(final java.lang.String value) {
                this.jsiiSet("groupId", java.util.Objects.requireNonNull(value, "groupId is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        java.lang.String getArn();
        /**
         * ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        void setArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``
             * @return {@code this}
             */
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IamInstanceProfileSpecificationProperty build() {
                return new IamInstanceProfileSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $arn = _arn;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$arn = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            @Override
            public void setArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("arn", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        java.lang.String getIpv6Address();
        /**
         * ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        void setIpv6Address(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        final class Builder {
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``
             * @return {@code this}
             */
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private java.lang.String $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(final java.lang.String value) {
                        this.$ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            @Override
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            @Override
            public void setIpv6Address(final java.lang.String value) {
                this.jsiiSet("ipv6Address", java.util.Objects.requireNonNull(value, "ipv6Address is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        void setAssociatePublicIpAddress(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        void setDeleteOnTermination(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        void setDeleteOnTermination(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        java.lang.String getDescription();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        void setDeviceIndex(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        void setDeviceIndex(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        java.lang.Object getGroups();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        void setGroups(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        void setGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        void setIpv6AddressCount(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        void setIpv6AddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        void setIpv6Addresses(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        void setIpv6Addresses(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        java.lang.String getNetworkInterfaceId();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        void setNetworkInterfaceId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        void setPrivateIpAddresses(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        void setPrivateIpAddresses(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        void setSecondaryPrivateIpAddressCount(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        void setSubnetId(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _deviceIndex;
            @javax.annotation.Nullable
            private java.lang.Object _groups;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Object _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceNetworkInterfaceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new InstanceNetworkInterfaceSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private java.lang.Object $groups = _groups;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private java.lang.Object $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public java.lang.Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public java.lang.Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public java.lang.Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$subnetId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @Override
            public void setAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("associatePublicIpAddress", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @Override
            public void setDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteOnTermination", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @Override
            public void setDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("deviceIndex", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @Override
            public void setDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deviceIndex", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGroups() {
                return this.jsiiGet("groups", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @Override
            public void setGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groups", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @Override
            public void setGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("groups", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @Override
            public void setIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6AddressCount", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @Override
            public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ipv6Addresses", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            @Override
            public void setNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("networkInterfaceId", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @Override
            public void setPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("privateIpAddresses", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @Override
            public void setSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("secondaryPrivateIpAddressCount", value);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    public static interface LaunchTemplateConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        java.lang.Object getLaunchTemplateSpecification();
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        void setLaunchTemplateSpecification(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        void setLaunchTemplateSpecification(final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value);
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        java.lang.Object getOverrides();
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        void setOverrides(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        void setOverrides(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _overrides;

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._overrides = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._overrides = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateConfigProperty build() {
                return new LaunchTemplateConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $launchTemplateSpecification = _launchTemplateSpecification;
                    @javax.annotation.Nullable
                    private java.lang.Object $overrides = _overrides;

                    @Override
                    public java.lang.Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public java.lang.Object getOverrides() {
                        return this.$overrides;
                    }

                    @Override
                    public void setOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$overrides = value;
                    }

                    @Override
                    public void setOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$overrides = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
             */
            @Override
            public void setLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateSpecification", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
             */
            @Override
            public void setLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value) {
                this.jsiiSet("launchTemplateSpecification", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOverrides() {
                return this.jsiiGet("overrides", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
             */
            @Override
            public void setOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("overrides", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
             */
            @Override
            public void setOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("overrides", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    public static interface LaunchTemplateOverridesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        void setSpotPrice(final java.lang.String value);
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        void setWeightedCapacity(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        void setWeightedCapacity(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link LaunchTemplateOverridesProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateOverridesProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _weightedCapacity;

            /**
             * Sets the value of AvailabilityZone
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateOverridesProperty build() {
                return new LaunchTemplateOverridesProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private java.lang.Object $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public java.lang.Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$weightedCapacity = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateOverridesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
             */
            @Override
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
             */
            @Override
            public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceType", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
             */
            @Override
            public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotPrice", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
             */
            @Override
            public void setWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("weightedCapacity", value);
            }

            /**
             * ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
             */
            @Override
            public void setWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("weightedCapacity", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    public static interface LoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        java.lang.Object getClassicLoadBalancersConfig();
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        void setClassicLoadBalancersConfig(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        void setClassicLoadBalancersConfig(final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value);
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        java.lang.Object getTargetGroupsConfig();
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        void setTargetGroupsConfig(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        void setTargetGroupsConfig(final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value);

        /**
         * @return a {@link Builder} of {@link LoadBalancersConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancersConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _classicLoadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupsConfig;

            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
             * @return {@code this}
             */
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
             * @return {@code this}
             */
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
             * @return {@code this}
             */
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._targetGroupsConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
             * @return {@code this}
             */
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value) {
                this._targetGroupsConfig = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoadBalancersConfigProperty build() {
                return new LoadBalancersConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $classicLoadBalancersConfig = _classicLoadBalancersConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $targetGroupsConfig = _targetGroupsConfig;

                    @Override
                    public java.lang.Object getClassicLoadBalancersConfig() {
                        return this.$classicLoadBalancersConfig;
                    }

                    @Override
                    public void setClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$classicLoadBalancersConfig = value;
                    }

                    @Override
                    public void setClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value) {
                        this.$classicLoadBalancersConfig = value;
                    }

                    @Override
                    public java.lang.Object getTargetGroupsConfig() {
                        return this.$targetGroupsConfig;
                    }

                    @Override
                    public void setTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$targetGroupsConfig = value;
                    }

                    @Override
                    public void setTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value) {
                        this.$targetGroupsConfig = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getClassicLoadBalancersConfig() {
                return this.jsiiGet("classicLoadBalancersConfig", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
             */
            @Override
            public void setClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("classicLoadBalancersConfig", value);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
             */
            @Override
            public void setClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value) {
                this.jsiiSet("classicLoadBalancersConfig", value);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupsConfig() {
                return this.jsiiGet("targetGroupsConfig", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
             */
            @Override
            public void setTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupsConfig", value);
            }

            /**
             * ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
             */
            @Override
            public void setTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value) {
                this.jsiiSet("targetGroupsConfig", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        java.lang.String getPrivateIpAddress();
        /**
         * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        void setPrivateIpAddress(final java.lang.String value);
        /**
         * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        java.lang.Object getPrimary();
        /**
         * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        void setPrimary(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        void setPrimary(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _primary;

            /**
             * Sets the value of PrivateIpAddress
             * @param value ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._primary = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private java.lang.String $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $primary = _primary;

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(final java.lang.String value) {
                        this.$privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                    }

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$primary = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            @Override
            public void setPrivateIpAddress(final java.lang.String value) {
                this.jsiiSet("privateIpAddress", java.util.Objects.requireNonNull(value, "privateIpAddress is required"));
            }

            /**
             * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @Override
            public void setPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("primary", value);
            }

            /**
             * ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @Override
            public void setPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("primary", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        java.lang.String getImageId();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        void setImageId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        void setInstanceType(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        void setBlockDeviceMappings(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        void setBlockDeviceMappings(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        void setEbsOptimized(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        void setEbsOptimized(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        void setIamInstanceProfile(final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        java.lang.String getKernelId();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        void setKernelId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        java.lang.String getKeyName();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        void setKeyName(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        void setMonitoring(final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        void setNetworkInterfaces(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        void setNetworkInterfaces(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        java.lang.Object getPlacement();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        void setPlacement(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        void setPlacement(final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        java.lang.String getRamdiskId();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        void setRamdiskId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        java.lang.Object getSecurityGroups();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        void setSecurityGroups(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        void setSecurityGroups(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        void setSpotPrice(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        void setSubnetId(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        void setTagSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        void setTagSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        java.lang.String getUserData();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        void setUserData(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        void setWeightedCapacity(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        void setWeightedCapacity(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SpotFleetLaunchSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetLaunchSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _imageId;
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.String _kernelId;
            @javax.annotation.Nullable
            private java.lang.String _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.String _ramdiskId;
            @javax.annotation.Nullable
            private java.lang.Object _securityGroups;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.String _userData;
            @javax.annotation.Nullable
            private java.lang.Object _weightedCapacity;

            /**
             * Sets the value of ImageId
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``
             * @return {@code this}
             */
            public Builder withImageId(final java.lang.String value) {
                this._imageId = java.util.Objects.requireNonNull(value, "imageId is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @return {@code this}
             */
            public Builder withInstanceType(final java.lang.String value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``
             * @return {@code this}
             */
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``
             * @return {@code this}
             */
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamdiskId
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @return {@code this}
             */
            public Builder withRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramdiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``
             * @return {@code this}
             */
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetLaunchSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetLaunchSpecificationProperty build() {
                return new SpotFleetLaunchSpecificationProperty() {
                    private java.lang.String $imageId = java.util.Objects.requireNonNull(_imageId, "imageId is required");
                    private java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private java.lang.String $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private java.lang.String $keyName = _keyName;
                    @javax.annotation.Nullable
                    private java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private java.lang.String $ramdiskId = _ramdiskId;
                    @javax.annotation.Nullable
                    private java.lang.Object $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private java.lang.String $userData = _userData;
                    @javax.annotation.Nullable
                    private java.lang.Object $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(final java.lang.String value) {
                        this.$imageId = java.util.Objects.requireNonNull(value, "imageId is required");
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(final java.lang.String value) {
                        this.$instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                    }

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public java.lang.String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public java.lang.String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public java.lang.String getRamdiskId() {
                        return this.$ramdiskId;
                    }

                    @Override
                    public void setRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$ramdiskId = value;
                    }

                    @Override
                    public java.lang.Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public java.lang.String getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                        this.$userData = value;
                    }

                    @Override
                    public java.lang.Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$weightedCapacity = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            @Override
            public java.lang.String getImageId() {
                return this.jsiiGet("imageId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            @Override
            public void setImageId(final java.lang.String value) {
                this.jsiiSet("imageId", java.util.Objects.requireNonNull(value, "imageId is required"));
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            @Override
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            @Override
            public void setInstanceType(final java.lang.String value) {
                this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @Override
            public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("blockDeviceMappings", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @Override
            public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("blockDeviceMappings", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @Override
            public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ebsOptimized", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @Override
            public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ebsOptimized", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @Override
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("iamInstanceProfile", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @Override
            public void setIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value) {
                this.jsiiSet("iamInstanceProfile", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKernelId() {
                return this.jsiiGet("kernelId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            @Override
            public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("kernelId", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKeyName() {
                return this.jsiiGet("keyName", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            @Override
            public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("keyName", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @Override
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("monitoring", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @Override
            public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value) {
                this.jsiiSet("monitoring", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @Override
            public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("networkInterfaces", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @Override
            public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("networkInterfaces", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @Override
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("placement", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @Override
            public void setPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value) {
                this.jsiiSet("placement", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRamdiskId() {
                return this.jsiiGet("ramdiskId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            @Override
            public void setRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("ramdiskId", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @Override
            public void setSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroups", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @Override
            public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroups", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            @Override
            public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotPrice", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            @Override
            public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("subnetId", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @Override
            public void setTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tagSpecifications", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @Override
            public void setTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tagSpecifications", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getUserData() {
                return this.jsiiGet("userData", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            @Override
            public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("userData", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @Override
            public void setWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("weightedCapacity", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @Override
            public void setWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("weightedCapacity", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SpotFleetMonitoringProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetMonitoringProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetMonitoringProperty build() {
                return new SpotFleetMonitoringProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        java.lang.String getIamFleetRole();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        void setIamFleetRole(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        java.lang.Object getTargetCapacity();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        void setTargetCapacity(final java.lang.Number value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        void setTargetCapacity(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        java.lang.String getAllocationStrategy();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        void setAllocationStrategy(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        java.lang.String getExcessCapacityTerminationPolicy();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        void setExcessCapacityTerminationPolicy(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        void setInstanceInterruptionBehavior(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        java.lang.Object getLaunchSpecifications();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        void setLaunchSpecifications(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        void setLaunchSpecifications(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        java.lang.Object getLaunchTemplateConfigs();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        void setLaunchTemplateConfigs(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        void setLaunchTemplateConfigs(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        java.lang.Object getLoadBalancersConfig();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        void setLoadBalancersConfig(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        void setLoadBalancersConfig(final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        java.lang.Object getReplaceUnhealthyInstances();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        void setReplaceUnhealthyInstances(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        void setReplaceUnhealthyInstances(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        void setSpotPrice(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        java.lang.Object getTerminateInstancesWithExpiration();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        void setTerminateInstancesWithExpiration(final java.lang.Boolean value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        void setTerminateInstancesWithExpiration(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        java.lang.String getType();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        void setType(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        java.lang.String getValidFrom();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        void setValidFrom(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        java.lang.String getValidUntil();
        /**
         * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        void setValidUntil(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link SpotFleetRequestConfigDataProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetRequestConfigDataProperty}
         */
        final class Builder {
            private java.lang.String _iamFleetRole;
            private java.lang.Object _targetCapacity;
            @javax.annotation.Nullable
            private java.lang.String _allocationStrategy;
            @javax.annotation.Nullable
            private java.lang.String _excessCapacityTerminationPolicy;
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _launchSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateConfigs;
            @javax.annotation.Nullable
            private java.lang.Object _loadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _replaceUnhealthyInstances;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.Object _terminateInstancesWithExpiration;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _validFrom;
            @javax.annotation.Nullable
            private java.lang.String _validUntil;

            /**
             * Sets the value of IamFleetRole
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @return {@code this}
             */
            public Builder withIamFleetRole(final java.lang.String value) {
                this._iamFleetRole = java.util.Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }
            /**
             * Sets the value of TargetCapacity
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @return {@code this}
             */
            public Builder withTargetCapacity(final java.lang.Number value) {
                this._targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }
            /**
             * Sets the value of TargetCapacity
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @return {@code this}
             */
            public Builder withTargetCapacity(final software.amazon.awscdk.Token value) {
                this._targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }
            /**
             * Sets the value of AllocationStrategy
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @return {@code this}
             */
            public Builder withAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this._allocationStrategy = value;
                return this;
            }
            /**
             * Sets the value of ExcessCapacityTerminationPolicy
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @return {@code this}
             */
            public Builder withExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }
            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @return {@code this}
             */
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @return {@code this}
             */
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
             * @return {@code this}
             */
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
             * @return {@code this}
             */
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
             * @return {@code this}
             */
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
             * @return {@code this}
             */
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @return {@code this}
             */
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @return {@code this}
             */
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @return {@code this}
             */
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @return {@code this}
             */
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of ValidFrom
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @return {@code this}
             */
            public Builder withValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                this._validFrom = value;
                return this;
            }
            /**
             * Sets the value of ValidUntil
             * @param value ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @return {@code this}
             */
            public Builder withValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                this._validUntil = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetRequestConfigDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetRequestConfigDataProperty build() {
                return new SpotFleetRequestConfigDataProperty() {
                    private java.lang.String $iamFleetRole = java.util.Objects.requireNonNull(_iamFleetRole, "iamFleetRole is required");
                    private java.lang.Object $targetCapacity = java.util.Objects.requireNonNull(_targetCapacity, "targetCapacity is required");
                    @javax.annotation.Nullable
                    private java.lang.String $allocationStrategy = _allocationStrategy;
                    @javax.annotation.Nullable
                    private java.lang.String $excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                    @javax.annotation.Nullable
                    private java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private java.lang.Object $launchSpecifications = _launchSpecifications;
                    @javax.annotation.Nullable
                    private java.lang.Object $launchTemplateConfigs = _launchTemplateConfigs;
                    @javax.annotation.Nullable
                    private java.lang.Object $loadBalancersConfig = _loadBalancersConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $replaceUnhealthyInstances = _replaceUnhealthyInstances;
                    @javax.annotation.Nullable
                    private java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private java.lang.Object $terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                    @javax.annotation.Nullable
                    private java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.String $validFrom = _validFrom;
                    @javax.annotation.Nullable
                    private java.lang.String $validUntil = _validUntil;

                    @Override
                    public java.lang.String getIamFleetRole() {
                        return this.$iamFleetRole;
                    }

                    @Override
                    public void setIamFleetRole(final java.lang.String value) {
                        this.$iamFleetRole = java.util.Objects.requireNonNull(value, "iamFleetRole is required");
                    }

                    @Override
                    public java.lang.Object getTargetCapacity() {
                        return this.$targetCapacity;
                    }

                    @Override
                    public void setTargetCapacity(final java.lang.Number value) {
                        this.$targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public void setTargetCapacity(final software.amazon.awscdk.Token value) {
                        this.$targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                    }

                    @Override
                    public java.lang.String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public void setAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public java.lang.String getExcessCapacityTerminationPolicy() {
                        return this.$excessCapacityTerminationPolicy;
                    }

                    @Override
                    public void setExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                        this.$excessCapacityTerminationPolicy = value;
                    }

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public java.lang.Object getLaunchSpecifications() {
                        return this.$launchSpecifications;
                    }

                    @Override
                    public void setLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public void setLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$launchSpecifications = value;
                    }

                    @Override
                    public java.lang.Object getLaunchTemplateConfigs() {
                        return this.$launchTemplateConfigs;
                    }

                    @Override
                    public void setLaunchTemplateConfigs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$launchTemplateConfigs = value;
                    }

                    @Override
                    public void setLaunchTemplateConfigs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$launchTemplateConfigs = value;
                    }

                    @Override
                    public java.lang.Object getLoadBalancersConfig() {
                        return this.$loadBalancersConfig;
                    }

                    @Override
                    public void setLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$loadBalancersConfig = value;
                    }

                    @Override
                    public void setLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value) {
                        this.$loadBalancersConfig = value;
                    }

                    @Override
                    public java.lang.Object getReplaceUnhealthyInstances() {
                        return this.$replaceUnhealthyInstances;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$replaceUnhealthyInstances = value;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                        this.$spotPrice = value;
                    }

                    @Override
                    public java.lang.Object getTerminateInstancesWithExpiration() {
                        return this.$terminateInstancesWithExpiration;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$terminateInstancesWithExpiration = value;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.String getValidFrom() {
                        return this.$validFrom;
                    }

                    @Override
                    public void setValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                        this.$validFrom = value;
                    }

                    @Override
                    public java.lang.String getValidUntil() {
                        return this.$validUntil;
                    }

                    @Override
                    public void setValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                        this.$validUntil = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            @Override
            public java.lang.String getIamFleetRole() {
                return this.jsiiGet("iamFleetRole", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            @Override
            public void setIamFleetRole(final java.lang.String value) {
                this.jsiiSet("iamFleetRole", java.util.Objects.requireNonNull(value, "iamFleetRole is required"));
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            @Override
            public java.lang.Object getTargetCapacity() {
                return this.jsiiGet("targetCapacity", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            @Override
            public void setTargetCapacity(final java.lang.Number value) {
                this.jsiiSet("targetCapacity", java.util.Objects.requireNonNull(value, "targetCapacity is required"));
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            @Override
            public void setTargetCapacity(final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetCapacity", java.util.Objects.requireNonNull(value, "targetCapacity is required"));
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            @Override
            public void setAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("allocationStrategy", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getExcessCapacityTerminationPolicy() {
                return this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            @Override
            public void setExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("excessCapacityTerminationPolicy", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
             */
            @Override
            public void setInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("instanceInterruptionBehavior", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchSpecifications() {
                return this.jsiiGet("launchSpecifications", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @Override
            public void setLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchSpecifications", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @Override
            public void setLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("launchSpecifications", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateConfigs() {
                return this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
             */
            @Override
            public void setLaunchTemplateConfigs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("launchTemplateConfigs", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
             */
            @Override
            public void setLaunchTemplateConfigs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("launchTemplateConfigs", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLoadBalancersConfig() {
                return this.jsiiGet("loadBalancersConfig", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
             */
            @Override
            public void setLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("loadBalancersConfig", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
             */
            @Override
            public void setLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value) {
                this.jsiiSet("loadBalancersConfig", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getReplaceUnhealthyInstances() {
                return this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @Override
            public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("replaceUnhealthyInstances", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @Override
            public void setReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("replaceUnhealthyInstances", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            @Override
            public void setSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("spotPrice", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @Override
            public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("terminateInstancesWithExpiration", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @Override
            public void setTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("terminateInstancesWithExpiration", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValidFrom() {
                return this.jsiiGet("validFrom", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            @Override
            public void setValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("validFrom", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValidUntil() {
                return this.jsiiGet("validUntil", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            @Override
            public void setValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("validUntil", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        java.lang.String getResourceType();
        /**
         * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        void setResourceType(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        java.lang.Object getTags();
        /**
         * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        void setTags(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        void setTags(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link SpotFleetTagSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetTagSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.lang.Object _tags;

            /**
             * Sets the value of ResourceType
             * @param value ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tags = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetTagSpecificationProperty build() {
                return new SpotFleetTagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private java.lang.Object $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public java.lang.Object getTags() {
                        return this.$tags;
                    }

                    @Override
                    public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$tags = value;
                    }

                    @Override
                    public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$tags = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            @Override
            public void setResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceType", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTags() {
                return this.jsiiGet("tags", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
             */
            @Override
            public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("tags", value);
            }

            /**
             * ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
             */
            @Override
            public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("tags", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        void setAvailabilityZone(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        java.lang.String getGroupName();
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        void setGroupName(final java.lang.String value);
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        java.lang.String getTenancy();
        /**
         * ``CfnSpotFleet.SpotPlacementProperty.Tenancy``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        void setTenancy(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link SpotPlacementProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotPlacementProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _groupName;
            @javax.annotation.Nullable
            private java.lang.String _tenancy;

            /**
             * Sets the value of AvailabilityZone
             * @param value ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value ``CfnSpotFleet.SpotPlacementProperty.GroupName``
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value ``CfnSpotFleet.SpotPlacementProperty.Tenancy``
             * @return {@code this}
             */
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotPlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotPlacementProperty build() {
                return new SpotPlacementProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private java.lang.String $groupName = _groupName;
                    @javax.annotation.Nullable
                    private java.lang.String $tenancy = _tenancy;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public java.lang.String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public java.lang.String getTenancy() {
                        return this.$tenancy;
                    }

                    @Override
                    public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
                        this.$tenancy = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            @Override
            public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("availabilityZone", value);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getGroupName() {
                return this.jsiiGet("groupName", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            @Override
            public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("groupName", value);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTenancy() {
                return this.jsiiGet("tenancy", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.SpotPlacementProperty.Tenancy``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
             */
            @Override
            public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("tenancy", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    public static interface TargetGroupProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.TargetGroupProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        java.lang.String getArn();
        /**
         * ``CfnSpotFleet.TargetGroupProperty.Arn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        void setArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link TargetGroupProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupProperty}
         */
        final class Builder {
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value ``CfnSpotFleet.TargetGroupProperty.Arn``
             * @return {@code this}
             */
            public Builder withArn(final java.lang.String value) {
                this._arn = java.util.Objects.requireNonNull(value, "arn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupProperty build() {
                return new TargetGroupProperty() {
                    private java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(final java.lang.String value) {
                        this.$arn = java.util.Objects.requireNonNull(value, "arn is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.TargetGroupProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
             */
            @Override
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * ``CfnSpotFleet.TargetGroupProperty.Arn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
             */
            @Override
            public void setArn(final java.lang.String value) {
                this.jsiiSet("arn", java.util.Objects.requireNonNull(value, "arn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    public static interface TargetGroupsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        java.lang.Object getTargetGroups();
        /**
         * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        void setTargetGroups(final software.amazon.awscdk.Token value);
        /**
         * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        void setTargetGroups(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link TargetGroupsConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupsConfigProperty}
         */
        final class Builder {
            private java.lang.Object _targetGroups;

            /**
             * Sets the value of TargetGroups
             * @param value ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
             * @return {@code this}
             */
            public Builder withTargetGroups(final software.amazon.awscdk.Token value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }
            /**
             * Sets the value of TargetGroups
             * @param value ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
             * @return {@code this}
             */
            public Builder withTargetGroups(final java.util.List<java.lang.Object> value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupsConfigProperty build() {
                return new TargetGroupsConfigProperty() {
                    private java.lang.Object $targetGroups = java.util.Objects.requireNonNull(_targetGroups, "targetGroups is required");

                    @Override
                    public java.lang.Object getTargetGroups() {
                        return this.$targetGroups;
                    }

                    @Override
                    public void setTargetGroups(final software.amazon.awscdk.Token value) {
                        this.$targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                    }

                    @Override
                    public void setTargetGroups(final java.util.List<java.lang.Object> value) {
                        this.$targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
             */
            @Override
            public java.lang.Object getTargetGroups() {
                return this.jsiiGet("targetGroups", java.lang.Object.class);
            }

            /**
             * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
             */
            @Override
            public void setTargetGroups(final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroups", java.util.Objects.requireNonNull(value, "targetGroups is required"));
            }

            /**
             * ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
             */
            @Override
            public void setTargetGroups(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("targetGroups", java.util.Objects.requireNonNull(value, "targetGroups is required"));
            }
        }
    }
}
