package software.amazon.awscdk.services.ec2;

/**
 * A new or imported VPC
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:48:43.544Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcNetworkBase")
public abstract class VpcNetworkBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.ec2.IVpcNetwork {
    protected VpcNetworkBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Export this VPC from the stack
     */
    @Override
    public abstract software.amazon.awscdk.services.ec2.VpcNetworkImportProps export();

    /**
     * Take a dependency on internet connectivity having been added to this VPC
     * 
     * Take a dependency on this if your constructs need an Internet Gateway
     * added to the VPC before they can be constructed.
     * 
     * This method is for construct authors; application builders should not
     * need to call this.
     */
    @Override
    public software.amazon.awscdk.IDependable internetDependency() {
        return this.jsiiCall("internetDependency", software.amazon.awscdk.IDependable.class);
    }

    /**
     * Return whether the given subnet is one of this VPC's public subnets.
     * 
     * The subnet must literally be one of the subnet object obtained from
     * this VPC. A subnet that merely represents the same subnet will
     * never return true.
     */
    @Override
    public java.lang.Boolean isPublicSubnet(final software.amazon.awscdk.services.ec2.IVpcSubnet subnet) {
        return this.jsiiCall("isPublicSubnet", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(subnet, "subnet is required")).toArray());
    }

    /**
     * Return the subnets appropriate for the placement strategy
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy placement) {
        return this.jsiiCall("subnets", java.util.List.class, java.util.stream.Stream.of(placement).toArray());
    }

    /**
     * Return the subnets appropriate for the placement strategy
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets() {
        return this.jsiiCall("subnets", java.util.List.class);
    }

    /**
     * AZs for this VPC
     */
    @Override
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * Parts of the VPC that constitute full construction
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * Dependencies for internet connectivity
     */
    public java.util.List<software.amazon.awscdk.IDependable> getInternetDependencies() {
        return this.jsiiGet("internetDependencies", java.util.List.class);
    }

    /**
     * List of isolated subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     * Identifier for this VPC
     */
    @Override
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * The region where this VPC is defined
     */
    @Override
    public java.lang.String getVpcRegion() {
        return this.jsiiGet("vpcRegion", java.lang.String.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.ec2.VpcNetworkBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * AZs for this VPC
         */
        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * List of isolated subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
            return this.jsiiGet("isolatedSubnets", java.util.List.class);
        }

        /**
         * List of private subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
            return this.jsiiGet("privateSubnets", java.util.List.class);
        }

        /**
         * List of public subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
            return this.jsiiGet("publicSubnets", java.util.List.class);
        }

        /**
         * Identifier for this VPC
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * Region where this VPC is located
         */
        @Override
        public java.lang.String getVpcRegion() {
            return this.jsiiGet("vpcRegion", java.lang.String.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * Returns the set of all stack elements (resources, parameters, conditions)
         * that should be added when a resource "depends on" this construct.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
            return this.jsiiGet("dependencyElements", java.util.List.class);
        }

        /**
         * Exports this VPC so it can be consumed by another stack.
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.ec2.VpcNetworkImportProps.class);
        }

        /**
         * Take a dependency on internet connectivity having been added to this VPC
         * 
         * Take a dependency on this if your constructs need an Internet Gateway
         * added to the VPC before they can be constructed.
         * 
         * This method is for construct authors; application builders should not
         * need to call this.
         */
        @Override
        public software.amazon.awscdk.IDependable internetDependency() {
            return this.jsiiCall("internetDependency", software.amazon.awscdk.IDependable.class);
        }

        /**
         * Return whether the given subnet is one of this VPC's public subnets.
         * 
         * The subnet must literally be one of the subnet object obtained from
         * this VPC. A subnet that merely represents the same subnet will
         * never return true.
         */
        @Override
        public java.lang.Boolean isPublicSubnet(final software.amazon.awscdk.services.ec2.IVpcSubnet subnet) {
            return this.jsiiCall("isPublicSubnet", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(subnet, "subnet is required")).toArray());
        }

        /**
         * Return the subnets appropriate for the placement strategy
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy placement) {
            return this.jsiiCall("subnets", java.util.List.class, java.util.stream.Stream.of(placement).toArray());
        }

        /**
         * Return the subnets appropriate for the placement strategy
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets() {
            return this.jsiiCall("subnets", java.util.List.class);
        }
    }
}
