/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLaunchTemplate.class, (String)"resourceTypeName", String.class);

    protected CfnLaunchTemplate(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnLaunchTemplate(Construct scope, String id, @Nullable CfnLaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))), Stream.of(props)).toArray());
    }

    public CfnLaunchTemplate(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public String getLaunchTemplateDefaultVersionNumber() {
        return (String)this.jsiiGet("launchTemplateDefaultVersionNumber", String.class);
    }

    public String getLaunchTemplateId() {
        return (String)this.jsiiGet("launchTemplateId", String.class);
    }

    public String getLaunchTemplateLatestVersionNumber() {
        return (String)this.jsiiGet("launchTemplateLatestVersionNumber", String.class);
    }

    public CfnLaunchTemplateProps getPropertyOverrides() {
        return (CfnLaunchTemplateProps)this.jsiiGet("propertyOverrides", CfnLaunchTemplateProps.class);
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public void setResourceType(String var1);

        public Object getTags();

        public void setTags(Token var1);

        public void setTags(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _resourceType;
            @Nullable
            private Object _tags;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withTags(@Nullable Token value) {
                this._tags = value;
                return this;
            }

            public Builder withTags(@Nullable List<Object> value) {
                this._tags = value;
                return this;
            }

            public TagSpecificationProperty build() {
                return new TagSpecificationProperty(){
                    @Nullable
                    private String $resourceType;
                    @Nullable
                    private Object $tags;
                    {
                        this.$resourceType = _resourceType;
                        this.$tags = _tags;
                    }

                    @Override
                    public String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@Nullable String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public Object getTags() {
                        return this.$tags;
                    }

                    @Override
                    public void setTags(@Nullable Token value) {
                        this.$tags = value;
                    }

                    @Override
                    public void setTags(@Nullable List<Object> value) {
                        this.$tags = value;
                    }
                };
            }
        }
    }

    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        public String getInstanceInterruptionBehavior();

        public void setInstanceInterruptionBehavior(String var1);

        public String getMaxPrice();

        public void setMaxPrice(String var1);

        public String getSpotInstanceType();

        public void setSpotInstanceType(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _instanceInterruptionBehavior;
            @Nullable
            private String _maxPrice;
            @Nullable
            private String _spotInstanceType;

            public Builder withInstanceInterruptionBehavior(@Nullable String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withMaxPrice(@Nullable String value) {
                this._maxPrice = value;
                return this;
            }

            public Builder withSpotInstanceType(@Nullable String value) {
                this._spotInstanceType = value;
                return this;
            }

            public SpotOptionsProperty build() {
                return new SpotOptionsProperty(){
                    @Nullable
                    private String $instanceInterruptionBehavior;
                    @Nullable
                    private String $maxPrice;
                    @Nullable
                    private String $spotInstanceType;
                    {
                        this.$instanceInterruptionBehavior = _instanceInterruptionBehavior;
                        this.$maxPrice = _maxPrice;
                        this.$spotInstanceType = _spotInstanceType;
                    }

                    @Override
                    public String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public void setMaxPrice(@Nullable String value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public String getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    @Override
                    public void setSpotInstanceType(@Nullable String value) {
                        this.$spotInstanceType = value;
                    }
                };
            }
        }
    }

    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public void setPrimary(Boolean var1);

        public void setPrimary(Token var1);

        public String getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _primary;
            @Nullable
            private String _privateIpAddress;

            public Builder withPrimary(@Nullable Boolean value) {
                this._primary = value;
                return this;
            }

            public Builder withPrimary(@Nullable Token value) {
                this._primary = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty(){
                    @Nullable
                    private Object $primary;
                    @Nullable
                    private String $privateIpAddress;
                    {
                        this.$primary = _primary;
                        this.$privateIpAddress = _privateIpAddress;
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public void setPrimary(@Nullable Boolean value) {
                        this.$primary = value;
                    }

                    @Override
                    public void setPrimary(@Nullable Token value) {
                        this.$primary = value;
                    }

                    @Override
                    public String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable String value) {
                        this.$privateIpAddress = value;
                    }
                };
            }
        }
    }

    public static interface PlacementProperty
    extends JsiiSerializable {
        public String getAffinity();

        public void setAffinity(String var1);

        public String getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public String getGroupName();

        public void setGroupName(String var1);

        public String getHostId();

        public void setHostId(String var1);

        public String getTenancy();

        public void setTenancy(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _affinity;
            @Nullable
            private String _availabilityZone;
            @Nullable
            private String _groupName;
            @Nullable
            private String _hostId;
            @Nullable
            private String _tenancy;

            public Builder withAffinity(@Nullable String value) {
                this._affinity = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withHostId(@Nullable String value) {
                this._hostId = value;
                return this;
            }

            public Builder withTenancy(@Nullable String value) {
                this._tenancy = value;
                return this;
            }

            public PlacementProperty build() {
                return new PlacementProperty(){
                    @Nullable
                    private String $affinity;
                    @Nullable
                    private String $availabilityZone;
                    @Nullable
                    private String $groupName;
                    @Nullable
                    private String $hostId;
                    @Nullable
                    private String $tenancy;
                    {
                        this.$affinity = _affinity;
                        this.$availabilityZone = _availabilityZone;
                        this.$groupName = _groupName;
                        this.$hostId = _hostId;
                        this.$tenancy = _tenancy;
                    }

                    @Override
                    public String getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public void setAffinity(@Nullable String value) {
                        this.$affinity = value;
                    }

                    @Override
                    public String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@Nullable String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public String getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public void setHostId(@Nullable String value) {
                        this.$hostId = value;
                    }

                    @Override
                    public String getTenancy() {
                        return this.$tenancy;
                    }

                    @Override
                    public void setTenancy(@Nullable String value) {
                        this.$tenancy = value;
                    }
                };
            }
        }
    }

    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public void setAssociatePublicIpAddress(Boolean var1);

        public void setAssociatePublicIpAddress(Token var1);

        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(Token var1);

        public String getDescription();

        public void setDescription(String var1);

        public Object getDeviceIndex();

        public void setDeviceIndex(Number var1);

        public void setDeviceIndex(Token var1);

        public Object getGroups();

        public void setGroups(Token var1);

        public void setGroups(List<Object> var1);

        public Object getIpv6AddressCount();

        public void setIpv6AddressCount(Number var1);

        public void setIpv6AddressCount(Token var1);

        public Object getIpv6Addresses();

        public void setIpv6Addresses(Token var1);

        public void setIpv6Addresses(List<Object> var1);

        public String getNetworkInterfaceId();

        public void setNetworkInterfaceId(String var1);

        public String getPrivateIpAddress();

        public void setPrivateIpAddress(String var1);

        public Object getPrivateIpAddresses();

        public void setPrivateIpAddresses(Token var1);

        public void setPrivateIpAddresses(List<Object> var1);

        public Object getSecondaryPrivateIpAddressCount();

        public void setSecondaryPrivateIpAddressCount(Number var1);

        public void setSecondaryPrivateIpAddressCount(Token var1);

        public String getSubnetId();

        public void setSubnetId(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _associatePublicIpAddress;
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private String _description;
            @Nullable
            private Object _deviceIndex;
            @Nullable
            private Object _groups;
            @Nullable
            private Object _ipv6AddressCount;
            @Nullable
            private Object _ipv6Addresses;
            @Nullable
            private String _networkInterfaceId;
            @Nullable
            private String _privateIpAddress;
            @Nullable
            private Object _privateIpAddresses;
            @Nullable
            private Object _secondaryPrivateIpAddressCount;
            @Nullable
            private String _subnetId;

            public Builder withAssociatePublicIpAddress(@Nullable Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withAssociatePublicIpAddress(@Nullable Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDescription(@Nullable String value) {
                this._description = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Number value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Token value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withGroups(@Nullable Token value) {
                this._groups = value;
                return this;
            }

            public Builder withGroups(@Nullable List<Object> value) {
                this._groups = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Number value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Token value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable Token value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable List<Object> value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable String value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable Token value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable List<Object> value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty(){
                    @Nullable
                    private Object $associatePublicIpAddress;
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private String $description;
                    @Nullable
                    private Object $deviceIndex;
                    @Nullable
                    private Object $groups;
                    @Nullable
                    private Object $ipv6AddressCount;
                    @Nullable
                    private Object $ipv6Addresses;
                    @Nullable
                    private String $networkInterfaceId;
                    @Nullable
                    private String $privateIpAddress;
                    @Nullable
                    private Object $privateIpAddresses;
                    @Nullable
                    private Object $secondaryPrivateIpAddressCount;
                    @Nullable
                    private String $subnetId;
                    {
                        this.$associatePublicIpAddress = _associatePublicIpAddress;
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$description = _description;
                        this.$deviceIndex = _deviceIndex;
                        this.$groups = _groups;
                        this.$ipv6AddressCount = _ipv6AddressCount;
                        this.$ipv6Addresses = _ipv6Addresses;
                        this.$networkInterfaceId = _networkInterfaceId;
                        this.$privateIpAddress = _privateIpAddress;
                        this.$privateIpAddresses = _privateIpAddresses;
                        this.$secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                        this.$subnetId = _subnetId;
                    }

                    @Override
                    public Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Boolean value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public void setAssociatePublicIpAddress(@Nullable Token value) {
                        this.$associatePublicIpAddress = value;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@Nullable String value) {
                        this.$description = value;
                    }

                    @Override
                    public Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Number value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public void setDeviceIndex(@Nullable Token value) {
                        this.$deviceIndex = value;
                    }

                    @Override
                    public Object getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public void setGroups(@Nullable Token value) {
                        this.$groups = value;
                    }

                    @Override
                    public void setGroups(@Nullable List<Object> value) {
                        this.$groups = value;
                    }

                    @Override
                    public Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Number value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public void setIpv6AddressCount(@Nullable Token value) {
                        this.$ipv6AddressCount = value;
                    }

                    @Override
                    public Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable Token value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public void setIpv6Addresses(@Nullable List<Object> value) {
                        this.$ipv6Addresses = value;
                    }

                    @Override
                    public String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public void setNetworkInterfaceId(@Nullable String value) {
                        this.$networkInterfaceId = value;
                    }

                    @Override
                    public String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public void setPrivateIpAddress(@Nullable String value) {
                        this.$privateIpAddress = value;
                    }

                    @Override
                    public Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable Token value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public void setPrivateIpAddresses(@Nullable List<Object> value) {
                        this.$privateIpAddresses = value;
                    }

                    @Override
                    public Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Number value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public void setSecondaryPrivateIpAddressCount(@Nullable Token value) {
                        this.$secondaryPrivateIpAddressCount = value;
                    }

                    @Override
                    public String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }
                };
            }
        }
    }

    public static interface MonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public void setEnabled(Boolean var1);

        public void setEnabled(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _enabled;

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable Token value) {
                this._enabled = value;
                return this;
            }

            public MonitoringProperty build() {
                return new MonitoringProperty(){
                    @Nullable
                    private Object $enabled;
                    {
                        this.$enabled = _enabled;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@Nullable Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@Nullable Token value) {
                        this.$enabled = value;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        public Object getBlockDeviceMappings();

        public void setBlockDeviceMappings(Token var1);

        public void setBlockDeviceMappings(List<Object> var1);

        public Object getCreditSpecification();

        public void setCreditSpecification(Token var1);

        public void setCreditSpecification(CreditSpecificationProperty var1);

        public Object getDisableApiTermination();

        public void setDisableApiTermination(Boolean var1);

        public void setDisableApiTermination(Token var1);

        public Object getEbsOptimized();

        public void setEbsOptimized(Boolean var1);

        public void setEbsOptimized(Token var1);

        public Object getElasticGpuSpecifications();

        public void setElasticGpuSpecifications(Token var1);

        public void setElasticGpuSpecifications(List<Object> var1);

        public Object getIamInstanceProfile();

        public void setIamInstanceProfile(Token var1);

        public void setIamInstanceProfile(IamInstanceProfileProperty var1);

        public String getImageId();

        public void setImageId(String var1);

        public String getInstanceInitiatedShutdownBehavior();

        public void setInstanceInitiatedShutdownBehavior(String var1);

        public Object getInstanceMarketOptions();

        public void setInstanceMarketOptions(Token var1);

        public void setInstanceMarketOptions(InstanceMarketOptionsProperty var1);

        public String getInstanceType();

        public void setInstanceType(String var1);

        public String getKernelId();

        public void setKernelId(String var1);

        public String getKeyName();

        public void setKeyName(String var1);

        public Object getMonitoring();

        public void setMonitoring(Token var1);

        public void setMonitoring(MonitoringProperty var1);

        public Object getNetworkInterfaces();

        public void setNetworkInterfaces(Token var1);

        public void setNetworkInterfaces(List<Object> var1);

        public Object getPlacement();

        public void setPlacement(Token var1);

        public void setPlacement(PlacementProperty var1);

        public String getRamDiskId();

        public void setRamDiskId(String var1);

        public Object getSecurityGroupIds();

        public void setSecurityGroupIds(Token var1);

        public void setSecurityGroupIds(List<Object> var1);

        public Object getSecurityGroups();

        public void setSecurityGroups(Token var1);

        public void setSecurityGroups(List<Object> var1);

        public Object getTagSpecifications();

        public void setTagSpecifications(Token var1);

        public void setTagSpecifications(List<Object> var1);

        public String getUserData();

        public void setUserData(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _blockDeviceMappings;
            @Nullable
            private Object _creditSpecification;
            @Nullable
            private Object _disableApiTermination;
            @Nullable
            private Object _ebsOptimized;
            @Nullable
            private Object _elasticGpuSpecifications;
            @Nullable
            private Object _iamInstanceProfile;
            @Nullable
            private String _imageId;
            @Nullable
            private String _instanceInitiatedShutdownBehavior;
            @Nullable
            private Object _instanceMarketOptions;
            @Nullable
            private String _instanceType;
            @Nullable
            private String _kernelId;
            @Nullable
            private String _keyName;
            @Nullable
            private Object _monitoring;
            @Nullable
            private Object _networkInterfaces;
            @Nullable
            private Object _placement;
            @Nullable
            private String _ramDiskId;
            @Nullable
            private Object _securityGroupIds;
            @Nullable
            private Object _securityGroups;
            @Nullable
            private Object _tagSpecifications;
            @Nullable
            private String _userData;

            public Builder withBlockDeviceMappings(@Nullable Token value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable List<Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable Token value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable Boolean value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable Token value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Boolean value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Token value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable Token value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable List<Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable Token value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withImageId(@Nullable String value) {
                this._imageId = value;
                return this;
            }

            public Builder withInstanceInitiatedShutdownBehavior(@Nullable String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable Token value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceType(@Nullable String value) {
                this._instanceType = value;
                return this;
            }

            public Builder withKernelId(@Nullable String value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKeyName(@Nullable String value) {
                this._keyName = value;
                return this;
            }

            public Builder withMonitoring(@Nullable Token value) {
                this._monitoring = value;
                return this;
            }

            public Builder withMonitoring(@Nullable MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable Token value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable List<Object> value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withPlacement(@Nullable Token value) {
                this._placement = value;
                return this;
            }

            public Builder withPlacement(@Nullable PlacementProperty value) {
                this._placement = value;
                return this;
            }

            public Builder withRamDiskId(@Nullable String value) {
                this._ramDiskId = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable Token value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable List<Object> value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable Token value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable List<Object> value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable Token value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable List<Object> value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withUserData(@Nullable String value) {
                this._userData = value;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty(){
                    @Nullable
                    private Object $blockDeviceMappings;
                    @Nullable
                    private Object $creditSpecification;
                    @Nullable
                    private Object $disableApiTermination;
                    @Nullable
                    private Object $ebsOptimized;
                    @Nullable
                    private Object $elasticGpuSpecifications;
                    @Nullable
                    private Object $iamInstanceProfile;
                    @Nullable
                    private String $imageId;
                    @Nullable
                    private String $instanceInitiatedShutdownBehavior;
                    @Nullable
                    private Object $instanceMarketOptions;
                    @Nullable
                    private String $instanceType;
                    @Nullable
                    private String $kernelId;
                    @Nullable
                    private String $keyName;
                    @Nullable
                    private Object $monitoring;
                    @Nullable
                    private Object $networkInterfaces;
                    @Nullable
                    private Object $placement;
                    @Nullable
                    private String $ramDiskId;
                    @Nullable
                    private Object $securityGroupIds;
                    @Nullable
                    private Object $securityGroups;
                    @Nullable
                    private Object $tagSpecifications;
                    @Nullable
                    private String $userData;
                    {
                        this.$blockDeviceMappings = _blockDeviceMappings;
                        this.$creditSpecification = _creditSpecification;
                        this.$disableApiTermination = _disableApiTermination;
                        this.$ebsOptimized = _ebsOptimized;
                        this.$elasticGpuSpecifications = _elasticGpuSpecifications;
                        this.$iamInstanceProfile = _iamInstanceProfile;
                        this.$imageId = _imageId;
                        this.$instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                        this.$instanceMarketOptions = _instanceMarketOptions;
                        this.$instanceType = _instanceType;
                        this.$kernelId = _kernelId;
                        this.$keyName = _keyName;
                        this.$monitoring = _monitoring;
                        this.$networkInterfaces = _networkInterfaces;
                        this.$placement = _placement;
                        this.$ramDiskId = _ramDiskId;
                        this.$securityGroupIds = _securityGroupIds;
                        this.$securityGroups = _securityGroups;
                        this.$tagSpecifications = _tagSpecifications;
                        this.$userData = _userData;
                    }

                    @Override
                    public Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable Token value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public void setBlockDeviceMappings(@Nullable List<Object> value) {
                        this.$blockDeviceMappings = value;
                    }

                    @Override
                    public Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public void setCreditSpecification(@Nullable Token value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public void setCreditSpecification(@Nullable CreditSpecificationProperty value) {
                        this.$creditSpecification = value;
                    }

                    @Override
                    public Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public void setDisableApiTermination(@Nullable Boolean value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public void setDisableApiTermination(@Nullable Token value) {
                        this.$disableApiTermination = value;
                    }

                    @Override
                    public Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Boolean value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public void setEbsOptimized(@Nullable Token value) {
                        this.$ebsOptimized = value;
                    }

                    @Override
                    public Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@Nullable Token value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public void setElasticGpuSpecifications(@Nullable List<Object> value) {
                        this.$elasticGpuSpecifications = value;
                    }

                    @Override
                    public Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable Token value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public void setIamInstanceProfile(@Nullable IamInstanceProfileProperty value) {
                        this.$iamInstanceProfile = value;
                    }

                    @Override
                    public String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public void setImageId(@Nullable String value) {
                        this.$imageId = value;
                    }

                    @Override
                    public String getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public void setInstanceInitiatedShutdownBehavior(@Nullable String value) {
                        this.$instanceInitiatedShutdownBehavior = value;
                    }

                    @Override
                    public Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public void setInstanceMarketOptions(@Nullable Token value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public void setInstanceMarketOptions(@Nullable InstanceMarketOptionsProperty value) {
                        this.$instanceMarketOptions = value;
                    }

                    @Override
                    public String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@Nullable String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public void setKernelId(@Nullable String value) {
                        this.$kernelId = value;
                    }

                    @Override
                    public String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public void setKeyName(@Nullable String value) {
                        this.$keyName = value;
                    }

                    @Override
                    public Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public void setMonitoring(@Nullable Token value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public void setMonitoring(@Nullable MonitoringProperty value) {
                        this.$monitoring = value;
                    }

                    @Override
                    public Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable Token value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public void setNetworkInterfaces(@Nullable List<Object> value) {
                        this.$networkInterfaces = value;
                    }

                    @Override
                    public Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public void setPlacement(@Nullable Token value) {
                        this.$placement = value;
                    }

                    @Override
                    public void setPlacement(@Nullable PlacementProperty value) {
                        this.$placement = value;
                    }

                    @Override
                    public String getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public void setRamDiskId(@Nullable String value) {
                        this.$ramDiskId = value;
                    }

                    @Override
                    public Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable Token value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable List<Object> value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable Token value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public void setSecurityGroups(@Nullable List<Object> value) {
                        this.$securityGroups = value;
                    }

                    @Override
                    public Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable Token value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public void setTagSpecifications(@Nullable List<Object> value) {
                        this.$tagSpecifications = value;
                    }

                    @Override
                    public String getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public void setUserData(@Nullable String value) {
                        this.$userData = value;
                    }
                };
            }
        }
    }

    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public void setIpv6Address(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _ipv6Address;

            public Builder withIpv6Address(@Nullable String value) {
                this._ipv6Address = value;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Ipv6AddProperty(){
                    @Nullable
                    private String $ipv6Address;
                    {
                        this.$ipv6Address = _ipv6Address;
                    }

                    @Override
                    public String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    @Override
                    public void setIpv6Address(@Nullable String value) {
                        this.$ipv6Address = value;
                    }
                };
            }
        }
    }

    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        public String getMarketType();

        public void setMarketType(String var1);

        public Object getSpotOptions();

        public void setSpotOptions(Token var1);

        public void setSpotOptions(SpotOptionsProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _marketType;
            @Nullable
            private Object _spotOptions;

            public Builder withMarketType(@Nullable String value) {
                this._marketType = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable Token value) {
                this._spotOptions = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty(){
                    @Nullable
                    private String $marketType;
                    @Nullable
                    private Object $spotOptions;
                    {
                        this.$marketType = _marketType;
                        this.$spotOptions = _spotOptions;
                    }

                    @Override
                    public String getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public void setMarketType(@Nullable String value) {
                        this.$marketType = value;
                    }

                    @Override
                    public Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    @Override
                    public void setSpotOptions(@Nullable Token value) {
                        this.$spotOptions = value;
                    }

                    @Override
                    public void setSpotOptions(@Nullable SpotOptionsProperty value) {
                        this.$spotOptions = value;
                    }
                };
            }
        }
    }

    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        public String getArn();

        public void setArn(String var1);

        public String getName();

        public void setName(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _arn;
            @Nullable
            private String _name;

            public Builder withArn(@Nullable String value) {
                this._arn = value;
                return this;
            }

            public Builder withName(@Nullable String value) {
                this._name = value;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty(){
                    @Nullable
                    private String $arn;
                    @Nullable
                    private String $name;
                    {
                        this.$arn = _arn;
                        this.$name = _name;
                    }

                    @Override
                    public String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public void setArn(@Nullable String value) {
                        this.$arn = value;
                    }

                    @Override
                    public String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@Nullable String value) {
                        this.$name = value;
                    }
                };
            }
        }
    }

    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        public String getType();

        public void setType(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _type;

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty(){
                    @Nullable
                    private String $type;
                    {
                        this.$type = _type;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@Nullable String value) {
                        this.$type = value;
                    }
                };
            }
        }
    }

    public static interface EbsProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public void setDeleteOnTermination(Boolean var1);

        public void setDeleteOnTermination(Token var1);

        public Object getEncrypted();

        public void setEncrypted(Boolean var1);

        public void setEncrypted(Token var1);

        public Object getIops();

        public void setIops(Number var1);

        public void setIops(Token var1);

        public String getKmsKeyId();

        public void setKmsKeyId(String var1);

        public String getSnapshotId();

        public void setSnapshotId(String var1);

        public Object getVolumeSize();

        public void setVolumeSize(Number var1);

        public void setVolumeSize(Token var1);

        public String getVolumeType();

        public void setVolumeType(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _encrypted;
            @Nullable
            private Object _iops;
            @Nullable
            private String _kmsKeyId;
            @Nullable
            private String _snapshotId;
            @Nullable
            private Object _volumeSize;
            @Nullable
            private String _volumeType;

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Boolean value) {
                this._encrypted = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Token value) {
                this._encrypted = value;
                return this;
            }

            public Builder withIops(@Nullable Number value) {
                this._iops = value;
                return this;
            }

            public Builder withIops(@Nullable Token value) {
                this._iops = value;
                return this;
            }

            public Builder withKmsKeyId(@Nullable String value) {
                this._kmsKeyId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable String value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Number value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Token value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeType(@Nullable String value) {
                this._volumeType = value;
                return this;
            }

            public EbsProperty build() {
                return new EbsProperty(){
                    @Nullable
                    private Object $deleteOnTermination;
                    @Nullable
                    private Object $encrypted;
                    @Nullable
                    private Object $iops;
                    @Nullable
                    private String $kmsKeyId;
                    @Nullable
                    private String $snapshotId;
                    @Nullable
                    private Object $volumeSize;
                    @Nullable
                    private String $volumeType;
                    {
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$encrypted = _encrypted;
                        this.$iops = _iops;
                        this.$kmsKeyId = _kmsKeyId;
                        this.$snapshotId = _snapshotId;
                        this.$volumeSize = _volumeSize;
                        this.$volumeType = _volumeType;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Boolean value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public void setDeleteOnTermination(@Nullable Token value) {
                        this.$deleteOnTermination = value;
                    }

                    @Override
                    public Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public void setEncrypted(@Nullable Boolean value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public void setEncrypted(@Nullable Token value) {
                        this.$encrypted = value;
                    }

                    @Override
                    public Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public void setIops(@Nullable Number value) {
                        this.$iops = value;
                    }

                    @Override
                    public void setIops(@Nullable Token value) {
                        this.$iops = value;
                    }

                    @Override
                    public String getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public void setKmsKeyId(@Nullable String value) {
                        this.$kmsKeyId = value;
                    }

                    @Override
                    public String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public void setSnapshotId(@Nullable String value) {
                        this.$snapshotId = value;
                    }

                    @Override
                    public Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Number value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public void setVolumeSize(@Nullable Token value) {
                        this.$volumeSize = value;
                    }

                    @Override
                    public String getVolumeType() {
                        return this.$volumeType;
                    }

                    @Override
                    public void setVolumeType(@Nullable String value) {
                        this.$volumeType = value;
                    }
                };
            }
        }
    }

    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        public String getCpuCredits();

        public void setCpuCredits(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _cpuCredits;

            public Builder withCpuCredits(@Nullable String value) {
                this._cpuCredits = value;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty(){
                    @Nullable
                    private String $cpuCredits;
                    {
                        this.$cpuCredits = _cpuCredits;
                    }

                    @Override
                    public String getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    @Override
                    public void setCpuCredits(@Nullable String value) {
                        this.$cpuCredits = value;
                    }
                };
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public String getDeviceName();

        public void setDeviceName(String var1);

        public Object getEbs();

        public void setEbs(Token var1);

        public void setEbs(EbsProperty var1);

        public String getNoDevice();

        public void setNoDevice(String var1);

        public String getVirtualName();

        public void setVirtualName(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _deviceName;
            @Nullable
            private Object _ebs;
            @Nullable
            private String _noDevice;
            @Nullable
            private String _virtualName;

            public Builder withDeviceName(@Nullable String value) {
                this._deviceName = value;
                return this;
            }

            public Builder withEbs(@Nullable Token value) {
                this._ebs = value;
                return this;
            }

            public Builder withEbs(@Nullable EbsProperty value) {
                this._ebs = value;
                return this;
            }

            public Builder withNoDevice(@Nullable String value) {
                this._noDevice = value;
                return this;
            }

            public Builder withVirtualName(@Nullable String value) {
                this._virtualName = value;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty(){
                    @Nullable
                    private String $deviceName;
                    @Nullable
                    private Object $ebs;
                    @Nullable
                    private String $noDevice;
                    @Nullable
                    private String $virtualName;
                    {
                        this.$deviceName = _deviceName;
                        this.$ebs = _ebs;
                        this.$noDevice = _noDevice;
                        this.$virtualName = _virtualName;
                    }

                    @Override
                    public String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public void setDeviceName(@Nullable String value) {
                        this.$deviceName = value;
                    }

                    @Override
                    public Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public void setEbs(@Nullable Token value) {
                        this.$ebs = value;
                    }

                    @Override
                    public void setEbs(@Nullable EbsProperty value) {
                        this.$ebs = value;
                    }

                    @Override
                    public String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public void setNoDevice(@Nullable String value) {
                        this.$noDevice = value;
                    }

                    @Override
                    public String getVirtualName() {
                        return this.$virtualName;
                    }

                    @Override
                    public void setVirtualName(@Nullable String value) {
                        this.$virtualName = value;
                    }
                };
            }
        }
    }
}

