package software.amazon.awscdk.services.ec2;

/**
 * Customize how instances are placed inside a VPC
 * 
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 * 
 * By default, the instances are placed in the private subnets.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:53:03.005Z")
public interface VpcPlacementStrategy extends software.amazon.jsii.JsiiSerializable {
    /**
     * Place the instances in the subnets with the given name
     * 
     * (This is the name supplied in subnetConfiguration).
     * 
     * At most one of `subnetsToUse` and `subnetName` can be supplied.
     * @default name
     */
    java.lang.String getSubnetName();
    /**
     * Place the instances in the subnets with the given name
     * 
     * (This is the name supplied in subnetConfiguration).
     * 
     * At most one of `subnetsToUse` and `subnetName` can be supplied.
     * @default name
     */
    void setSubnetName(final java.lang.String value);
    /**
     * Place the instances in the subnets of the given type
     * 
     * At most one of `subnetsToUse` and `subnetName` can be supplied.
     * @default SubnetType.Private
     */
    software.amazon.awscdk.services.ec2.SubnetType getSubnetsToUse();
    /**
     * Place the instances in the subnets of the given type
     * 
     * At most one of `subnetsToUse` and `subnetName` can be supplied.
     * @default SubnetType.Private
     */
    void setSubnetsToUse(final software.amazon.awscdk.services.ec2.SubnetType value);

    /**
     * @return a {@link Builder} of {@link VpcPlacementStrategy}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcPlacementStrategy}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _subnetName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetType _subnetsToUse;

        /**
         * Sets the value of SubnetName
         * @param value Place the instances in the subnets with the given name

(This is the name supplied in subnetConfiguration).

At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @return {@code this}
         */
        public Builder withSubnetName(@javax.annotation.Nullable final java.lang.String value) {
            this._subnetName = value;
            return this;
        }
        /**
         * Sets the value of SubnetsToUse
         * @param value Place the instances in the subnets of the given type

At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @return {@code this}
         */
        public Builder withSubnetsToUse(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetType value) {
            this._subnetsToUse = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcPlacementStrategy}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcPlacementStrategy build() {
            return new VpcPlacementStrategy() {
                @javax.annotation.Nullable
                private java.lang.String $subnetName = _subnetName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.SubnetType $subnetsToUse = _subnetsToUse;

                @Override
                public java.lang.String getSubnetName() {
                    return this.$subnetName;
                }

                @Override
                public void setSubnetName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$subnetName = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetType getSubnetsToUse() {
                    return this.$subnetsToUse;
                }

                @Override
                public void setSubnetsToUse(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetType value) {
                    this.$subnetsToUse = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcPlacementStrategy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Place the instances in the subnets with the given name
         * 
         * (This is the name supplied in subnetConfiguration).
         * 
         * At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @default name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getSubnetName() {
            return this.jsiiGet("subnetName", java.lang.String.class);
        }

        /**
         * Place the instances in the subnets with the given name
         * 
         * (This is the name supplied in subnetConfiguration).
         * 
         * At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @default name
         */
        @Override
        public void setSubnetName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("subnetName", value);
        }

        /**
         * Place the instances in the subnets of the given type
         * 
         * At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @default SubnetType.Private
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetsToUse() {
            return this.jsiiGet("subnetsToUse", software.amazon.awscdk.services.ec2.SubnetType.class);
        }

        /**
         * Place the instances in the subnets of the given type
         * 
         * At most one of `subnetsToUse` and `subnetName` can be supplied.
         * @default SubnetType.Private
         */
        @Override
        public void setSubnetsToUse(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetType value) {
            this.jsiiSet("subnetsToUse", value);
        }
    }
}
