package software.amazon.awscdk.services.ec2;

/**
 * VpcNetwork deploys an AWS VPC, with public and private subnets per Availability Zone.
 * For example:
 * 
 * import { VpcNetwork } from '@aws-cdk/aws-ec2'
 * 
 * const vpc = new VpcNetwork(this, {
 *    cidr: "10.0.0.0/16"
 * })
 * 
 * // Iterate the public subnets
 * for (let subnet of vpc.publicSubnets) {
 * 
 * }
 * 
 * // Iterate the private subnets
 * for (let subnet of vpc.privateSubnets) {
 * 
 * }
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:13:17.970Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcNetwork")
public class VpcNetwork extends software.amazon.awscdk.services.ec2.VpcNetworkBase {
    protected VpcNetwork(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_CIDR_RANGE", java.lang.String.class);
        DEFAULT_SUBNETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_SUBNETS", java.util.List.class);
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region.
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcNetworkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region.
     * It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone.
     * Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway.
     * Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * Import an exported VPC
     */
    public static software.amazon.awscdk.services.ec2.IVpcNetwork import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcNetworkImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.VpcNetwork.class, "import", software.amazon.awscdk.services.ec2.IVpcNetwork.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import an existing VPC from context
     */
    public static software.amazon.awscdk.services.ec2.IVpcNetwork importFromContext(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcNetworkProviderProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.VpcNetwork.class, "importFromContext", software.amazon.awscdk.services.ec2.IVpcNetwork.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Export this VPC from the stack
     */
    @Override
    public software.amazon.awscdk.services.ec2.VpcNetworkImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.ec2.VpcNetworkImportProps.class);
    }
    /**
     * The default CIDR range used when creating VPCs.
     * This can be overridden using VpcNetworkProps when creating a VPCNetwork resource.
     * e.g. new VpcResource(this, { cidr: '192.168.0.0./16' })
     */
    public final static java.lang.String DEFAULT_CIDR_RANGE;
    /**
     * The default subnet configuration
     * 
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * AZs for this VPC
     */
    @Override
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * @return The IPv4 CidrBlock as returned by the VPC
     */
    public java.lang.String getCidr() {
        return this.jsiiGet("cidr", java.lang.String.class);
    }

    /**
     * List of isolated subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     * Identifier for this VPC
     */
    @Override
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }
}
