package software.amazon.awscdk.services.ec2;

/**
 * Properties for looking up an existing VPC.
 * 
 * The combination of properties must specify filter down to exactly one
 * non-default VPC, otherwise an error is raised.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:13:17.976Z")
public interface VpcNetworkProviderProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to match the default VPC
     * @default Don't care whether we return the default VPC
     */
    java.lang.Boolean getIsDefault();
    /**
     * Whether to match the default VPC
     * @default Don't care whether we return the default VPC
     */
    void setIsDefault(final java.lang.Boolean value);
    /**
     * Tags on the VPC
     * 
     * The VPC must have all of these tags
     * @default Don't filter on tags
     */
    java.util.Map<java.lang.String, java.lang.String> getTags();
    /**
     * Tags on the VPC
     * 
     * The VPC must have all of these tags
     * @default Don't filter on tags
     */
    void setTags(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * The ID of the VPC
     * 
     * If given, will import exactly this VPC.
     * @default Don't filter on vpcId
     */
    java.lang.String getVpcId();
    /**
     * The ID of the VPC
     * 
     * If given, will import exactly this VPC.
     * @default Don't filter on vpcId
     */
    void setVpcId(final java.lang.String value);
    /**
     * The name of the VPC
     * 
     * If given, will import the VPC with this name.
     * @default Don't filter on vpcName
     */
    java.lang.String getVpcName();
    /**
     * The name of the VPC
     * 
     * If given, will import the VPC with this name.
     * @default Don't filter on vpcName
     */
    void setVpcName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link VpcNetworkProviderProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcNetworkProviderProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _isDefault;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _tags;
        @javax.annotation.Nullable
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.lang.String _vpcName;

        /**
         * Sets the value of IsDefault
         * @param value Whether to match the default VPC
         * @return {@code this}
         */
        public Builder withIsDefault(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._isDefault = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value Tags on the VPC

The VPC must have all of these tags
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._tags = value;
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value The ID of the VPC

If given, will import exactly this VPC.
         * @return {@code this}
         */
        public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcId = value;
            return this;
        }
        /**
         * Sets the value of VpcName
         * @param value The name of the VPC

If given, will import the VPC with this name.
         * @return {@code this}
         */
        public Builder withVpcName(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcNetworkProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcNetworkProviderProps build() {
            return new VpcNetworkProviderProps() {
                @javax.annotation.Nullable
                private java.lang.Boolean $isDefault = _isDefault;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $tags = _tags;
                @javax.annotation.Nullable
                private java.lang.String $vpcId = _vpcId;
                @javax.annotation.Nullable
                private java.lang.String $vpcName = _vpcName;

                @Override
                public java.lang.Boolean getIsDefault() {
                    return this.$isDefault;
                }

                @Override
                public void setIsDefault(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$isDefault = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getTags() {
                    return this.$tags;
                }

                @Override
                public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$tags = value;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
                    this.$vpcId = value;
                }

                @Override
                public java.lang.String getVpcName() {
                    return this.$vpcName;
                }

                @Override
                public void setVpcName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$vpcName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcNetworkProviderProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to match the default VPC
         * @default Don't care whether we return the default VPC
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIsDefault() {
            return this.jsiiGet("isDefault", java.lang.Boolean.class);
        }

        /**
         * Whether to match the default VPC
         * @default Don't care whether we return the default VPC
         */
        @Override
        public void setIsDefault(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("isDefault", value);
        }

        /**
         * Tags on the VPC
         * 
         * The VPC must have all of these tags
         * @default Don't filter on tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.jsiiGet("tags", java.util.Map.class);
        }

        /**
         * Tags on the VPC
         * 
         * The VPC must have all of these tags
         * @default Don't filter on tags
         */
        @Override
        public void setTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("tags", value);
        }

        /**
         * The ID of the VPC
         * 
         * If given, will import exactly this VPC.
         * @default Don't filter on vpcId
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * The ID of the VPC
         * 
         * If given, will import exactly this VPC.
         * @default Don't filter on vpcId
         */
        @Override
        public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("vpcId", value);
        }

        /**
         * The name of the VPC
         * 
         * If given, will import the VPC with this name.
         * @default Don't filter on vpcName
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcName() {
            return this.jsiiGet("vpcName", java.lang.String.class);
        }

        /**
         * The name of the VPC
         * 
         * If given, will import the VPC with this name.
         * @default Don't filter on vpcName
         */
        @Override
        public void setVpcName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("vpcName", value);
        }
    }
}
