package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T16:57:55.728Z")
public interface SecurityGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The VPC in which to create the security group.
     */
    software.amazon.awscdk.services.ec2.IVpcNetwork getVpc();
    /**
     * The VPC in which to create the security group.
     */
    void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value);
    /**
     * Whether to allow all outbound traffic by default.
     * 
     * If this is set to true, there will only be a single egress rule which allows all
     * outbound traffic. If this is set to false, no outbound traffic will be allowed by
     * default and all egress traffic must be explicitly authorized.
     * @default true
     */
    java.lang.Boolean getAllowAllOutbound();
    /**
     * Whether to allow all outbound traffic by default.
     * 
     * If this is set to true, there will only be a single egress rule which allows all
     * outbound traffic. If this is set to false, no outbound traffic will be allowed by
     * default and all egress traffic must be explicitly authorized.
     * @default true
     */
    void setAllowAllOutbound(final java.lang.Boolean value);
    /**
     * A description of the security group.
     * @default The default name will be the construct's CDK path.
     */
    java.lang.String getDescription();
    /**
     * A description of the security group.
     * @default The default name will be the construct's CDK path.
     */
    void setDescription(final java.lang.String value);
    /**
     * The name of the security group. For valid values, see the GroupName
     * parameter of the CreateSecurityGroup action in the Amazon EC2 API
     * Reference.
     * 
     * It is not recommended to use an explicit group name.
     * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
     */
    java.lang.String getGroupName();
    /**
     * The name of the security group. For valid values, see the GroupName
     * parameter of the CreateSecurityGroup action in the Amazon EC2 API
     * Reference.
     * 
     * It is not recommended to use an explicit group name.
     * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
     */
    void setGroupName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link SecurityGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SecurityGroupProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _allowAllOutbound;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _groupName;

        /**
         * Sets the value of Vpc
         * @param value The VPC in which to create the security group.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of AllowAllOutbound
         * @param value Whether to allow all outbound traffic by default.

If this is set to true, there will only be a single egress rule which allows all
outbound traffic. If this is set to false, no outbound traffic will be allowed by
default and all egress traffic must be explicitly authorized.
         * @return {@code this}
         */
        public Builder withAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the security group.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of GroupName
         * @param value The name of the security group. For valid values, see the GroupName
parameter of the CreateSecurityGroup action in the Amazon EC2 API
Reference.

It is not recommended to use an explicit group name.
         * @return {@code this}
         */
        public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._groupName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SecurityGroupProps build() {
            return new SecurityGroupProps() {
                private software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $allowAllOutbound = _allowAllOutbound;
                @javax.annotation.Nullable
                private java.lang.String $description = _description;
                @javax.annotation.Nullable
                private java.lang.String $groupName = _groupName;

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public void setAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$allowAllOutbound = value;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                    this.$description = value;
                }

                @Override
                public java.lang.String getGroupName() {
                    return this.$groupName;
                }

                @Override
                public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$groupName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SecurityGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC in which to create the security group.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * The VPC in which to create the security group.
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * Whether to allow all outbound traffic by default.
         * 
         * If this is set to true, there will only be a single egress rule which allows all
         * outbound traffic. If this is set to false, no outbound traffic will be allowed by
         * default and all egress traffic must be explicitly authorized.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }

        /**
         * Whether to allow all outbound traffic by default.
         * 
         * If this is set to true, there will only be a single egress rule which allows all
         * outbound traffic. If this is set to false, no outbound traffic will be allowed by
         * default and all egress traffic must be explicitly authorized.
         * @default true
         */
        @Override
        public void setAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("allowAllOutbound", value);
        }

        /**
         * A description of the security group.
         * @default The default name will be the construct's CDK path.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A description of the security group.
         * @default The default name will be the construct's CDK path.
         */
        @Override
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }

        /**
         * The name of the security group. For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * 
         * It is not recommended to use an explicit group name.
         * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }

        /**
         * The name of the security group. For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * 
         * It is not recommended to use an explicit group name.
         * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
         */
        @Override
        public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupName", value);
        }
    }
}
