package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a VPC subnet
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T16:57:55.740Z")
public interface VpcSubnetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The availability zone for the subnet
     */
    java.lang.String getAvailabilityZone();
    /**
     * The availability zone for the subnet
     */
    void setAvailabilityZone(final java.lang.String value);
    /**
     * The CIDR notation for this subnet
     */
    java.lang.String getCidrBlock();
    /**
     * The CIDR notation for this subnet
     */
    void setCidrBlock(final java.lang.String value);
    /**
     * The VPC which this subnet is part of
     */
    java.lang.String getVpcId();
    /**
     * The VPC which this subnet is part of
     */
    void setVpcId(final java.lang.String value);
    /**
     * Controls if a public IP is associated to an instance at launch
     * 
     * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    java.lang.Boolean getMapPublicIpOnLaunch();
    /**
     * Controls if a public IP is associated to an instance at launch
     * 
     * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    void setMapPublicIpOnLaunch(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link VpcSubnetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcSubnetProps}
     */
    final class Builder {
        private java.lang.String _availabilityZone;
        private java.lang.String _cidrBlock;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.lang.Boolean _mapPublicIpOnLaunch;

        /**
         * Sets the value of AvailabilityZone
         * @param value The availability zone for the subnet
         * @return {@code this}
         */
        public Builder withAvailabilityZone(final java.lang.String value) {
            this._availabilityZone = java.util.Objects.requireNonNull(value, "availabilityZone is required");
            return this;
        }
        /**
         * Sets the value of CidrBlock
         * @param value The CIDR notation for this subnet
         * @return {@code this}
         */
        public Builder withCidrBlock(final java.lang.String value) {
            this._cidrBlock = java.util.Objects.requireNonNull(value, "cidrBlock is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value The VPC which this subnet is part of
         * @return {@code this}
         */
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of MapPublicIpOnLaunch
         * @param value Controls if a public IP is associated to an instance at launch

Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         * @return {@code this}
         */
        public Builder withMapPublicIpOnLaunch(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._mapPublicIpOnLaunch = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcSubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcSubnetProps build() {
            return new VpcSubnetProps() {
                private java.lang.String $availabilityZone = java.util.Objects.requireNonNull(_availabilityZone, "availabilityZone is required");
                private java.lang.String $cidrBlock = java.util.Objects.requireNonNull(_cidrBlock, "cidrBlock is required");
                private java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $mapPublicIpOnLaunch = _mapPublicIpOnLaunch;

                @Override
                public java.lang.String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public void setAvailabilityZone(final java.lang.String value) {
                    this.$availabilityZone = java.util.Objects.requireNonNull(value, "availabilityZone is required");
                }

                @Override
                public java.lang.String getCidrBlock() {
                    return this.$cidrBlock;
                }

                @Override
                public void setCidrBlock(final java.lang.String value) {
                    this.$cidrBlock = java.util.Objects.requireNonNull(value, "cidrBlock is required");
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public void setVpcId(final java.lang.String value) {
                    this.$vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
                }

                @Override
                public java.lang.Boolean getMapPublicIpOnLaunch() {
                    return this.$mapPublicIpOnLaunch;
                }

                @Override
                public void setMapPublicIpOnLaunch(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$mapPublicIpOnLaunch = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcSubnetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The availability zone for the subnet
         */
        @Override
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }

        /**
         * The availability zone for the subnet
         */
        @Override
        public void setAvailabilityZone(final java.lang.String value) {
            this.jsiiSet("availabilityZone", java.util.Objects.requireNonNull(value, "availabilityZone is required"));
        }

        /**
         * The CIDR notation for this subnet
         */
        @Override
        public java.lang.String getCidrBlock() {
            return this.jsiiGet("cidrBlock", java.lang.String.class);
        }

        /**
         * The CIDR notation for this subnet
         */
        @Override
        public void setCidrBlock(final java.lang.String value) {
            this.jsiiSet("cidrBlock", java.util.Objects.requireNonNull(value, "cidrBlock is required"));
        }

        /**
         * The VPC which this subnet is part of
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * The VPC which this subnet is part of
         */
        @Override
        public void setVpcId(final java.lang.String value) {
            this.jsiiSet("vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
        }

        /**
         * Controls if a public IP is associated to an instance at launch
         * 
         * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getMapPublicIpOnLaunch() {
            return this.jsiiGet("mapPublicIpOnLaunch", java.lang.Boolean.class);
        }

        /**
         * Controls if a public IP is associated to an instance at launch
         * 
         * Defaults to true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         */
        @Override
        public void setMapPublicIpOnLaunch(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("mapPublicIpOnLaunch", value);
        }
    }
}
