package software.amazon.awscdk.services.ec2;

/**
 * A new or imported VPC
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:09:23.020Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcNetworkBase")
public abstract class VpcNetworkBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.ec2.IVpcNetwork {
    protected VpcNetworkBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Export this VPC from the stack
     */
    @Override
    public abstract software.amazon.awscdk.services.ec2.VpcNetworkImportProps export();

    /**
     * Return whether the given subnet is one of this VPC's public subnets.
     * 
     * The subnet must literally be one of the subnet object obtained from
     * this VPC. A subnet that merely represents the same subnet will
     * never return true.
     */
    @Override
    public java.lang.Boolean isPublicSubnet(final software.amazon.awscdk.services.ec2.IVpcSubnet subnet) {
        return this.jsiiCall("isPublicSubnet", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(subnet, "subnet is required")).toArray());
    }

    /**
     * Return the subnets appropriate for the placement strategy
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy placement) {
        return this.jsiiCall("subnets", java.util.List.class, java.util.stream.Stream.of(placement).toArray());
    }

    /**
     * Return the subnets appropriate for the placement strategy
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets() {
        return this.jsiiCall("subnets", java.util.List.class);
    }

    /**
     * AZs for this VPC
     */
    @Override
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * Dependencies for internet connectivity
     */
    public java.util.List<software.amazon.awscdk.IConstruct> getInternetDependencies() {
        return this.jsiiGet("internetDependencies", java.util.List.class);
    }

    /**
     * List of isolated subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * Dependencies for NAT connectivity
     */
    public java.util.List<software.amazon.awscdk.IConstruct> getNatDependencies() {
        return this.jsiiGet("natDependencies", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC
     */
    @Override
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     * Identifier for this VPC
     */
    @Override
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * The region where this VPC is defined
     */
    @Override
    public java.lang.String getVpcRegion() {
        return this.jsiiGet("vpcRegion", java.lang.String.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.ec2.VpcNetworkBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * AZs for this VPC
         */
        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * List of isolated subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
            return this.jsiiGet("isolatedSubnets", java.util.List.class);
        }

        /**
         * List of private subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
            return this.jsiiGet("privateSubnets", java.util.List.class);
        }

        /**
         * List of public subnets in this VPC
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
            return this.jsiiGet("publicSubnets", java.util.List.class);
        }

        /**
         * Identifier for this VPC
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * Region where this VPC is located
         */
        @Override
        public java.lang.String getVpcRegion() {
            return this.jsiiGet("vpcRegion", java.lang.String.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Exports this VPC so it can be consumed by another stack.
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.ec2.VpcNetworkImportProps.class);
        }

        /**
         * Return whether the given subnet is one of this VPC's public subnets.
         * 
         * The subnet must literally be one of the subnet object obtained from
         * this VPC. A subnet that merely represents the same subnet will
         * never return true.
         */
        @Override
        public java.lang.Boolean isPublicSubnet(final software.amazon.awscdk.services.ec2.IVpcSubnet subnet) {
            return this.jsiiCall("isPublicSubnet", java.lang.Boolean.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(subnet, "subnet is required")).toArray());
        }

        /**
         * Return the subnets appropriate for the placement strategy
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy placement) {
            return this.jsiiCall("subnets", java.util.List.class, java.util.stream.Stream.of(placement).toArray());
        }

        /**
         * Return the subnets appropriate for the placement strategy
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> subnets() {
            return this.jsiiCall("subnets", java.util.List.class);
        }
    }
}
