package software.amazon.awscdk.services.ec2;

/**
 * @cloudformationResource AWS::EC2::SecurityGroup
 * A CloudFormation `AWS::EC2::SecurityGroup`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:57:55.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroup")
public class CfnSecurityGroup extends software.amazon.awscdk.CfnResource {
    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroup.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnSecurityGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnSecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.ec2.CfnSecurityGroupProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.class);
    }

    /**
     * @cloudformationAttribute GroupId
     */
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    public java.lang.String getSecurityGroupName() {
        return this.jsiiGet("securityGroupName", java.lang.String.class);
    }

    /**
     * @cloudformationAttribute VpcId
     */
    public java.lang.String getSecurityGroupVpcId() {
        return this.jsiiGet("securityGroupVpcId", java.lang.String.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.String getIpProtocol();
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.String getCidrIp();
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.String getCidrIpv6();
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.String getDescription();
        /**
         * `CfnSecurityGroup.EgressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        java.lang.String getDestinationPrefixListId();
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        void setDestinationPrefixListId(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        java.lang.String getDestinationSecurityGroupId();
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        void setDestinationSecurityGroupId(final java.lang.String value);
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EgressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EgressProperty}
         */
        final class Builder {
            private java.lang.String _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.String _cidrIp;
            @javax.annotation.Nullable
            private java.lang.String _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.String _destinationPrefixListId;
            @javax.annotation.Nullable
            private java.lang.String _destinationSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.Object _fromPort;
            @javax.annotation.Nullable
            private java.lang.Object _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value `CfnSecurityGroup.EgressProperty.IpProtocol`
             * @return {@code this}
             */
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value `CfnSecurityGroup.EgressProperty.CidrIp`
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value `CfnSecurityGroup.EgressProperty.CidrIpv6`
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSecurityGroup.EgressProperty.Description`
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DestinationPrefixListId
             * @param value `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
             * @return {@code this}
             */
            public Builder withDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationPrefixListId = value;
                return this;
            }
            /**
             * Sets the value of DestinationSecurityGroupId
             * @param value `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
             * @return {@code this}
             */
            public Builder withDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._destinationSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.EgressProperty.FromPort`
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.EgressProperty.FromPort`
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.EgressProperty.ToPort`
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.EgressProperty.ToPort`
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EgressProperty build() {
                return new EgressProperty() {
                    private java.lang.String $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private java.lang.String $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private java.lang.String $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.String $destinationPrefixListId = _destinationPrefixListId;
                    @javax.annotation.Nullable
                    private java.lang.String $destinationSecurityGroupId = _destinationSecurityGroupId;
                    @javax.annotation.Nullable
                    private java.lang.Object $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private java.lang.Object $toPort = _toPort;

                    @Override
                    public java.lang.String getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public void setIpProtocol(final java.lang.String value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public java.lang.String getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public java.lang.String getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.String getDestinationPrefixListId() {
                        return this.$destinationPrefixListId;
                    }

                    @Override
                    public void setDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationPrefixListId = value;
                    }

                    @Override
                    public java.lang.String getDestinationSecurityGroupId() {
                        return this.$destinationSecurityGroupId;
                    }

                    @Override
                    public void setDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$destinationSecurityGroupId = value;
                    }

                    @Override
                    public java.lang.Object getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public java.lang.Object getToPort() {
                        return this.$toPort;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$toPort = value;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$toPort = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.IpProtocol`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public java.lang.String getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.IpProtocol`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIp`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIp`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIpv6`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.CidrIpv6`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.Description`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.Description`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDestinationPrefixListId() {
                return this.jsiiGet("destinationPrefixListId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
             */
            @Override
            public void setDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationPrefixListId", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDestinationSecurityGroupId() {
                return this.jsiiGet("destinationSecurityGroupId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
             */
            @Override
            public void setDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("destinationSecurityGroupId", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }

            /**
             * `CfnSecurityGroup.EgressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        java.lang.String getIpProtocol();
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        void setIpProtocol(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        java.lang.String getCidrIp();
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        void setCidrIp(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        java.lang.String getCidrIpv6();
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        void setCidrIpv6(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        java.lang.String getDescription();
        /**
         * `CfnSecurityGroup.IngressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        void setDescription(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        java.lang.Object getFromPort();
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final java.lang.Number value);
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        void setFromPort(final software.amazon.awscdk.Token value);
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        java.lang.String getSourcePrefixListId();
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        void setSourcePrefixListId(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        java.lang.String getSourceSecurityGroupId();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        void setSourceSecurityGroupId(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        java.lang.String getSourceSecurityGroupName();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        void setSourceSecurityGroupName(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        java.lang.String getSourceSecurityGroupOwnerId();
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        void setSourceSecurityGroupOwnerId(final java.lang.String value);
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        java.lang.Object getToPort();
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final java.lang.Number value);
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        void setToPort(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IngressProperty}
         */
        final class Builder {
            private java.lang.String _ipProtocol;
            @javax.annotation.Nullable
            private java.lang.String _cidrIp;
            @javax.annotation.Nullable
            private java.lang.String _cidrIpv6;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _fromPort;
            @javax.annotation.Nullable
            private java.lang.String _sourcePrefixListId;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupId;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupName;
            @javax.annotation.Nullable
            private java.lang.String _sourceSecurityGroupOwnerId;
            @javax.annotation.Nullable
            private java.lang.Object _toPort;

            /**
             * Sets the value of IpProtocol
             * @param value `CfnSecurityGroup.IngressProperty.IpProtocol`
             * @return {@code this}
             */
            public Builder withIpProtocol(final java.lang.String value) {
                this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                return this;
            }
            /**
             * Sets the value of CidrIp
             * @param value `CfnSecurityGroup.IngressProperty.CidrIp`
             * @return {@code this}
             */
            public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIp = value;
                return this;
            }
            /**
             * Sets the value of CidrIpv6
             * @param value `CfnSecurityGroup.IngressProperty.CidrIpv6`
             * @return {@code this}
             */
            public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this._cidrIpv6 = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSecurityGroup.IngressProperty.Description`
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.IngressProperty.FromPort`
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of FromPort
             * @param value `CfnSecurityGroup.IngressProperty.FromPort`
             * @return {@code this}
             */
            public Builder withFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fromPort = value;
                return this;
            }
            /**
             * Sets the value of SourcePrefixListId
             * @param value `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
             * @return {@code this}
             */
            public Builder withSourcePrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourcePrefixListId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupId
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupId = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupName
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupName = value;
                return this;
            }
            /**
             * Sets the value of SourceSecurityGroupOwnerId
             * @param value `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
             * @return {@code this}
             */
            public Builder withSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceSecurityGroupOwnerId = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.IngressProperty.ToPort`
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this._toPort = value;
                return this;
            }
            /**
             * Sets the value of ToPort
             * @param value `CfnSecurityGroup.IngressProperty.ToPort`
             * @return {@code this}
             */
            public Builder withToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._toPort = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IngressProperty build() {
                return new IngressProperty() {
                    private java.lang.String $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                    @javax.annotation.Nullable
                    private java.lang.String $cidrIp = _cidrIp;
                    @javax.annotation.Nullable
                    private java.lang.String $cidrIpv6 = _cidrIpv6;
                    @javax.annotation.Nullable
                    private java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $fromPort = _fromPort;
                    @javax.annotation.Nullable
                    private java.lang.String $sourcePrefixListId = _sourcePrefixListId;
                    @javax.annotation.Nullable
                    private java.lang.String $sourceSecurityGroupId = _sourceSecurityGroupId;
                    @javax.annotation.Nullable
                    private java.lang.String $sourceSecurityGroupName = _sourceSecurityGroupName;
                    @javax.annotation.Nullable
                    private java.lang.String $sourceSecurityGroupOwnerId = _sourceSecurityGroupOwnerId;
                    @javax.annotation.Nullable
                    private java.lang.Object $toPort = _toPort;

                    @Override
                    public java.lang.String getIpProtocol() {
                        return this.$ipProtocol;
                    }

                    @Override
                    public void setIpProtocol(final java.lang.String value) {
                        this.$ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
                    }

                    @Override
                    public java.lang.String getCidrIp() {
                        return this.$cidrIp;
                    }

                    @Override
                    public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIp = value;
                    }

                    @Override
                    public java.lang.String getCidrIpv6() {
                        return this.$cidrIpv6;
                    }

                    @Override
                    public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cidrIpv6 = value;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getFromPort() {
                        return this.$fromPort;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$fromPort = value;
                    }

                    @Override
                    public java.lang.String getSourcePrefixListId() {
                        return this.$sourcePrefixListId;
                    }

                    @Override
                    public void setSourcePrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourcePrefixListId = value;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupId() {
                        return this.$sourceSecurityGroupId;
                    }

                    @Override
                    public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupId = value;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupName() {
                        return this.$sourceSecurityGroupName;
                    }

                    @Override
                    public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupName = value;
                    }

                    @Override
                    public java.lang.String getSourceSecurityGroupOwnerId() {
                        return this.$sourceSecurityGroupOwnerId;
                    }

                    @Override
                    public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceSecurityGroupOwnerId = value;
                    }

                    @Override
                    public java.lang.Object getToPort() {
                        return this.$toPort;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$toPort = value;
                    }

                    @Override
                    public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$toPort = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.IpProtocol`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public java.lang.String getIpProtocol() {
                return this.jsiiGet("ipProtocol", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.IpProtocol`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
             */
            @Override
            public void setIpProtocol(final java.lang.String value) {
                this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIp`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCidrIp() {
                return this.jsiiGet("cidrIp", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIp`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
             */
            @Override
            public void setCidrIp(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIp", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIpv6`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCidrIpv6() {
                return this.jsiiGet("cidrIpv6", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.CidrIpv6`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
             */
            @Override
            public void setCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cidrIpv6", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.Description`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.Description`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFromPort() {
                return this.jsiiGet("fromPort", java.lang.Object.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.FromPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
             */
            @Override
            public void setFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fromPort", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSourcePrefixListId() {
                return this.jsiiGet("sourcePrefixListId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
             */
            @Override
            public void setSourcePrefixListId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourcePrefixListId", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupId() {
                return this.jsiiGet("sourceSecurityGroupId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
             */
            @Override
            public void setSourceSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupId", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupName() {
                return this.jsiiGet("sourceSecurityGroupName", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
             */
            @Override
            public void setSourceSecurityGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupName", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSourceSecurityGroupOwnerId() {
                return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.String.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
             */
            @Override
            public void setSourceSecurityGroupOwnerId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceSecurityGroupOwnerId", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getToPort() {
                return this.jsiiGet("toPort", java.lang.Object.class);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("toPort", value);
            }

            /**
             * `CfnSecurityGroup.IngressProperty.ToPort`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
             */
            @Override
            public void setToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("toPort", value);
            }
        }
    }
}
