package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:57:55.147Z")
public interface VpnConnectionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.VpnConnectionOptions {
    /**
     * The VPC to connect to.
     */
    software.amazon.awscdk.services.ec2.IVpcNetwork getVpc();
    /**
     * The VPC to connect to.
     */
    void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value);

    /**
     * @return a {@link Builder} of {@link VpnConnectionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpnConnectionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        private java.lang.String _ip;
        @javax.annotation.Nullable
        private java.lang.Number _asn;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _staticRoutes;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> _tunnelOptions;

        /**
         * Sets the value of Vpc
         * @param value The VPC to connect to.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of Ip
         * @param value The ip address of the customer gateway.
         * @return {@code this}
         */
        public Builder withIp(final java.lang.String value) {
            this._ip = java.util.Objects.requireNonNull(value, "ip is required");
            return this;
        }
        /**
         * Sets the value of Asn
         * @param value The ASN of the customer gateway.
         * @return {@code this}
         */
        public Builder withAsn(@javax.annotation.Nullable final java.lang.Number value) {
            this._asn = value;
            return this;
        }
        /**
         * Sets the value of StaticRoutes
         * @param value The static routes to be routed from the VPN gateway to the customer gateway.
         * @return {@code this}
         */
        public Builder withStaticRoutes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._staticRoutes = value;
            return this;
        }
        /**
         * Sets the value of TunnelOptions
         * @param value The tunnel options for the VPN connection. At most two elements (one per tunnel).
Duplicates not allowed.
         * @return {@code this}
         */
        public Builder withTunnelOptions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> value) {
            this._tunnelOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpnConnectionProps build() {
            return new VpnConnectionProps() {
                private software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                private java.lang.String $ip = java.util.Objects.requireNonNull(_ip, "ip is required");
                @javax.annotation.Nullable
                private java.lang.Number $asn = _asn;
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $staticRoutes = _staticRoutes;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> $tunnelOptions = _tunnelOptions;

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.String getIp() {
                    return this.$ip;
                }

                @Override
                public void setIp(final java.lang.String value) {
                    this.$ip = java.util.Objects.requireNonNull(value, "ip is required");
                }

                @Override
                public java.lang.Number getAsn() {
                    return this.$asn;
                }

                @Override
                public void setAsn(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$asn = value;
                }

                @Override
                public java.util.List<java.lang.String> getStaticRoutes() {
                    return this.$staticRoutes;
                }

                @Override
                public void setStaticRoutes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$staticRoutes = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
                    return this.$tunnelOptions;
                }

                @Override
                public void setTunnelOptions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> value) {
                    this.$tunnelOptions = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpnConnectionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC to connect to.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * The VPC to connect to.
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * The ip address of the customer gateway.
         */
        @Override
        public java.lang.String getIp() {
            return this.jsiiGet("ip", java.lang.String.class);
        }

        /**
         * The ip address of the customer gateway.
         */
        @Override
        public void setIp(final java.lang.String value) {
            this.jsiiSet("ip", java.util.Objects.requireNonNull(value, "ip is required"));
        }

        /**
         * The ASN of the customer gateway.
         * @default 65000
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getAsn() {
            return this.jsiiGet("asn", java.lang.Number.class);
        }

        /**
         * The ASN of the customer gateway.
         * @default 65000
         */
        @Override
        public void setAsn(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("asn", value);
        }

        /**
         * The static routes to be routed from the VPN gateway to the customer gateway.
         * @default Dynamic routing (BGP)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getStaticRoutes() {
            return this.jsiiGet("staticRoutes", java.util.List.class);
        }

        /**
         * The static routes to be routed from the VPN gateway to the customer gateway.
         * @default Dynamic routing (BGP)
         */
        @Override
        public void setStaticRoutes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("staticRoutes", value);
        }

        /**
         * The tunnel options for the VPN connection. At most two elements (one per tunnel).
         * Duplicates not allowed.
         * @default Amazon generated tunnel options
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
            return this.jsiiGet("tunnelOptions", java.util.List.class);
        }

        /**
         * The tunnel options for the VPN connection. At most two elements (one per tunnel).
         * Duplicates not allowed.
         * @default Amazon generated tunnel options
         */
        @Override
        public void setTunnelOptions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> value) {
            this.jsiiSet("tunnelOptions", value);
        }
    }
}
