package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:57:55.148Z")
public interface VpnTunnelOption extends software.amazon.jsii.JsiiSerializable {
    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual
     * private gateway and customer gateway. Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     * @default an Amazon generated pre-shared key
     */
    java.lang.String getPreSharedKey();
    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual
     * private gateway and customer gateway. Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     * @default an Amazon generated pre-shared key
     */
    void setPreSharedKey(final java.lang.String value);
    /**
     * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     * @default an Amazon generated inside IP CIDR
     */
    java.lang.String getTunnelInsideCidr();
    /**
     * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     * @default an Amazon generated inside IP CIDR
     */
    void setTunnelInsideCidr(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link VpnTunnelOption}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpnTunnelOption}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _preSharedKey;
        @javax.annotation.Nullable
        private java.lang.String _tunnelInsideCidr;

        /**
         * Sets the value of PreSharedKey
         * @param value The pre-shared key (PSK) to establish initial authentication between the virtual
private gateway and customer gateway. Allowed characters are alphanumeric characters
and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
         * @return {@code this}
         */
        public Builder withPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
            this._preSharedKey = value;
            return this;
        }
        /**
         * Sets the value of TunnelInsideCidr
         * @param value The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be
unique across all VPN connections that use the same virtual private gateway.
A size /30 CIDR block from the 169.254.0.0/16 range.
         * @return {@code this}
         */
        public Builder withTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
            this._tunnelInsideCidr = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnTunnelOption}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpnTunnelOption build() {
            return new VpnTunnelOption() {
                @javax.annotation.Nullable
                private java.lang.String $preSharedKey = _preSharedKey;
                @javax.annotation.Nullable
                private java.lang.String $tunnelInsideCidr = _tunnelInsideCidr;

                @Override
                public java.lang.String getPreSharedKey() {
                    return this.$preSharedKey;
                }

                @Override
                public void setPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
                    this.$preSharedKey = value;
                }

                @Override
                public java.lang.String getTunnelInsideCidr() {
                    return this.$tunnelInsideCidr;
                }

                @Override
                public void setTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
                    this.$tunnelInsideCidr = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpnTunnelOption {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual
         * private gateway and customer gateway. Allowed characters are alphanumeric characters
         * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
         * @default an Amazon generated pre-shared key
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPreSharedKey() {
            return this.jsiiGet("preSharedKey", java.lang.String.class);
        }

        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual
         * private gateway and customer gateway. Allowed characters are alphanumeric characters
         * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
         * @default an Amazon generated pre-shared key
         */
        @Override
        public void setPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("preSharedKey", value);
        }

        /**
         * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be
         * unique across all VPN connections that use the same virtual private gateway.
         * A size /30 CIDR block from the 169.254.0.0/16 range.
         * @default an Amazon generated inside IP CIDR
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTunnelInsideCidr() {
            return this.jsiiGet("tunnelInsideCidr", java.lang.String.class);
        }

        /**
         * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be
         * unique across all VPN connections that use the same virtual private gateway.
         * A size /30 CIDR block from the 169.254.0.0/16 range.
         * @default an Amazon generated inside IP CIDR
         */
        @Override
        public void setTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("tunnelInsideCidr", value);
        }
    }
}
