/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnEC2FleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet
extends CfnResource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEC2Fleet.class, (String)"resourceTypeName", String.class);

    protected CfnEC2Fleet(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnEC2Fleet(Construct scope, String id, CfnEC2FleetProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(scope, "scope is required")), Stream.of(Objects.requireNonNull(id, "id is required"))), Stream.of(Objects.requireNonNull(props, "props is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public String getEc2FleetId() {
        return (String)this.jsiiGet("ec2FleetId", String.class);
    }

    public CfnEC2FleetProps getPropertyOverrides() {
        return (CfnEC2FleetProps)this.jsiiGet("propertyOverrides", CfnEC2FleetProps.class);
    }

    public static interface TargetCapacitySpecificationRequestProperty
    extends JsiiSerializable {
        public Object getTotalTargetCapacity();

        public void setTotalTargetCapacity(Number var1);

        public void setTotalTargetCapacity(Token var1);

        public String getDefaultTargetCapacityType();

        public void setDefaultTargetCapacityType(String var1);

        public Object getOnDemandTargetCapacity();

        public void setOnDemandTargetCapacity(Number var1);

        public void setOnDemandTargetCapacity(Token var1);

        public Object getSpotTargetCapacity();

        public void setSpotTargetCapacity(Number var1);

        public void setSpotTargetCapacity(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _totalTargetCapacity;
            @Nullable
            private String _defaultTargetCapacityType;
            @Nullable
            private Object _onDemandTargetCapacity;
            @Nullable
            private Object _spotTargetCapacity;

            public Builder withTotalTargetCapacity(Number value) {
                this._totalTargetCapacity = Objects.requireNonNull(value, "totalTargetCapacity is required");
                return this;
            }

            public Builder withTotalTargetCapacity(Token value) {
                this._totalTargetCapacity = Objects.requireNonNull(value, "totalTargetCapacity is required");
                return this;
            }

            public Builder withDefaultTargetCapacityType(@Nullable String value) {
                this._defaultTargetCapacityType = value;
                return this;
            }

            public Builder withOnDemandTargetCapacity(@Nullable Number value) {
                this._onDemandTargetCapacity = value;
                return this;
            }

            public Builder withOnDemandTargetCapacity(@Nullable Token value) {
                this._onDemandTargetCapacity = value;
                return this;
            }

            public Builder withSpotTargetCapacity(@Nullable Number value) {
                this._spotTargetCapacity = value;
                return this;
            }

            public Builder withSpotTargetCapacity(@Nullable Token value) {
                this._spotTargetCapacity = value;
                return this;
            }

            public TargetCapacitySpecificationRequestProperty build() {
                return new TargetCapacitySpecificationRequestProperty(){
                    private Object $totalTargetCapacity;
                    @Nullable
                    private String $defaultTargetCapacityType;
                    @Nullable
                    private Object $onDemandTargetCapacity;
                    @Nullable
                    private Object $spotTargetCapacity;
                    {
                        this.$totalTargetCapacity = Objects.requireNonNull(_totalTargetCapacity, "totalTargetCapacity is required");
                        this.$defaultTargetCapacityType = _defaultTargetCapacityType;
                        this.$onDemandTargetCapacity = _onDemandTargetCapacity;
                        this.$spotTargetCapacity = _spotTargetCapacity;
                    }

                    @Override
                    public Object getTotalTargetCapacity() {
                        return this.$totalTargetCapacity;
                    }

                    @Override
                    public void setTotalTargetCapacity(Number value) {
                        this.$totalTargetCapacity = Objects.requireNonNull(value, "totalTargetCapacity is required");
                    }

                    @Override
                    public void setTotalTargetCapacity(Token value) {
                        this.$totalTargetCapacity = Objects.requireNonNull(value, "totalTargetCapacity is required");
                    }

                    @Override
                    public String getDefaultTargetCapacityType() {
                        return this.$defaultTargetCapacityType;
                    }

                    @Override
                    public void setDefaultTargetCapacityType(@Nullable String value) {
                        this.$defaultTargetCapacityType = value;
                    }

                    @Override
                    public Object getOnDemandTargetCapacity() {
                        return this.$onDemandTargetCapacity;
                    }

                    @Override
                    public void setOnDemandTargetCapacity(@Nullable Number value) {
                        this.$onDemandTargetCapacity = value;
                    }

                    @Override
                    public void setOnDemandTargetCapacity(@Nullable Token value) {
                        this.$onDemandTargetCapacity = value;
                    }

                    @Override
                    public Object getSpotTargetCapacity() {
                        return this.$spotTargetCapacity;
                    }

                    @Override
                    public void setSpotTargetCapacity(@Nullable Number value) {
                        this.$spotTargetCapacity = value;
                    }

                    @Override
                    public void setSpotTargetCapacity(@Nullable Token value) {
                        this.$spotTargetCapacity = value;
                    }
                };
            }
        }
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public void setResourceType(String var1);

        public List<TagRequestProperty> getTags();

        public void setTags(List<TagRequestProperty> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _resourceType;
            @Nullable
            private List<TagRequestProperty> _tags;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withTags(@Nullable List<TagRequestProperty> value) {
                this._tags = value;
                return this;
            }

            public TagSpecificationProperty build() {
                return new TagSpecificationProperty(){
                    @Nullable
                    private String $resourceType;
                    @Nullable
                    private List<TagRequestProperty> $tags;
                    {
                        this.$resourceType = _resourceType;
                        this.$tags = _tags;
                    }

                    @Override
                    public String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public void setResourceType(@Nullable String value) {
                        this.$resourceType = value;
                    }

                    @Override
                    public List<TagRequestProperty> getTags() {
                        return this.$tags;
                    }

                    @Override
                    public void setTags(@Nullable List<TagRequestProperty> value) {
                        this.$tags = value;
                    }
                };
            }
        }
    }

    public static interface TagRequestProperty
    extends JsiiSerializable {
        public String getKey();

        public void setKey(String var1);

        public String getValue();

        public void setValue(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _key;
            @Nullable
            private String _value;

            public Builder withKey(@Nullable String value) {
                this._key = value;
                return this;
            }

            public Builder withValue(@Nullable String value) {
                this._value = value;
                return this;
            }

            public TagRequestProperty build() {
                return new TagRequestProperty(){
                    @Nullable
                    private String $key;
                    @Nullable
                    private String $value;
                    {
                        this.$key = _key;
                        this.$value = _value;
                    }

                    @Override
                    public String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@Nullable String value) {
                        this.$key = value;
                    }

                    @Override
                    public String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@Nullable String value) {
                        this.$value = value;
                    }
                };
            }
        }
    }

    public static interface SpotOptionsRequestProperty
    extends JsiiSerializable {
        public String getAllocationStrategy();

        public void setAllocationStrategy(String var1);

        public String getInstanceInterruptionBehavior();

        public void setInstanceInterruptionBehavior(String var1);

        public Object getInstancePoolsToUseCount();

        public void setInstancePoolsToUseCount(Number var1);

        public void setInstancePoolsToUseCount(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _allocationStrategy;
            @Nullable
            private String _instanceInterruptionBehavior;
            @Nullable
            private Object _instancePoolsToUseCount;

            public Builder withAllocationStrategy(@Nullable String value) {
                this._allocationStrategy = value;
                return this;
            }

            public Builder withInstanceInterruptionBehavior(@Nullable String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withInstancePoolsToUseCount(@Nullable Number value) {
                this._instancePoolsToUseCount = value;
                return this;
            }

            public Builder withInstancePoolsToUseCount(@Nullable Token value) {
                this._instancePoolsToUseCount = value;
                return this;
            }

            public SpotOptionsRequestProperty build() {
                return new SpotOptionsRequestProperty(){
                    @Nullable
                    private String $allocationStrategy;
                    @Nullable
                    private String $instanceInterruptionBehavior;
                    @Nullable
                    private Object $instancePoolsToUseCount;
                    {
                        this.$allocationStrategy = _allocationStrategy;
                        this.$instanceInterruptionBehavior = _instanceInterruptionBehavior;
                        this.$instancePoolsToUseCount = _instancePoolsToUseCount;
                    }

                    @Override
                    public String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable String value) {
                        this.$allocationStrategy = value;
                    }

                    @Override
                    public String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public void setInstanceInterruptionBehavior(@Nullable String value) {
                        this.$instanceInterruptionBehavior = value;
                    }

                    @Override
                    public Object getInstancePoolsToUseCount() {
                        return this.$instancePoolsToUseCount;
                    }

                    @Override
                    public void setInstancePoolsToUseCount(@Nullable Number value) {
                        this.$instancePoolsToUseCount = value;
                    }

                    @Override
                    public void setInstancePoolsToUseCount(@Nullable Token value) {
                        this.$instancePoolsToUseCount = value;
                    }
                };
            }
        }
    }

    public static interface OnDemandOptionsRequestProperty
    extends JsiiSerializable {
        public String getAllocationStrategy();

        public void setAllocationStrategy(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _allocationStrategy;

            public Builder withAllocationStrategy(@Nullable String value) {
                this._allocationStrategy = value;
                return this;
            }

            public OnDemandOptionsRequestProperty build() {
                return new OnDemandOptionsRequestProperty(){
                    @Nullable
                    private String $allocationStrategy;
                    {
                        this.$allocationStrategy = _allocationStrategy;
                    }

                    @Override
                    public String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public void setAllocationStrategy(@Nullable String value) {
                        this.$allocationStrategy = value;
                    }
                };
            }
        }
    }

    public static interface FleetLaunchTemplateSpecificationRequestProperty
    extends JsiiSerializable {
        public String getLaunchTemplateId();

        public void setLaunchTemplateId(String var1);

        public String getLaunchTemplateName();

        public void setLaunchTemplateName(String var1);

        public String getVersion();

        public void setVersion(String var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _launchTemplateId;
            @Nullable
            private String _launchTemplateName;
            @Nullable
            private String _version;

            public Builder withLaunchTemplateId(@Nullable String value) {
                this._launchTemplateId = value;
                return this;
            }

            public Builder withLaunchTemplateName(@Nullable String value) {
                this._launchTemplateName = value;
                return this;
            }

            public Builder withVersion(@Nullable String value) {
                this._version = value;
                return this;
            }

            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new FleetLaunchTemplateSpecificationRequestProperty(){
                    @Nullable
                    private String $launchTemplateId;
                    @Nullable
                    private String $launchTemplateName;
                    @Nullable
                    private String $version;
                    {
                        this.$launchTemplateId = _launchTemplateId;
                        this.$launchTemplateName = _launchTemplateName;
                        this.$version = _version;
                    }

                    @Override
                    public String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public void setLaunchTemplateId(@Nullable String value) {
                        this.$launchTemplateId = value;
                    }

                    @Override
                    public String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    @Override
                    public void setLaunchTemplateName(@Nullable String value) {
                        this.$launchTemplateName = value;
                    }

                    @Override
                    public String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(@Nullable String value) {
                        this.$version = value;
                    }
                };
            }
        }
    }

    public static interface FleetLaunchTemplateOverridesRequestProperty
    extends JsiiSerializable {
        public String getAvailabilityZone();

        public void setAvailabilityZone(String var1);

        public String getInstanceType();

        public void setInstanceType(String var1);

        public String getMaxPrice();

        public void setMaxPrice(String var1);

        public Object getPriority();

        public void setPriority(Number var1);

        public void setPriority(Token var1);

        public String getSubnetId();

        public void setSubnetId(String var1);

        public Object getWeightedCapacity();

        public void setWeightedCapacity(Number var1);

        public void setWeightedCapacity(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _availabilityZone;
            @Nullable
            private String _instanceType;
            @Nullable
            private String _maxPrice;
            @Nullable
            private Object _priority;
            @Nullable
            private String _subnetId;
            @Nullable
            private Object _weightedCapacity;

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withInstanceType(@Nullable String value) {
                this._instanceType = value;
                return this;
            }

            public Builder withMaxPrice(@Nullable String value) {
                this._maxPrice = value;
                return this;
            }

            public Builder withPriority(@Nullable Number value) {
                this._priority = value;
                return this;
            }

            public Builder withPriority(@Nullable Token value) {
                this._priority = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Number value) {
                this._weightedCapacity = value;
                return this;
            }

            public Builder withWeightedCapacity(@Nullable Token value) {
                this._weightedCapacity = value;
                return this;
            }

            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new FleetLaunchTemplateOverridesRequestProperty(){
                    @Nullable
                    private String $availabilityZone;
                    @Nullable
                    private String $instanceType;
                    @Nullable
                    private String $maxPrice;
                    @Nullable
                    private Object $priority;
                    @Nullable
                    private String $subnetId;
                    @Nullable
                    private Object $weightedCapacity;
                    {
                        this.$availabilityZone = _availabilityZone;
                        this.$instanceType = _instanceType;
                        this.$maxPrice = _maxPrice;
                        this.$priority = _priority;
                        this.$subnetId = _subnetId;
                        this.$weightedCapacity = _weightedCapacity;
                    }

                    @Override
                    public String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public void setAvailabilityZone(@Nullable String value) {
                        this.$availabilityZone = value;
                    }

                    @Override
                    public String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public void setInstanceType(@Nullable String value) {
                        this.$instanceType = value;
                    }

                    @Override
                    public String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public void setMaxPrice(@Nullable String value) {
                        this.$maxPrice = value;
                    }

                    @Override
                    public Object getPriority() {
                        return this.$priority;
                    }

                    @Override
                    public void setPriority(@Nullable Number value) {
                        this.$priority = value;
                    }

                    @Override
                    public void setPriority(@Nullable Token value) {
                        this.$priority = value;
                    }

                    @Override
                    public String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public void setSubnetId(@Nullable String value) {
                        this.$subnetId = value;
                    }

                    @Override
                    public Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Number value) {
                        this.$weightedCapacity = value;
                    }

                    @Override
                    public void setWeightedCapacity(@Nullable Token value) {
                        this.$weightedCapacity = value;
                    }
                };
            }
        }
    }

    public static interface FleetLaunchTemplateConfigRequestProperty
    extends JsiiSerializable {
        public Object getLaunchTemplateSpecification();

        public void setLaunchTemplateSpecification(Token var1);

        public void setLaunchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty var1);

        public Object getOverrides();

        public void setOverrides(Token var1);

        public void setOverrides(List<Object> var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _launchTemplateSpecification;
            @Nullable
            private Object _overrides;

            public Builder withLaunchTemplateSpecification(@Nullable Token value) {
                this._launchTemplateSpecification = value;
                return this;
            }

            public Builder withLaunchTemplateSpecification(@Nullable FleetLaunchTemplateSpecificationRequestProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }

            public Builder withOverrides(@Nullable Token value) {
                this._overrides = value;
                return this;
            }

            public Builder withOverrides(@Nullable List<Object> value) {
                this._overrides = value;
                return this;
            }

            public FleetLaunchTemplateConfigRequestProperty build() {
                return new FleetLaunchTemplateConfigRequestProperty(){
                    @Nullable
                    private Object $launchTemplateSpecification;
                    @Nullable
                    private Object $overrides;
                    {
                        this.$launchTemplateSpecification = _launchTemplateSpecification;
                        this.$overrides = _overrides;
                    }

                    @Override
                    public Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@Nullable Token value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public void setLaunchTemplateSpecification(@Nullable FleetLaunchTemplateSpecificationRequestProperty value) {
                        this.$launchTemplateSpecification = value;
                    }

                    @Override
                    public Object getOverrides() {
                        return this.$overrides;
                    }

                    @Override
                    public void setOverrides(@Nullable Token value) {
                        this.$overrides = value;
                    }

                    @Override
                    public void setOverrides(@Nullable List<Object> value) {
                        this.$overrides = value;
                    }
                };
            }
        }
    }
}

