package software.amazon.awscdk.services.ec2;

/**
 * @cloudformationResource AWS::EC2::EC2Fleet
 * A CloudFormation `AWS::EC2::EC2Fleet`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:35:50.681Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet extends software.amazon.awscdk.CfnResource {
    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnEC2Fleet.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnEC2Fleet(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnEC2FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getEc2FleetId() {
        return this.jsiiGet("ec2FleetId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.ec2.CfnEC2FleetProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnEC2FleetProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
     */
    public static interface FleetLaunchTemplateConfigRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
         */
        java.lang.Object getLaunchTemplateSpecification();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
         */
        java.lang.Object getOverrides();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateConfigRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _overrides;

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._overrides = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._overrides = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateConfigRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FleetLaunchTemplateConfigRequestProperty build() {
                return new FleetLaunchTemplateConfigRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchTemplateSpecification = _launchTemplateSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $overrides = _overrides;

                    @Override
                    public java.lang.Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public java.lang.Object getOverrides() {
                        return this.$overrides;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                        obj.set("overrides", om.valueToTree(this.getOverrides()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOverrides() {
                return this.jsiiGet("overrides", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
     */
    public static interface FleetLaunchTemplateOverridesRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
         */
        java.lang.String getMaxPrice();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
         */
        java.lang.Object getPriority();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _maxPrice;
            @javax.annotation.Nullable
            private java.lang.Object _priority;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _weightedCapacity;

            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of MaxPrice
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`
             * @return {@code this}
             */
            public Builder withMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._maxPrice = value;
                return this;
            }
            /**
             * Sets the value of Priority
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`
             * @return {@code this}
             */
            public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
                this._priority = value;
                return this;
            }
            /**
             * Sets the value of Priority
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`
             * @return {@code this}
             */
            public Builder withPriority(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._priority = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateOverridesRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new FleetLaunchTemplateOverridesRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private final java.lang.String $maxPrice = _maxPrice;
                    @javax.annotation.Nullable
                    private final java.lang.Object $priority = _priority;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public java.lang.Object getPriority() {
                        return this.$priority;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public java.lang.Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        obj.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                        obj.set("priority", om.valueToTree(this.getPriority()));
                        obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMaxPrice() {
                return this.jsiiGet("maxPrice", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPriority() {
                return this.jsiiGet("priority", java.lang.Object.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
     */
    public static interface FleetLaunchTemplateSpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
         */
        java.lang.String getLaunchTemplateId();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
         */
        java.lang.String getLaunchTemplateName();
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
         */
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateName;
            @javax.annotation.Nullable
            private java.lang.String _version;

            /**
             * Sets the value of LaunchTemplateId
             * @param value `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`
             * @return {@code this}
             */
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`
             * @return {@code this}
             */
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new FleetLaunchTemplateSpecificationRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateName = _launchTemplateName;
                    @javax.annotation.Nullable
                    private final java.lang.String $version = _version;

                    @Override
                    public java.lang.String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                        obj.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                        obj.set("version", om.valueToTree(this.getVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
     */
    public static interface OnDemandOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
         */
        java.lang.String getAllocationStrategy();

        /**
         * @return a {@link Builder} of {@link OnDemandOptionsRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OnDemandOptionsRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _allocationStrategy;

            /**
             * Sets the value of AllocationStrategy
             * @param value `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`
             * @return {@code this}
             */
            public Builder withAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this._allocationStrategy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OnDemandOptionsRequestProperty build() {
                return new OnDemandOptionsRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $allocationStrategy = _allocationStrategy;

                    @Override
                    public java.lang.String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
     */
    public static interface SpotOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
         */
        java.lang.String getAllocationStrategy();
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
         */
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
         */
        java.lang.Object getInstancePoolsToUseCount();

        /**
         * @return a {@link Builder} of {@link SpotOptionsRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotOptionsRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _allocationStrategy;
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _instancePoolsToUseCount;

            /**
             * Sets the value of AllocationStrategy
             * @param value `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`
             * @return {@code this}
             */
            public Builder withAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this._allocationStrategy = value;
                return this;
            }
            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstancePoolsToUseCount
             * @param value `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`
             * @return {@code this}
             */
            public Builder withInstancePoolsToUseCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._instancePoolsToUseCount = value;
                return this;
            }
            /**
             * Sets the value of InstancePoolsToUseCount
             * @param value `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`
             * @return {@code this}
             */
            public Builder withInstancePoolsToUseCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instancePoolsToUseCount = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotOptionsRequestProperty build() {
                return new SpotOptionsRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $allocationStrategy = _allocationStrategy;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $instancePoolsToUseCount = _instancePoolsToUseCount;

                    @Override
                    public java.lang.String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public java.lang.Object getInstancePoolsToUseCount() {
                        return this.$instancePoolsToUseCount;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                        obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                        obj.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstancePoolsToUseCount() {
                return this.jsiiGet("instancePoolsToUseCount", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html
     */
    public static interface TagRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.TagRequestProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-key
         */
        java.lang.String getKey();
        /**
         * `CfnEC2Fleet.TagRequestProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagRequestProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnEC2Fleet.TagRequestProperty.Key`
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnEC2Fleet.TagRequestProperty.Value`
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagRequestProperty build() {
                return new TagRequestProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.TagRequestProperty.Key`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.TagRequestProperty.Value`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
     */
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
         */
        java.lang.String getResourceType();
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
         */
        java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> _tags;

            /**
             * Sets the value of ResourceType
             * @param value `CfnEC2Fleet.TagSpecificationProperty.ResourceType`
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnEC2Fleet.TagSpecificationProperty.Tags`
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagSpecificationProperty build() {
                return new TagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> getTags() {
                        return this.$tags;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceType", om.valueToTree(this.getResourceType()));
                        obj.set("tags", om.valueToTree(this.getTags()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.TagSpecificationProperty.Tags`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
     */
    public static interface TargetCapacitySpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
         */
        java.lang.Object getTotalTargetCapacity();
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
         */
        java.lang.String getDefaultTargetCapacityType();
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
         */
        java.lang.Object getOnDemandTargetCapacity();
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
         */
        java.lang.Object getSpotTargetCapacity();

        /**
         * @return a {@link Builder} of {@link TargetCapacitySpecificationRequestProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetCapacitySpecificationRequestProperty}
         */
        final class Builder {
            private java.lang.Object _totalTargetCapacity;
            @javax.annotation.Nullable
            private java.lang.String _defaultTargetCapacityType;
            @javax.annotation.Nullable
            private java.lang.Object _onDemandTargetCapacity;
            @javax.annotation.Nullable
            private java.lang.Object _spotTargetCapacity;

            /**
             * Sets the value of TotalTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`
             * @return {@code this}
             */
            public Builder withTotalTargetCapacity(final java.lang.Number value) {
                this._totalTargetCapacity = java.util.Objects.requireNonNull(value, "totalTargetCapacity is required");
                return this;
            }
            /**
             * Sets the value of TotalTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`
             * @return {@code this}
             */
            public Builder withTotalTargetCapacity(final software.amazon.awscdk.Token value) {
                this._totalTargetCapacity = java.util.Objects.requireNonNull(value, "totalTargetCapacity is required");
                return this;
            }
            /**
             * Sets the value of DefaultTargetCapacityType
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`
             * @return {@code this}
             */
            public Builder withDefaultTargetCapacityType(@javax.annotation.Nullable final java.lang.String value) {
                this._defaultTargetCapacityType = value;
                return this;
            }
            /**
             * Sets the value of OnDemandTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`
             * @return {@code this}
             */
            public Builder withOnDemandTargetCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._onDemandTargetCapacity = value;
                return this;
            }
            /**
             * Sets the value of OnDemandTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`
             * @return {@code this}
             */
            public Builder withOnDemandTargetCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onDemandTargetCapacity = value;
                return this;
            }
            /**
             * Sets the value of SpotTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`
             * @return {@code this}
             */
            public Builder withSpotTargetCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._spotTargetCapacity = value;
                return this;
            }
            /**
             * Sets the value of SpotTargetCapacity
             * @param value `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`
             * @return {@code this}
             */
            public Builder withSpotTargetCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._spotTargetCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetCapacitySpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetCapacitySpecificationRequestProperty build() {
                return new TargetCapacitySpecificationRequestProperty() {
                    private final java.lang.Object $totalTargetCapacity = java.util.Objects.requireNonNull(_totalTargetCapacity, "totalTargetCapacity is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $defaultTargetCapacityType = _defaultTargetCapacityType;
                    @javax.annotation.Nullable
                    private final java.lang.Object $onDemandTargetCapacity = _onDemandTargetCapacity;
                    @javax.annotation.Nullable
                    private final java.lang.Object $spotTargetCapacity = _spotTargetCapacity;

                    @Override
                    public java.lang.Object getTotalTargetCapacity() {
                        return this.$totalTargetCapacity;
                    }

                    @Override
                    public java.lang.String getDefaultTargetCapacityType() {
                        return this.$defaultTargetCapacityType;
                    }

                    @Override
                    public java.lang.Object getOnDemandTargetCapacity() {
                        return this.$onDemandTargetCapacity;
                    }

                    @Override
                    public java.lang.Object getSpotTargetCapacity() {
                        return this.$spotTargetCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
                        obj.set("defaultTargetCapacityType", om.valueToTree(this.getDefaultTargetCapacityType()));
                        obj.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                        obj.set("spotTargetCapacity", om.valueToTree(this.getSpotTargetCapacity()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
             */
            @Override
            public java.lang.Object getTotalTargetCapacity() {
                return this.jsiiGet("totalTargetCapacity", java.lang.Object.class);
            }

            /**
             * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDefaultTargetCapacityType() {
                return this.jsiiGet("defaultTargetCapacityType", java.lang.String.class);
            }

            /**
             * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnDemandTargetCapacity() {
                return this.jsiiGet("onDemandTargetCapacity", java.lang.Object.class);
            }

            /**
             * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSpotTargetCapacity() {
                return this.jsiiGet("spotTargetCapacity", java.lang.Object.class);
            }
        }
    }
}
