package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:35:50.868Z")
public interface CfnVPCEndpointProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    java.lang.String getServiceName();
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    java.lang.String getVpcId();
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    java.lang.Object getPolicyDocument();
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    java.lang.Object getPrivateDnsEnabled();
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    java.util.List<java.lang.String> getRouteTableIds();
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    java.util.List<java.lang.String> getSecurityGroupIds();
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    java.util.List<java.lang.String> getSubnetIds();
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    java.lang.String getVpcEndpointType();

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnVPCEndpointProps}
     */
    final class Builder {
        private java.lang.String _serviceName;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.lang.Object _policyDocument;
        @javax.annotation.Nullable
        private java.lang.Object _privateDnsEnabled;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _routeTableIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _securityGroupIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subnetIds;
        @javax.annotation.Nullable
        private java.lang.String _vpcEndpointType;

        /**
         * Sets the value of ServiceName
         * @param value `AWS::EC2::VPCEndpoint.ServiceName`
         * @return {@code this}
         */
        public Builder withServiceName(final java.lang.String value) {
            this._serviceName = java.util.Objects.requireNonNull(value, "serviceName is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value `AWS::EC2::VPCEndpoint.VpcId`
         * @return {@code this}
         */
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of PolicyDocument
         * @param value `AWS::EC2::VPCEndpoint.PolicyDocument`
         * @return {@code this}
         */
        public Builder withPolicyDocument(@javax.annotation.Nullable final com.fasterxml.jackson.databind.node.ObjectNode value) {
            this._policyDocument = value;
            return this;
        }
        /**
         * Sets the value of PolicyDocument
         * @param value `AWS::EC2::VPCEndpoint.PolicyDocument`
         * @return {@code this}
         */
        public Builder withPolicyDocument(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._policyDocument = value;
            return this;
        }
        /**
         * Sets the value of PrivateDnsEnabled
         * @param value `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
         * @return {@code this}
         */
        public Builder withPrivateDnsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privateDnsEnabled = value;
            return this;
        }
        /**
         * Sets the value of PrivateDnsEnabled
         * @param value `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
         * @return {@code this}
         */
        public Builder withPrivateDnsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._privateDnsEnabled = value;
            return this;
        }
        /**
         * Sets the value of RouteTableIds
         * @param value `AWS::EC2::VPCEndpoint.RouteTableIds`
         * @return {@code this}
         */
        public Builder withRouteTableIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._routeTableIds = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupIds
         * @param value `AWS::EC2::VPCEndpoint.SecurityGroupIds`
         * @return {@code this}
         */
        public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._securityGroupIds = value;
            return this;
        }
        /**
         * Sets the value of SubnetIds
         * @param value `AWS::EC2::VPCEndpoint.SubnetIds`
         * @return {@code this}
         */
        public Builder withSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subnetIds = value;
            return this;
        }
        /**
         * Sets the value of VpcEndpointType
         * @param value `AWS::EC2::VPCEndpoint.VpcEndpointType`
         * @return {@code this}
         */
        public Builder withVpcEndpointType(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcEndpointType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnVPCEndpointProps build() {
            return new CfnVPCEndpointProps() {
                private final java.lang.String $serviceName = java.util.Objects.requireNonNull(_serviceName, "serviceName is required");
                private final java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private final java.lang.Object $policyDocument = _policyDocument;
                @javax.annotation.Nullable
                private final java.lang.Object $privateDnsEnabled = _privateDnsEnabled;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $routeTableIds = _routeTableIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $securityGroupIds = _securityGroupIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $subnetIds = _subnetIds;
                @javax.annotation.Nullable
                private final java.lang.String $vpcEndpointType = _vpcEndpointType;

                @Override
                public java.lang.String getServiceName() {
                    return this.$serviceName;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public java.lang.Object getPolicyDocument() {
                    return this.$policyDocument;
                }

                @Override
                public java.lang.Object getPrivateDnsEnabled() {
                    return this.$privateDnsEnabled;
                }

                @Override
                public java.util.List<java.lang.String> getRouteTableIds() {
                    return this.$routeTableIds;
                }

                @Override
                public java.util.List<java.lang.String> getSecurityGroupIds() {
                    return this.$securityGroupIds;
                }

                @Override
                public java.util.List<java.lang.String> getSubnetIds() {
                    return this.$subnetIds;
                }

                @Override
                public java.lang.String getVpcEndpointType() {
                    return this.$vpcEndpointType;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("serviceName", om.valueToTree(this.getServiceName()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
                    obj.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
                    obj.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
                    obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                    obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                    obj.set("vpcEndpointType", om.valueToTree(this.getVpcEndpointType()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnVPCEndpointProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::VPCEndpoint.ServiceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
         */
        @Override
        public java.lang.String getServiceName() {
            return this.jsiiGet("serviceName", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.VpcId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.PolicyDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getPolicyDocument() {
            return this.jsiiGet("policyDocument", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getPrivateDnsEnabled() {
            return this.jsiiGet("privateDnsEnabled", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.RouteTableIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getRouteTableIds() {
            return this.jsiiGet("routeTableIds", java.util.List.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.jsiiGet("securityGroupIds", java.util.List.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.jsiiGet("subnetIds", java.util.List.class);
        }

        /**
         * `AWS::EC2::VPCEndpoint.VpcEndpointType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcEndpointType() {
            return this.jsiiGet("vpcEndpointType", java.lang.String.class);
        }
    }
}
