package software.amazon.awscdk.services.ec2;

/**
 * Creates an Amazon EC2 security group within a VPC.
 * 
 * This class has an additional optimization over imported security groups that it can also create
 * inline ingress and egress rule (which saves on the total number of resources inside
 * the template).
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:35:50.907Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.services.ec2.SecurityGroupBase {
    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public SecurityGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import an existing SecurityGroup
     */
    public static software.amazon.awscdk.services.ec2.ISecurityGroup import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.SecurityGroupImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "import", software.amazon.awscdk.services.ec2.ISecurityGroup.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Add an egress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description, @javax.annotation.Nullable final java.lang.Boolean remoteRule) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)), java.util.stream.Stream.of(remoteRule)).toArray());
    }

    /**
     * Add an egress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Add an egress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addEgressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))).toArray());
    }

    /**
     * Add an ingress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description, @javax.annotation.Nullable final java.lang.Boolean remoteRule) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)), java.util.stream.Stream.of(remoteRule)).toArray());
    }

    /**
     * Add an ingress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))), java.util.stream.Stream.of(description)).toArray());
    }

    /**
     * Add an ingress rule for the current security group
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     */
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addIngressRule", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(peer, "peer is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(connection, "connection is required"))).toArray());
    }

    /**
     * Export this SecurityGroup for use in a different Stack
     */
    @Override
    public software.amazon.awscdk.services.ec2.SecurityGroupImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.ec2.SecurityGroupImportProps.class);
    }

    /**
     * An attribute that represents the security group name.
     */
    public java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    /**
     * The ID of the security group
     */
    @Override
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    /**
     * An attribute that represents the physical VPC ID this security group is part of.
     */
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }
}
