/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnVPCEndpointProps
extends JsiiSerializable {
    public String getServiceName();

    public String getVpcId();

    public Object getPolicyDocument();

    public Object getPrivateDnsEnabled();

    public List<String> getRouteTableIds();

    public List<String> getSecurityGroupIds();

    public List<String> getSubnetIds();

    public String getVpcEndpointType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _serviceName;
        private String _vpcId;
        @Nullable
        private Object _policyDocument;
        @Nullable
        private Object _privateDnsEnabled;
        @Nullable
        private List<String> _routeTableIds;
        @Nullable
        private List<String> _securityGroupIds;
        @Nullable
        private List<String> _subnetIds;
        @Nullable
        private String _vpcEndpointType;

        public Builder withServiceName(String value) {
            this._serviceName = Objects.requireNonNull(value, "serviceName is required");
            return this;
        }

        public Builder withVpcId(String value) {
            this._vpcId = Objects.requireNonNull(value, "vpcId is required");
            return this;
        }

        public Builder withPolicyDocument(@Nullable ObjectNode value) {
            this._policyDocument = value;
            return this;
        }

        public Builder withPolicyDocument(@Nullable Token value) {
            this._policyDocument = value;
            return this;
        }

        public Builder withPrivateDnsEnabled(@Nullable Boolean value) {
            this._privateDnsEnabled = value;
            return this;
        }

        public Builder withPrivateDnsEnabled(@Nullable Token value) {
            this._privateDnsEnabled = value;
            return this;
        }

        public Builder withRouteTableIds(@Nullable List<String> value) {
            this._routeTableIds = value;
            return this;
        }

        public Builder withSecurityGroupIds(@Nullable List<String> value) {
            this._securityGroupIds = value;
            return this;
        }

        public Builder withSubnetIds(@Nullable List<String> value) {
            this._subnetIds = value;
            return this;
        }

        public Builder withVpcEndpointType(@Nullable String value) {
            this._vpcEndpointType = value;
            return this;
        }

        public CfnVPCEndpointProps build() {
            return new CfnVPCEndpointProps(){
                private final String $serviceName;
                private final String $vpcId;
                @Nullable
                private final Object $policyDocument;
                @Nullable
                private final Object $privateDnsEnabled;
                @Nullable
                private final List<String> $routeTableIds;
                @Nullable
                private final List<String> $securityGroupIds;
                @Nullable
                private final List<String> $subnetIds;
                @Nullable
                private final String $vpcEndpointType;
                {
                    this.$serviceName = Objects.requireNonNull(_serviceName, "serviceName is required");
                    this.$vpcId = Objects.requireNonNull(_vpcId, "vpcId is required");
                    this.$policyDocument = _policyDocument;
                    this.$privateDnsEnabled = _privateDnsEnabled;
                    this.$routeTableIds = _routeTableIds;
                    this.$securityGroupIds = _securityGroupIds;
                    this.$subnetIds = _subnetIds;
                    this.$vpcEndpointType = _vpcEndpointType;
                }

                @Override
                public String getServiceName() {
                    return this.$serviceName;
                }

                @Override
                public String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public Object getPolicyDocument() {
                    return this.$policyDocument;
                }

                @Override
                public Object getPrivateDnsEnabled() {
                    return this.$privateDnsEnabled;
                }

                @Override
                public List<String> getRouteTableIds() {
                    return this.$routeTableIds;
                }

                @Override
                public List<String> getSecurityGroupIds() {
                    return this.$securityGroupIds;
                }

                @Override
                public List<String> getSubnetIds() {
                    return this.$subnetIds;
                }

                @Override
                public String getVpcEndpointType() {
                    return this.$vpcEndpointType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("serviceName", om.valueToTree((Object)this.getServiceName()));
                    obj.set("vpcId", om.valueToTree((Object)this.getVpcId()));
                    obj.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
                    obj.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
                    obj.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
                    obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                    obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                    obj.set("vpcEndpointType", om.valueToTree((Object)this.getVpcEndpointType()));
                    return obj;
                }
            };
        }
    }
}

