/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.VpnTunnelOption;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface VpnConnectionOptions
extends JsiiSerializable {
    public String getIp();

    public Number getAsn();

    public List<String> getStaticRoutes();

    public List<VpnTunnelOption> getTunnelOptions();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _ip;
        @Nullable
        private Number _asn;
        @Nullable
        private List<String> _staticRoutes;
        @Nullable
        private List<VpnTunnelOption> _tunnelOptions;

        public Builder withIp(String value) {
            this._ip = Objects.requireNonNull(value, "ip is required");
            return this;
        }

        public Builder withAsn(@Nullable Number value) {
            this._asn = value;
            return this;
        }

        public Builder withStaticRoutes(@Nullable List<String> value) {
            this._staticRoutes = value;
            return this;
        }

        public Builder withTunnelOptions(@Nullable List<VpnTunnelOption> value) {
            this._tunnelOptions = value;
            return this;
        }

        public VpnConnectionOptions build() {
            return new VpnConnectionOptions(){
                private final String $ip;
                @Nullable
                private final Number $asn;
                @Nullable
                private final List<String> $staticRoutes;
                @Nullable
                private final List<VpnTunnelOption> $tunnelOptions;
                {
                    this.$ip = Objects.requireNonNull(_ip, "ip is required");
                    this.$asn = _asn;
                    this.$staticRoutes = _staticRoutes;
                    this.$tunnelOptions = _tunnelOptions;
                }

                @Override
                public String getIp() {
                    return this.$ip;
                }

                @Override
                public Number getAsn() {
                    return this.$asn;
                }

                @Override
                public List<String> getStaticRoutes() {
                    return this.$staticRoutes;
                }

                @Override
                public List<VpnTunnelOption> getTunnelOptions() {
                    return this.$tunnelOptions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("ip", om.valueToTree((Object)this.getIp()));
                    obj.set("asn", om.valueToTree((Object)this.getAsn()));
                    obj.set("staticRoutes", om.valueToTree(this.getStaticRoutes()));
                    obj.set("tunnelOptions", om.valueToTree(this.getTunnelOptions()));
                    return obj;
                }
            };
        }
    }
}

