package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Host`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:46.535Z")
public interface CfnHostProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    java.lang.String getAvailabilityZone();
    /**
     * `AWS::EC2::Host.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    java.lang.String getInstanceType();
    /**
     * `AWS::EC2::Host.AutoPlacement`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    java.lang.String getAutoPlacement();

    /**
     * @return a {@link Builder} of {@link CfnHostProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnHostProps}
     */
    final class Builder {
        private java.lang.String _availabilityZone;
        private java.lang.String _instanceType;
        @javax.annotation.Nullable
        private java.lang.String _autoPlacement;

        /**
         * Sets the value of AvailabilityZone
         * @param value `AWS::EC2::Host.AvailabilityZone`.
         * @return {@code this}
         */
        public Builder withAvailabilityZone(final java.lang.String value) {
            this._availabilityZone = java.util.Objects.requireNonNull(value, "availabilityZone is required");
            return this;
        }
        /**
         * Sets the value of InstanceType
         * @param value `AWS::EC2::Host.InstanceType`.
         * @return {@code this}
         */
        public Builder withInstanceType(final java.lang.String value) {
            this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
            return this;
        }
        /**
         * Sets the value of AutoPlacement
         * @param value `AWS::EC2::Host.AutoPlacement`.
         * @return {@code this}
         */
        public Builder withAutoPlacement(@javax.annotation.Nullable final java.lang.String value) {
            this._autoPlacement = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnHostProps build() {
            return new CfnHostProps() {
                private final java.lang.String $availabilityZone = java.util.Objects.requireNonNull(_availabilityZone, "availabilityZone is required");
                private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                @javax.annotation.Nullable
                private final java.lang.String $autoPlacement = _autoPlacement;

                @Override
                public java.lang.String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public java.lang.String getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public java.lang.String getAutoPlacement() {
                    return this.$autoPlacement;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                    obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                    obj.set("autoPlacement", om.valueToTree(this.getAutoPlacement()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnHostProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::Host.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
         */
        @Override
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Host.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
         */
        @Override
        public java.lang.String getInstanceType() {
            return this.jsiiGet("instanceType", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Host.AutoPlacement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAutoPlacement() {
            return this.jsiiGet("autoPlacement", java.lang.String.class);
        }
    }
}
