package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkInterfacePermission`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:46.603Z")
public interface CfnNetworkInterfacePermissionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    java.lang.String getAwsAccountId();
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    java.lang.String getNetworkInterfaceId();
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    java.lang.String getPermission();

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfacePermissionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnNetworkInterfacePermissionProps}
     */
    final class Builder {
        private java.lang.String _awsAccountId;
        private java.lang.String _networkInterfaceId;
        private java.lang.String _permission;

        /**
         * Sets the value of AwsAccountId
         * @param value `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
         * @return {@code this}
         */
        public Builder withAwsAccountId(final java.lang.String value) {
            this._awsAccountId = java.util.Objects.requireNonNull(value, "awsAccountId is required");
            return this;
        }
        /**
         * Sets the value of NetworkInterfaceId
         * @param value `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
         * @return {@code this}
         */
        public Builder withNetworkInterfaceId(final java.lang.String value) {
            this._networkInterfaceId = java.util.Objects.requireNonNull(value, "networkInterfaceId is required");
            return this;
        }
        /**
         * Sets the value of Permission
         * @param value `AWS::EC2::NetworkInterfacePermission.Permission`.
         * @return {@code this}
         */
        public Builder withPermission(final java.lang.String value) {
            this._permission = java.util.Objects.requireNonNull(value, "permission is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfacePermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnNetworkInterfacePermissionProps build() {
            return new CfnNetworkInterfacePermissionProps() {
                private final java.lang.String $awsAccountId = java.util.Objects.requireNonNull(_awsAccountId, "awsAccountId is required");
                private final java.lang.String $networkInterfaceId = java.util.Objects.requireNonNull(_networkInterfaceId, "networkInterfaceId is required");
                private final java.lang.String $permission = java.util.Objects.requireNonNull(_permission, "permission is required");

                @Override
                public java.lang.String getAwsAccountId() {
                    return this.$awsAccountId;
                }

                @Override
                public java.lang.String getNetworkInterfaceId() {
                    return this.$networkInterfaceId;
                }

                @Override
                public java.lang.String getPermission() {
                    return this.$permission;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                    obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                    obj.set("permission", om.valueToTree(this.getPermission()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkInterfacePermissionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
         */
        @Override
        public java.lang.String getAwsAccountId() {
            return this.jsiiGet("awsAccountId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
         */
        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.jsiiGet("networkInterfaceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::NetworkInterfacePermission.Permission`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
         */
        @Override
        public java.lang.String getPermission() {
            return this.jsiiGet("permission", java.lang.String.class);
        }
    }
}
