package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SecurityGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:46.626Z")
public interface CfnSecurityGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    java.lang.String getGroupDescription();
    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    java.lang.String getGroupName();
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    java.lang.Object getSecurityGroupEgress();
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    java.lang.Object getSecurityGroupIngress();
    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();
    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    java.lang.String getVpcId();

    /**
     * @return a {@link Builder} of {@link CfnSecurityGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnSecurityGroupProps}
     */
    final class Builder {
        private java.lang.String _groupDescription;
        @javax.annotation.Nullable
        private java.lang.String _groupName;
        @javax.annotation.Nullable
        private java.lang.Object _securityGroupEgress;
        @javax.annotation.Nullable
        private java.lang.Object _securityGroupIngress;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;
        @javax.annotation.Nullable
        private java.lang.String _vpcId;

        /**
         * Sets the value of GroupDescription
         * @param value `AWS::EC2::SecurityGroup.GroupDescription`.
         * @return {@code this}
         */
        public Builder withGroupDescription(final java.lang.String value) {
            this._groupDescription = java.util.Objects.requireNonNull(value, "groupDescription is required");
            return this;
        }
        /**
         * Sets the value of GroupName
         * @param value `AWS::EC2::SecurityGroup.GroupName`.
         * @return {@code this}
         */
        public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._groupName = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupEgress
         * @param value `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
         * @return {@code this}
         */
        public Builder withSecurityGroupEgress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._securityGroupEgress = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupEgress
         * @param value `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
         * @return {@code this}
         */
        public Builder withSecurityGroupEgress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._securityGroupEgress = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupIngress
         * @param value `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
         * @return {@code this}
         */
        public Builder withSecurityGroupIngress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._securityGroupIngress = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupIngress
         * @param value `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
         * @return {@code this}
         */
        public Builder withSecurityGroupIngress(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._securityGroupIngress = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::EC2::SecurityGroup.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value `AWS::EC2::SecurityGroup.VpcId`.
         * @return {@code this}
         */
        public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnSecurityGroupProps build() {
            return new CfnSecurityGroupProps() {
                private final java.lang.String $groupDescription = java.util.Objects.requireNonNull(_groupDescription, "groupDescription is required");
                @javax.annotation.Nullable
                private final java.lang.String $groupName = _groupName;
                @javax.annotation.Nullable
                private final java.lang.Object $securityGroupEgress = _securityGroupEgress;
                @javax.annotation.Nullable
                private final java.lang.Object $securityGroupIngress = _securityGroupIngress;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;
                @javax.annotation.Nullable
                private final java.lang.String $vpcId = _vpcId;

                @Override
                public java.lang.String getGroupDescription() {
                    return this.$groupDescription;
                }

                @Override
                public java.lang.String getGroupName() {
                    return this.$groupName;
                }

                @Override
                public java.lang.Object getSecurityGroupEgress() {
                    return this.$securityGroupEgress;
                }

                @Override
                public java.lang.Object getSecurityGroupIngress() {
                    return this.$securityGroupIngress;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("groupDescription", om.valueToTree(this.getGroupDescription()));
                    obj.set("groupName", om.valueToTree(this.getGroupName()));
                    obj.set("securityGroupEgress", om.valueToTree(this.getSecurityGroupEgress()));
                    obj.set("securityGroupIngress", om.valueToTree(this.getSecurityGroupIngress()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::SecurityGroup.GroupDescription`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         */
        @Override
        public java.lang.String getGroupDescription() {
            return this.jsiiGet("groupDescription", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroup.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getSecurityGroupEgress() {
            return this.jsiiGet("securityGroupEgress", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getSecurityGroupIngress() {
            return this.jsiiGet("securityGroupIngress", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::SecurityGroup.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * `AWS::EC2::SecurityGroup.VpcId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }
    }
}
