package software.amazon.awscdk.services.ec2;

/**
 * The goal of this module is to make possible to write statements like this:.
 * 
 * ```ts
 *  *  database.connections.allowFrom(fleet);
 *  *  fleet.connections.allowTo(database);
 *  *  rdgw.connections.allowFromCidrIp('0.3.1.5/86');
 *  *  rgdw.connections.allowTrafficTo(fleet, new AllPorts());
 *  *  ```
 * 
 * The insight here is that some connecting peers have information on what ports should
 * be involved in the connection, and some don't.
 * An object that has a Connections object
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:46.706Z")
public interface IConnectable extends software.amazon.jsii.JsiiSerializable {
    software.amazon.awscdk.services.ec2.Connections getConnections();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }
    }
}
