package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a VPC to be built.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:03:46.726Z")
public interface SubnetConfiguration extends software.amazon.jsii.JsiiSerializable {
    /**
     * The common Logical Name for the `VpcSubnet`.
     * 
     * This name will be suffixed with an integer correlating to a specific
     * availability zone.
     */
    java.lang.String getName();
    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();
    /**
     * The CIDR Mask or the number of leading 1 bits in the routing mask.
     * 
     * Valid values are 16 - 28
     */
    java.lang.Number getCidrMask();
    /**
     * Controls if subnet IP space needs to be reserved.
     * 
     * When true, the IP space for the subnet is reserved but no actual
     * resources are provisioned. This space is only dependent on the
     * number of availibility zones and on `cidrMask` - all other subnet
     * properties are ignored.
     * 
     * Default: false
     */
    java.lang.Boolean getReserved();

    /**
     * @return a {@link Builder} of {@link SubnetConfiguration}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SubnetConfiguration}
     */
    final class Builder {
        private java.lang.String _name;
        private software.amazon.awscdk.services.ec2.SubnetType _subnetType;
        @javax.annotation.Nullable
        private java.lang.Number _cidrMask;
        @javax.annotation.Nullable
        private java.lang.Boolean _reserved;

        /**
         * Sets the value of Name
         * @param value The common Logical Name for the `VpcSubnet`.
         * @return {@code this}
         */
        public Builder withName(final java.lang.String value) {
            this._name = java.util.Objects.requireNonNull(value, "name is required");
            return this;
        }
        /**
         * Sets the value of SubnetType
         * @param value The type of Subnet to configure.
         * @return {@code this}
         */
        public Builder withSubnetType(final software.amazon.awscdk.services.ec2.SubnetType value) {
            this._subnetType = java.util.Objects.requireNonNull(value, "subnetType is required");
            return this;
        }
        /**
         * Sets the value of CidrMask
         * @param value The CIDR Mask or the number of leading 1 bits in the routing mask.
         * @return {@code this}
         */
        public Builder withCidrMask(@javax.annotation.Nullable final java.lang.Number value) {
            this._cidrMask = value;
            return this;
        }
        /**
         * Sets the value of Reserved
         * @param value Controls if subnet IP space needs to be reserved.
         * @return {@code this}
         */
        public Builder withReserved(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._reserved = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SubnetConfiguration build() {
            return new SubnetConfiguration() {
                private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                private final software.amazon.awscdk.services.ec2.SubnetType $subnetType = java.util.Objects.requireNonNull(_subnetType, "subnetType is required");
                @javax.annotation.Nullable
                private final java.lang.Number $cidrMask = _cidrMask;
                @javax.annotation.Nullable
                private final java.lang.Boolean $reserved = _reserved;

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
                    return this.$subnetType;
                }

                @Override
                public java.lang.Number getCidrMask() {
                    return this.$cidrMask;
                }

                @Override
                public java.lang.Boolean getReserved() {
                    return this.$reserved;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree(this.getName()));
                    obj.set("subnetType", om.valueToTree(this.getSubnetType()));
                    obj.set("cidrMask", om.valueToTree(this.getCidrMask()));
                    obj.set("reserved", om.valueToTree(this.getReserved()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SubnetConfiguration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The common Logical Name for the `VpcSubnet`.
         * 
         * This name will be suffixed with an integer correlating to a specific
         * availability zone.
         */
        @Override
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The type of Subnet to configure.
         * 
         * The Subnet type will control the ability to route and connect to the
         * Internet.
         */
        @Override
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }

        /**
         * The CIDR Mask or the number of leading 1 bits in the routing mask.
         * 
         * Valid values are 16 - 28
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getCidrMask() {
            return this.jsiiGet("cidrMask", java.lang.Number.class);
        }

        /**
         * Controls if subnet IP space needs to be reserved.
         * 
         * When true, the IP space for the subnet is reserved but no actual
         * resources are provisioned. This space is only dependent on the
         * number of availibility zones and on `cidrMask` - all other subnet
         * properties are ignored.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getReserved() {
            return this.jsiiGet("reserved", java.lang.Boolean.class);
        }
    }
}
