package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Route`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:01.923Z")
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Route.RouteTableId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    java.lang.String getRouteTableId();
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    java.lang.String getDestinationCidrBlock();
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    java.lang.String getDestinationIpv6CidrBlock();
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    java.lang.String getEgressOnlyInternetGatewayId();
    /**
     * `AWS::EC2::Route.GatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    java.lang.String getGatewayId();
    /**
     * `AWS::EC2::Route.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    java.lang.String getInstanceId();
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    java.lang.String getNatGatewayId();
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    java.lang.String getNetworkInterfaceId();
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    java.lang.String getVpcPeeringConnectionId();

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRouteProps}
     */
    final class Builder {
        private java.lang.String _routeTableId;
        @javax.annotation.Nullable
        private java.lang.String _destinationCidrBlock;
        @javax.annotation.Nullable
        private java.lang.String _destinationIpv6CidrBlock;
        @javax.annotation.Nullable
        private java.lang.String _egressOnlyInternetGatewayId;
        @javax.annotation.Nullable
        private java.lang.String _gatewayId;
        @javax.annotation.Nullable
        private java.lang.String _instanceId;
        @javax.annotation.Nullable
        private java.lang.String _natGatewayId;
        @javax.annotation.Nullable
        private java.lang.String _networkInterfaceId;
        @javax.annotation.Nullable
        private java.lang.String _vpcPeeringConnectionId;

        /**
         * Sets the value of RouteTableId
         * @param value `AWS::EC2::Route.RouteTableId`.
         * @return {@code this}
         */
        public Builder withRouteTableId(final java.lang.String value) {
            this._routeTableId = java.util.Objects.requireNonNull(value, "routeTableId is required");
            return this;
        }
        /**
         * Sets the value of DestinationCidrBlock
         * @param value `AWS::EC2::Route.DestinationCidrBlock`.
         * @return {@code this}
         */
        public Builder withDestinationCidrBlock(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationCidrBlock = value;
            return this;
        }
        /**
         * Sets the value of DestinationIpv6CidrBlock
         * @param value `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * @return {@code this}
         */
        public Builder withDestinationIpv6CidrBlock(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationIpv6CidrBlock = value;
            return this;
        }
        /**
         * Sets the value of EgressOnlyInternetGatewayId
         * @param value `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * @return {@code this}
         */
        public Builder withEgressOnlyInternetGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._egressOnlyInternetGatewayId = value;
            return this;
        }
        /**
         * Sets the value of GatewayId
         * @param value `AWS::EC2::Route.GatewayId`.
         * @return {@code this}
         */
        public Builder withGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._gatewayId = value;
            return this;
        }
        /**
         * Sets the value of InstanceId
         * @param value `AWS::EC2::Route.InstanceId`.
         * @return {@code this}
         */
        public Builder withInstanceId(@javax.annotation.Nullable final java.lang.String value) {
            this._instanceId = value;
            return this;
        }
        /**
         * Sets the value of NatGatewayId
         * @param value `AWS::EC2::Route.NatGatewayId`.
         * @return {@code this}
         */
        public Builder withNatGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._natGatewayId = value;
            return this;
        }
        /**
         * Sets the value of NetworkInterfaceId
         * @param value `AWS::EC2::Route.NetworkInterfaceId`.
         * @return {@code this}
         */
        public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
            this._networkInterfaceId = value;
            return this;
        }
        /**
         * Sets the value of VpcPeeringConnectionId
         * @param value `AWS::EC2::Route.VpcPeeringConnectionId`.
         * @return {@code this}
         */
        public Builder withVpcPeeringConnectionId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcPeeringConnectionId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnRouteProps build() {
            return new CfnRouteProps() {
                private final java.lang.String $routeTableId = java.util.Objects.requireNonNull(_routeTableId, "routeTableId is required");
                @javax.annotation.Nullable
                private final java.lang.String $destinationCidrBlock = _destinationCidrBlock;
                @javax.annotation.Nullable
                private final java.lang.String $destinationIpv6CidrBlock = _destinationIpv6CidrBlock;
                @javax.annotation.Nullable
                private final java.lang.String $egressOnlyInternetGatewayId = _egressOnlyInternetGatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $gatewayId = _gatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $instanceId = _instanceId;
                @javax.annotation.Nullable
                private final java.lang.String $natGatewayId = _natGatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                @javax.annotation.Nullable
                private final java.lang.String $vpcPeeringConnectionId = _vpcPeeringConnectionId;

                @Override
                public java.lang.String getRouteTableId() {
                    return this.$routeTableId;
                }

                @Override
                public java.lang.String getDestinationCidrBlock() {
                    return this.$destinationCidrBlock;
                }

                @Override
                public java.lang.String getDestinationIpv6CidrBlock() {
                    return this.$destinationIpv6CidrBlock;
                }

                @Override
                public java.lang.String getEgressOnlyInternetGatewayId() {
                    return this.$egressOnlyInternetGatewayId;
                }

                @Override
                public java.lang.String getGatewayId() {
                    return this.$gatewayId;
                }

                @Override
                public java.lang.String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public java.lang.String getNatGatewayId() {
                    return this.$natGatewayId;
                }

                @Override
                public java.lang.String getNetworkInterfaceId() {
                    return this.$networkInterfaceId;
                }

                @Override
                public java.lang.String getVpcPeeringConnectionId() {
                    return this.$vpcPeeringConnectionId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("routeTableId", om.valueToTree(this.getRouteTableId()));
                    obj.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
                    obj.set("destinationIpv6CidrBlock", om.valueToTree(this.getDestinationIpv6CidrBlock()));
                    obj.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));
                    obj.set("gatewayId", om.valueToTree(this.getGatewayId()));
                    obj.set("instanceId", om.valueToTree(this.getInstanceId()));
                    obj.set("natGatewayId", om.valueToTree(this.getNatGatewayId()));
                    obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                    obj.set("vpcPeeringConnectionId", om.valueToTree(this.getVpcPeeringConnectionId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnRouteProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::Route.RouteTableId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
         */
        @Override
        public java.lang.String getRouteTableId() {
            return this.jsiiGet("routeTableId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.DestinationCidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDestinationCidrBlock() {
            return this.jsiiGet("destinationCidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDestinationIpv6CidrBlock() {
            return this.jsiiGet("destinationIpv6CidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getEgressOnlyInternetGatewayId() {
            return this.jsiiGet("egressOnlyInternetGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.GatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getGatewayId() {
            return this.jsiiGet("gatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.InstanceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getInstanceId() {
            return this.jsiiGet("instanceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.NatGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getNatGatewayId() {
            return this.jsiiGet("natGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getNetworkInterfaceId() {
            return this.jsiiGet("networkInterfaceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.VpcPeeringConnectionId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcPeeringConnectionId() {
            return this.jsiiGet("vpcPeeringConnectionId", java.lang.String.class);
        }
    }
}
